/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.igdunits;

import com.stratadata.model3.scheme.Boundary;
import javax.swing.GroupLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import jsbugs.uiutil.DecimalTextField;
import jsbugs.uiutil.EnumCombo;
import jsbugs.uiutil.TextFieldUtils;
import model3.LithostratUnit;
import util.InvalidFieldException;

public class PanelLithostratUnitEastWest
extends JPanel {
    private Position position = Position.YONGEST;
    private EnumCombo comboBoundary;
    private DecimalTextField decimalTextFieldEast;
    private DecimalTextField decimalTextFieldWest;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JTextField jTextFieldEastXint;
    private JTextField jTextFieldWestXint;

    public PanelLithostratUnitEastWest() {
        this.initComponents();
        this.comboBoundary.init(Boundary.class);
        TextFieldUtils.updateTextFieldToIntegerOnly(this.jTextFieldEastXint, false, 100L);
        TextFieldUtils.updateTextFieldToIntegerOnly(this.jTextFieldWestXint, false, 100L);
        this.decimalTextFieldEast.init(false, (Double)Double.MAX_VALUE, 5);
        this.decimalTextFieldWest.init(false, (Double)Double.MAX_VALUE, 5);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jTextFieldEastXint = new JTextField();
        this.jLabel4 = new JLabel();
        this.jTextFieldWestXint = new JTextField();
        this.jLabel5 = new JLabel();
        this.comboBoundary = new EnumCombo();
        this.decimalTextFieldWest = new DecimalTextField();
        this.decimalTextFieldEast = new DecimalTextField();
        this.jLabel1.setText("West");
        this.jLabel2.setText("East");
        this.jLabel3.setText("%E");
        this.jTextFieldEastXint.setColumns(5);
        this.jLabel4.setText("%E");
        this.jTextFieldWestXint.setColumns(5);
        this.jLabel5.setText("Boundary");
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.comboBoundary, -1, -1, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel1).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.decimalTextFieldWest, -1, 89, Short.MAX_VALUE).addComponent(this.decimalTextFieldEast, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jTextFieldWestXint, -2, -1, -2).addComponent(this.jTextFieldEastXint, -2, -1, -2)))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.jLabel3).addComponent(this.jTextFieldWestXint, -2, -1, -2).addComponent(this.decimalTextFieldWest, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jLabel4).addComponent(this.jTextFieldEastXint, -2, -1, -2).addComponent(this.decimalTextFieldEast, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel5).addComponent(this.comboBoundary, -2, -1, -2)).addContainerGap()));
    }

    public void setPosition(Position pos) {
        this.position = pos;
    }

    public void populateFromUnit(LithostratUnit unit) {
        Boundary boundary;
        int westPos;
        int eastPos;
        if (this.position == Position.YONGEST) {
            eastPos = 1;
            westPos = 0;
            boundary = unit.getUBnd();
        } else {
            eastPos = 2;
            westPos = 3;
            boundary = unit.getLBnd();
        }
        double east = unit.getAge(eastPos);
        double west = unit.getAge(westPos);
        int eastXint = Math.round(unit.getX(eastPos) * 100.0f);
        int westXint = Math.round(unit.getX(westPos) * 100.0f);
        this.comboBoundary.setSelectedItem(boundary);
        this.decimalTextFieldEast.setDoubleValue(east);
        this.jTextFieldEastXint.setText("" + eastXint);
        this.decimalTextFieldWest.setDoubleValue(west);
        this.jTextFieldWestXint.setText("" + westXint);
    }

    void populateFromBuilder(LithostratUnit.Builder builder) {
        Boundary boundary;
        int westPos;
        int eastPos;
        if (this.position == Position.YONGEST) {
            eastPos = 1;
            westPos = 0;
            boundary = builder.getUBnd();
        } else {
            eastPos = 2;
            westPos = 3;
            boundary = builder.getLBnd();
        }
        double east = builder.getAge(eastPos);
        double west = builder.getAge(westPos);
        int eastXint = Math.round(builder.getX(eastPos) * 100.0f);
        int westXint = Math.round(builder.getX(westPos) * 100.0f);
        this.comboBoundary.setSelectedItem(boundary);
        this.decimalTextFieldEast.setDoubleValue(east);
        this.jTextFieldEastXint.setText("" + eastXint);
        this.decimalTextFieldWest.setDoubleValue(west);
        this.jTextFieldWestXint.setText("" + westXint);
    }

    void updateBuilder(LithostratUnit.Builder builder) {
        boolean upperBnd;
        int westPos;
        int eastPos;
        if (this.position == Position.YONGEST) {
            eastPos = 1;
            westPos = 0;
            upperBnd = true;
        } else {
            eastPos = 2;
            westPos = 3;
            upperBnd = false;
        }
        builder.bnd(upperBnd, (Boundary)this.comboBoundary.getSelectedItem());
        builder.age(eastPos, this.decimalTextFieldEast.getDoubleValue());
        builder.age(westPos, this.decimalTextFieldWest.getDoubleValue());
        builder.x(eastPos, (float)Integer.parseInt(this.jTextFieldEastXint.getText()) / 100.0f);
        builder.x(westPos, (float)Integer.parseInt(this.jTextFieldWestXint.getText()) / 100.0f);
    }

    public void validateInputs() throws InvalidFieldException {
        String desc;
        String string = desc = this.position == Position.YONGEST ? "Youngest" : "Oldest";
        if (this.decimalTextFieldEast.getText().length() <= 0) {
            throw new InvalidFieldException(desc + " East value can't be empty.");
        }
        if (this.decimalTextFieldWest.getText().length() <= 0) {
            throw new InvalidFieldException(desc + " West value can't be empty.");
        }
        if (this.jTextFieldEastXint.getText().length() <= 0) {
            throw new InvalidFieldException(desc + " East %E value can't be empty.");
        }
        if (this.jTextFieldWestXint.getText().length() <= 0) {
            throw new InvalidFieldException(desc + " West %E value can't be empty.");
        }
    }

    public static enum Position {
        YONGEST,
        OLDEST;

    }
}

