/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagegallery;

import com.stratadata.model3.image.OccurrenceImage;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import com.stratadata.util.io.FileChooserUtils;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Desktop;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Window;
import java.awt.print.PageFormat;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import jsbchart.graphics.DimensionF;
import jsbugs.ChartExporter;
import jsbugs.DialogPrintPreview;
import jsbugs.FrameJsbugs;
import jsbugs.PDFExporter;
import jsbugs.PrintJPanel;
import jsbugs.SBPrint;
import jsbugs.imagegallery.DialogPrintImageGallery;
import jsbugs.imagegallery.ImageGalleryPrintProperties;
import jsbugs.imagegallery.TaxonImageGallery;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.apache.fop.configuration.ConfigurationException;
import org.apache.fop.svg.PDFDocumentGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.util.UnitConv;
import org.w3c.dom.Document;

public class TaxonImageGalleryPrint
extends SBPrint {
    private static final double scale = 0.5;
    private static final int pad = 8;
    private static int TINY_FONY_SIZE = 8;
    private static final Font fontBoldHdr = new Font("Arial", 1, 22);
    private static final Font fontCaption = new Font("Arial", 0, 14);
    private static final Font fontTiny = new Font("Arial", 0, TINY_FONY_SIZE);
    private static final Logger LOGGER = Logger.getLogger(TaxonImageGalleryPrint.class.getName());
    private final TaxonImageGallery gallery;
    private final ImageGalleryPrintProperties p;
    private final TaxonService taxonService;
    private final String title;
    private int imagesPerPage = 0;
    private int pages = 1;

    public TaxonImageGalleryPrint(TaxonImageGallery gallery, ImageGalleryPrintProperties p, TaxonService taxonService, String title) {
        this.gallery = gallery;
        this.p = p;
        this.taxonService = taxonService;
        this.title = title;
    }

    public ImageGalleryPrintProperties getPrintProperties() {
        return this.p;
    }

    @Override
    public int getnPages(int height, int width) {
        int nImages = this.gallery.getTotalImageCount(this.p.showAllImagesInSet());
        if (nImages == 0) {
            return 0;
        }
        int gridSize = this.getGridSize();
        this.imagesPerPage = (int)Math.pow(gridSize, 2.0);
        this.pages = 0;
        int done = 0;
        while (done < nImages) {
            done += this.imagesPerPage;
            ++this.pages;
        }
        return this.pages;
    }

    private int getGridSize() {
        return switch (this.p.imageSize()) {
            default -> throw new MatchException(null, null);
            case ImageGalleryPrintProperties.ImageSize.S -> 4;
            case ImageGalleryPrintProperties.ImageSize.M -> 3;
            case ImageGalleryPrintProperties.ImageSize.L -> 2;
        };
    }

    @Override
    public void draw(Graphics graphics, int x, int y, int unscaledWidth, int unscaledHeight, int pageIndex) {
        Graphics2D g = (Graphics2D)graphics;
        g.scale(0.5, 0.5);
        int width = (int)((double)unscaledWidth / 0.5);
        int height = (int)((double)unscaledHeight / 0.5);
        int yPos = this.drawHeader(g, x, y, width, height, pageIndex);
        int gridSize = this.getGridSize();
        int boxWidth = width / gridSize;
        int boxHeight = (height - (yPos - y)) / gridSize;
        int xref = 0;
        int yref = 0;
        int startIndex = pageIndex * this.imagesPerPage;
        int endIndex = startIndex + this.imagesPerPage;
        g.setFont(fontCaption);
        FontMetrics fm = g.getFontMetrics();
        int captionLines = 0;
        int iterations = 0;
        List<TaxonImageGallery.GalleryImage> galleryImages = this.gallery.getGalleryImages(this.p.showAllImagesInSet());
        galleryImages = switch (this.p.getSortOrder()) {
            case ImageGalleryPrintProperties.Sort.TAXON -> galleryImages.stream().sorted(Comparator.comparing(gi -> (Taxon)this.taxonService.findTaxon(gi.imageSet().getSpecID()).get())).toList();
            case ImageGalleryPrintProperties.Sort.CAPTION -> galleryImages.stream().sorted(Comparator.comparing(gi -> gi.imageRecord().caption())).toList();
            default -> galleryImages;
        };
        try {
            while (iterations < 2) {
                xref = 0;
                yref = 0;
                int n = -1;
                int captionHeight = fm.getHeight() * captionLines + 8;
                Dimension imageDimension = new Dimension(boxWidth - 16, boxHeight - 16 - captionHeight - TINY_FONY_SIZE);
                for (TaxonImageGallery.GalleryImage gi2 : galleryImages) {
                    if (++n < startIndex || n >= endIndex) continue;
                    List<String> captionLinesForImage = this.getCaptionLines(gi2, g, x + xref * boxWidth, boxWidth, y);
                    if (iterations == 0) {
                        int thisCaptionLines = captionLinesForImage.size();
                        if (thisCaptionLines <= captionLines) continue;
                        captionLines = thisCaptionLines;
                        continue;
                    }
                    int ycap = yPos + yref * boxHeight + (boxHeight - captionHeight);
                    g.setColor(Color.LIGHT_GRAY);
                    g.drawLine(x + xref * boxWidth, ycap, x + (xref + 1) * boxWidth, ycap);
                    g.setColor(Color.BLACK);
                    if (this.p.showAllImagesInSet() && gi2.imageSet().getSize(this.gallery.imageRecordService) > 1) {
                        g.setFont(fontTiny);
                        String no = gi2.imageNo() + 1 + " of " + gi2.imageSet().getSize(this.gallery.imageRecordService);
                        g.drawString(no, x + (xref + 1) * boxWidth - g.getFontMetrics().stringWidth(no) - 2, ycap - fm.getDescent());
                        g.setFont(fontCaption);
                    }
                    ycap += fm.getHeight();
                    for (int i = 0; i < captionLinesForImage.size(); ++i) {
                        String text = captionLinesForImage.get(i);
                        int xcap = x + (xref + 1) * boxWidth - boxWidth / 2;
                        int xpos = xcap - fm.stringWidth(text) / 2;
                        g.drawString(text, xpos, ycap);
                        ycap += fm.getHeight();
                    }
                    Dimension scaledImageDimension = new Dimension(imageDimension.width * 2, imageDimension.height * 2);
                    ImageIcon icon = null;
                    Image image = gi2.imageSet().getImage(this.gallery.imageRecordService, this.gallery.imageLoader, gi2.imageRecord().imageID(), imageDimension);
                    if (image != null) {
                        icon = new ImageIcon(image);
                    }
                    if (icon != null) {
                        int yimg = yPos + (yref + 1) * boxHeight - icon.getIconHeight() - captionHeight - 8 - TINY_FONY_SIZE;
                        g.drawImage(icon.getImage(), x + xref * boxWidth + boxWidth / 2 - icon.getIconWidth() / 2, yimg, null);
                    } else {
                        LOGGER.log(Level.WARNING, "Image is null for taxon {0}", gi2.imageSet().getSpecID());
                    }
                    if (xref < gridSize - 1) {
                        g.drawLine(x + ++xref * boxWidth, yPos + yref * boxHeight, x + xref * boxWidth, yPos + (yref + 1) * boxHeight + 1);
                        continue;
                    }
                    xref = 0;
                    if (++yref >= gridSize) continue;
                    g.drawLine(x, yPos + yref * boxHeight, x + width, yPos + yref * boxHeight);
                }
                ++iterations;
            }
            if (yref < gridSize - 1) {
                g.drawLine(x, yPos + (yref + 1) * boxHeight, x + xref * boxWidth, yPos + (yref + 1) * boxHeight);
            }
            g.drawRect(x, y, width, height);
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError("Error drawing gallery: ", ex);
        }
    }

    private List<String> getCaptionLines(TaxonImageGallery.GalleryImage gi, Graphics g, int x, int boxWidth, int y) {
        ArrayList<String> captionLines = new ArrayList<String>();
        if (gi.occ() != null) {
            OccurrenceImage occImage = (OccurrenceImage)gi.imageSet();
            if (occImage.getWell() != null && !this.p.excludeWellInfo()) {
                captionLines.add(occImage.getWell().toString());
            }
            if (occImage.getSmpdtl() != null) {
                captionLines.add(String.valueOf(occImage.getSample()) + (String)(this.p.showSuite() ? " " + occImage.getSmpdtl().getHeader().toString() : ""));
            }
            captionLines.add(gi.occ().toString(this.p.showAuthor(), !this.p.excludeCats()));
            if (this.p.showOccComments() && gi.occ() != null && !StringUtils.isBlank((CharSequence)gi.occ().getComment())) {
                captionLines.addAll(this.computeWrappedLines(g, x, y, boxWidth, gi.occ().getComment()));
            }
        } else {
            String notes;
            String reference;
            captionLines.add(this.taxonService.findTaxon(gi.imageSet().getSpecID()).map(t -> t.toString(this.p.showAuthor(), !this.p.excludeCats())).orElse(""));
            if (this.p.showReferences() && !StringUtils.isBlank((CharSequence)(reference = ((Taxon)this.taxonService.findTaxon(gi.imageSet().getSpecID()).get()).getReference()))) {
                captionLines.addAll(this.computeWrappedLines(g, x, y, boxWidth, reference));
            }
            if (this.p.showNotes() && !StringUtils.isBlank((CharSequence)(notes = ((Taxon)this.taxonService.findTaxon(gi.imageSet().getSpecID()).get()).getNotes()))) {
                captionLines.addAll(this.computeWrappedLines(g, x, y, boxWidth, notes));
            }
        }
        if (this.p.showImageCaption() && !StringUtils.isBlank((CharSequence)gi.imageRecord().caption())) {
            captionLines.addAll(this.computeWrappedLines(g, x, y, boxWidth, gi.imageRecord().caption()));
        }
        if ((this.p.showFileName() || this.p.showFullFilePath()) && !StringUtils.isBlank((CharSequence)gi.imageRecord().picPath())) {
            captionLines.addAll(this.computeWrappedLines(g, x, y, boxWidth, this.p.showFullFilePath() ? gi.imageRecord().picPath() : gi.imageRecord().fileName()));
        }
        return captionLines;
    }

    private List<String> computeWrappedLines(Graphics g, int x, int y, int width, String text) {
        ArrayList<String> lines = new ArrayList<String>();
        FontMetrics fm = g.getFontMetrics();
        if (fm.stringWidth(text) > width) {
            Object line = "";
            int yPos = y;
            StringTokenizer tokeniser = new StringTokenizer(text, " ");
            while (tokeniser.hasMoreTokens()) {
                String tok = tokeniser.nextToken();
                if (fm.stringWidth((String)line + tok) < width) {
                    line = (String)line + tok + " ";
                    continue;
                }
                lines.add((String)line);
                yPos += fm.getHeight();
                line = tok + " ";
            }
            lines.add((String)line);
        } else {
            lines.add(text);
        }
        return lines;
    }

    private int drawHeader(Graphics2D g, int x, int y, int width, int height, int pageNo) {
        g.setStroke(new BasicStroke(1.0f, 0, 0));
        g.setFont(fontBoldHdr);
        int yPos = y + 8 + g.getFontMetrics().getAscent();
        g.drawString(this.title, x + 8, yPos);
        if (this.pages > 1) {
            String pageString = pageNo + 1 + " of " + this.pages;
            g.drawString(pageString, x + width - g.getFontMetrics().stringWidth(pageString) - 4, yPos);
        }
        g.drawLine(x, yPos += g.getFontMetrics().getDescent() + 8, x + width, yPos);
        return yPos;
    }

    public void exportPdfPDFBox(Window parent, SBdb sbdb) {
        File pdfFile = FileChooserUtils.chooseFileToWrite((SBdb)sbdb, (Component)parent, (String)"WINGLPDF", (String)"UNXGLPDF", (String[])new String[]{"PDF"}, (String[])new String[]{"PDF"}, (String)(StringUtils.replace((String)this.title, (String)" ", (String)"_") + "_Images"));
        if (pdfFile == null) {
            return;
        }
        DialogPrintImageGallery dialog = new DialogPrintImageGallery((JDialog)parent, true, this.p, sbdb);
        dialog.setLocationRelativeTo(parent);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        int nPages = this.getnPages(0, 0);
        int mmWidth = 210;
        int mmHeight = 297;
        DimensionF pageSizeMM = new DimensionF(mmWidth, mmHeight);
        int widthPt = (int)Math.round(UnitConv.mm2pt((double)mmWidth));
        int heightPt = (int)Math.round(UnitConv.mm2pt((double)mmHeight));
        int borderWidth = widthPt / 20;
        int borderHeight = widthPt / 20;
        List<Font> fonts = Arrays.asList(fontCaption, fontTiny, fontBoldHdr);
        try (PDFExporter exporter = new PDFExporter(pageSizeMM, fonts, true);){
            int i = 0;
            while (i < nPages) {
                int pageNum = i++;
                exporter.drawPage(g2d -> this.draw((Graphics)g2d, borderWidth, borderHeight, widthPt - borderWidth, heightPt - borderHeight, pageNum));
            }
            exporter.save(pdfFile);
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(null, "There was an error creating a compact PDF file using embedded fonts: " + e.getMessage() + "\nPress OK to create the PDF using vector fonts (larger files).", "Error", 0);
            this.exportPdf(parent, sbdb);
            return;
        }
        catch (Exception e) {
            SbugsExceptionHandler.showStackError(e, parent);
        }
        if (Desktop.isDesktopSupported()) {
            try {
                Desktop.getDesktop().open(pdfFile);
            }
            catch (IOException ex) {
                JOptionPane.showMessageDialog(parent, "File written", "StrataBugs", 1);
            }
        }
    }

    public void exportPdf(Window parent, SBdb sbdb) {
        int opt;
        if (FrameJsbugs.isMacPlatform() && (opt = JOptionPane.showConfirmDialog(parent, "Warning: output directly to PDF on a Mac platform is currently limited to simple fonts.\nWe recommend that you use the 'Print' menu, and select the PDF option within the print driver.\nContinue?", "Print to PDF", 0, 3)) == 1) {
            return;
        }
        File pdfFile = FileChooserUtils.chooseFileToWrite((SBdb)sbdb, (Component)parent, (String)"WINGLPDF", (String)"UNXGLPDF", (String[])new String[]{"PDF"}, (String[])new String[]{"PDF"}, (String)(StringUtils.replace((String)this.title, (String)" ", (String)"_") + "_Images"));
        if (pdfFile == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        Document document = null;
        try {
            document = factory.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException p) {
            LOGGER.log(Level.WARNING, "Image gallery:  ", p);
        }
        PDFDocumentGraphics2D g = new PDFDocumentGraphics2D(false);
        g.setGraphicContext(new GraphicContext());
        try {
            ChartExporter.configure(g, ChartExporter.createAutoFontsConfiguration());
        }
        catch (ConfigurationException e) {
            LOGGER.log(Level.WARNING, "Image gallery: Throwing runtime exception ", e);
            throw new RuntimeException(e);
        }
        try {
            OutputStream out = new FileOutputStream(pdfFile);
            out = new BufferedOutputStream(out);
            int mmWidth = 210;
            int mmHeight = 297;
            int widthPt = (int)Math.round(UnitConv.mm2pt((double)mmWidth));
            int heightPt = (int)Math.round(UnitConv.mm2pt((double)mmHeight));
            g.setupDocument(out, (int)((double)widthPt * 1.1), (int)((double)heightPt * 1.1));
            LOGGER.log(Level.INFO, "Image gallery:  set up document");
            DialogPrintImageGallery dialog = new DialogPrintImageGallery((JDialog)parent, true, this.p, sbdb);
            dialog.setLocationRelativeTo(parent);
            dialog.setVisible(true);
            if (!dialog.isOK()) {
                return;
            }
            int nPages = this.getnPages(0, 0);
            for (int page = 0; page < nPages; ++page) {
                this.draw((Graphics)g, widthPt / 20, heightPt / 20, widthPt, heightPt, page);
                g.nextPage();
            }
            g.finish();
            out.flush();
            out.close();
            if (Desktop.isDesktopSupported()) {
                try {
                    Desktop.getDesktop().open(pdfFile);
                }
                catch (IOException ex) {
                    JOptionPane.showMessageDialog(parent, "File written", "StrataBugs", 1);
                }
            }
        }
        catch (IOException | RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, parent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void print(Window parentFrame, SBdb sbdb) {
        PrinterJob job = PrinterJob.getPrinterJob();
        if (!job.printDialog()) {
            return;
        }
        PageFormat pf = job.defaultPage();
        List<TaxonImageGalleryPrint> prints = List.of(this);
        PrintJPanel printPanel = new PrintJPanel(prints, pf);
        DialogPrintPreview dialog = new DialogPrintPreview(parentFrame, true, prints, printPanel, job, pf, sbdb);
        dialog.setVisible(true);
        if (!dialog.isPrint()) {
            return;
        }
        try {
            job.setPrintable(printPanel, dialog.getPageFormat());
            parentFrame.setCursor(Cursor.getPredefinedCursor(3));
            job.print();
            JOptionPane.showMessageDialog(parentFrame, "Print complete", "StrataBugs", 1);
        }
        catch (PrinterException exp) {
            JOptionPane.showMessageDialog(parentFrame, "Problem printing: " + exp.getMessage());
            exp.printStackTrace();
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, parentFrame);
        }
        finally {
            parentFrame.setCursor(Cursor.getDefaultCursor());
        }
    }
}

