/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.imagestorage;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import jsbugs.imagestorage.ImageImportOptions;

public class DialogStoreImages
extends JDialog {
    private int result = 2;
    private ImageImportOptions options = null;
    private ButtonGroup buttonGroupImportOptions;
    private JButton jButtonCancel;
    private JButton jButtonImportFolderBrowse;
    private JButton jButtonOk;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonImportFromFolder;
    private JRadioButton jRadioButtonImportFromPath;
    private JRadioButton jRadioButtonNoImport;
    private JScrollPane jScrollPane1;
    private JTextArea jTextArea1;
    private JTextField jTextFieldImportFolder;

    public DialogStoreImages(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initComponents();
        this.init();
    }

    public int showDialog() {
        this.setVisible(true);
        return this.result;
    }

    public ImageImportOptions getOptions() {
        return this.options;
    }

    private void init() {
        this.setTitle("Change Image Storage and Import Options");
    }

    private void disableImportFolderControls() {
        this.jTextFieldImportFolder.setEnabled(false);
        this.jButtonImportFolderBrowse.setEnabled(false);
    }

    private void enableImportFolderControls() {
        this.jTextFieldImportFolder.setEnabled(true);
        this.jButtonImportFolderBrowse.setEnabled(true);
    }

    private void initComponents() {
        this.buttonGroupImportOptions = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jRadioButtonImportFromPath = new JRadioButton();
        this.jRadioButtonImportFromFolder = new JRadioButton();
        this.jRadioButtonNoImport = new JRadioButton();
        this.jTextFieldImportFolder = new JTextField();
        this.jButtonImportFolderBrowse = new JButton();
        this.jButtonCancel = new JButton();
        this.jButtonOk = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setMinimumSize(new Dimension(420, 310));
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Import Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupImportOptions.add(this.jRadioButtonImportFromPath);
        this.jRadioButtonImportFromPath.setSelected(true);
        this.jRadioButtonImportFromPath.setText("Attempt to import images from the filesystem paths stored");
        this.jRadioButtonImportFromPath.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImages this$0;
            {
                DialogStoreImages dialogStoreImages = this$0;
                Objects.requireNonNull(dialogStoreImages);
                this.this$0 = dialogStoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonImportFromPathActionPerformed(evt);
            }
        });
        this.buttonGroupImportOptions.add(this.jRadioButtonImportFromFolder);
        this.jRadioButtonImportFromFolder.setText("Attempt to import images from the a specifed export folder");
        this.jRadioButtonImportFromFolder.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImages this$0;
            {
                DialogStoreImages dialogStoreImages = this$0;
                Objects.requireNonNull(dialogStoreImages);
                this.this$0 = dialogStoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonImportFromFolderActionPerformed(evt);
            }
        });
        this.buttonGroupImportOptions.add(this.jRadioButtonNoImport);
        this.jRadioButtonNoImport.setText("Don't attempt to import anything");
        this.jRadioButtonNoImport.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImages this$0;
            {
                DialogStoreImages dialogStoreImages = this$0;
                Objects.requireNonNull(dialogStoreImages);
                this.this$0 = dialogStoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNoImportActionPerformed(evt);
            }
        });
        this.jTextFieldImportFolder.setEnabled(false);
        this.jButtonImportFolderBrowse.setText("Browse");
        this.jButtonImportFolderBrowse.setEnabled(false);
        this.jButtonImportFolderBrowse.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImages this$0;
            {
                DialogStoreImages dialogStoreImages = this$0;
                Objects.requireNonNull(dialogStoreImages);
                this.this$0 = dialogStoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonImportFolderBrowseActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addGap(21, 21, 21).addComponent(this.jTextFieldImportFolder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonImportFolderBrowse)).addGroup(jPanel1Layout.createSequentialGroup().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jRadioButtonImportFromPath).addComponent(this.jRadioButtonImportFromFolder).addComponent(this.jRadioButtonNoImport)).addGap(0, 0, Short.MAX_VALUE))).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addComponent(this.jRadioButtonImportFromPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonImportFromFolder).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jTextFieldImportFolder, -2, -1, -2).addComponent(this.jButtonImportFolderBrowse)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jRadioButtonNoImport, -1, 31, Short.MAX_VALUE)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImages this$0;
            {
                DialogStoreImages dialogStoreImages = this$0;
                Objects.requireNonNull(dialogStoreImages);
                this.this$0 = dialogStoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOk.setText("Set database to store image data");
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogStoreImages this$0;
            {
                DialogStoreImages dialogStoreImages = this$0;
                Objects.requireNonNull(dialogStoreImages);
                this.this$0 = dialogStoreImages;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        this.jScrollPane1.setBorder(null);
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setFont(new Font("Tahoma", 0, 11));
        this.jTextArea1.setLineWrap(true);
        this.jTextArea1.setRows(3);
        this.jTextArea1.setText("You are about the modify the current database to store images instead of just the path to the images on in the filesystem. \n\nThis will affect ALL users of the currently connected database.\n\nStrataBugs can attempt to import the images currently stored in the database.");
        this.jTextArea1.setWrapStyleWord(true);
        this.jTextArea1.setOpaque(false);
        this.jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 125, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel).addGap(10, 10, 10)).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1, GroupLayout.Alignment.TRAILING).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(9, 9, 9).addComponent(this.jScrollPane1, -2, 96, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED, -1, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonOk).addComponent(this.jButtonCancel)).addContainerGap()));
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.result = 2;
        this.options = null;
        this.setVisible(false);
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.jRadioButtonNoImport.isSelected()) {
            this.options = new ImageImportOptions(false);
        } else if (this.jRadioButtonImportFromPath.isSelected()) {
            this.options = new ImageImportOptions(true);
        } else {
            String path = this.jTextFieldImportFolder.getText();
            if (path.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No import path specified.", "Error locating folder", 2);
                return;
            }
            File folder = new File(path);
            if (!folder.exists()) {
                JOptionPane.showMessageDialog(this, "No import fodler specified or path doesn't exist.", "Error locating folder", 2);
                return;
            }
            this.options = new ImageImportOptions(true, folder);
        }
        this.result = 0;
        this.setVisible(false);
    }

    private void jRadioButtonImportFromFolderActionPerformed(ActionEvent evt) {
        this.enableImportFolderControls();
    }

    private void jRadioButtonNoImportActionPerformed(ActionEvent evt) {
        this.disableImportFolderControls();
    }

    private void jRadioButtonImportFromPathActionPerformed(ActionEvent evt) {
        this.disableImportFolderControls();
    }

    private void jButtonImportFolderBrowseActionPerformed(ActionEvent evt) {
        JFileChooser fileChooser = new JFileChooser();
        fileChooser.setFileSelectionMode(1);
        if (fileChooser.showOpenDialog(this) == 0) {
            File folder = fileChooser.getSelectedFile();
            if (!folder.exists()) {
                JOptionPane.showMessageDialog(this, "The specified folder can't be located.", "Error locating folder", 2);
                return;
            }
            this.jTextFieldImportFolder.setText(folder.getAbsolutePath());
        }
    }
}

