/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.well.sample.SampleType;
import java.sql.SQLException;
import java.util.List;
import model3.Sample;
import model3.Well;
import model3.WellInterp;
import util.SBException;
import util.gridwriter.GridBuilder;

public class GridBuilderSampleDetails {
    private boolean ignoreLogSamples = true;
    private boolean includeAnalysis = true;

    public Object[][] buildSampleDetailsGrid(List<Well> wells, char units, Integer interpId) throws SQLException, SBException {
        GridBuilder gb = new GridBuilder();
        gb.addRow(new Object[]{"Well Name", "Well Code", "Top Depth", "Base Depth", "Type", "Label", "Created", "Modified", "Num Analyis"});
        if (interpId != null && this.includeAnalysis) {
            gb.append(new Object[]{"Stratigraphy"});
        }
        for (Well w : wells) {
            WellInterp interp = null;
            if (interpId != null) {
                interp = w.getInterp(interpId);
            }
            for (Sample s : w.getSamples()) {
                if (this.ignoreLogSamples && s.getType() == SampleType.LOG) continue;
                gb.addRow();
                gb.append(new Object[]{w.getWellName()});
                gb.append(new Object[]{w.getWellCode()});
                gb.append(new Object[]{this.getTopDepth(s, units)});
                gb.append(new Object[]{this.getBaseDepth(s, units)});
                gb.append(new Object[]{s.getType().getAbr()});
                gb.append(new Object[]{s.getLabel()});
                gb.append(new Object[]{s.getCreated()});
                gb.append(new Object[]{s.getModified()});
                gb.append(new Object[]{s.getAnalysesCopy().size()});
                if (interp == null || !this.includeAnalysis) continue;
                gb.append(new Object[]{s.getStratigraphy(interp, true)});
            }
        }
        return gb.getDataArray();
    }

    private Double getTopDepth(Sample s, char units) throws SBException {
        if (s.hasTopDepth()) {
            return s.getTopDepth(units);
        }
        return null;
    }

    private Double getBaseDepth(Sample s, char units) throws SBException {
        if (s.hasBaseDepth()) {
            return s.getBaseDepth(units);
        }
        return null;
    }

    public void setIgnoreLogSamples(boolean value) {
        this.ignoreLogSamples = value;
    }

    public void setIncludeAnalysisData(boolean value) {
        this.includeAnalysis = value;
    }
}

