/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.Discipline;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import jsbugs.io.igdxlsworkbook.IGDWorksheetWriterBiocom;
import jsbugs.io.igdxlsworkbook.IGDWorksheetWriterEvents;
import jsbugs.io.igdxlsworkbook.IGDWorksheetWriterIntcom;
import jsbugs.io.igdxlsworkbook.IGDWorksheetWriterIntervalZone;
import jsbugs.io.igdxlsworkbook.IGDWorksheetWriterSQPick;
import jsbugs.io.igdxlsworkbook.IXLSWorksheetWriter;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import jsbugs.userconnect.ISBSession;
import jsbugs.userconnect.SbugsSession;
import model3.IGDIntervalZone;
import model3.Well;
import model3.WellInterp;
import util.gridwriter.GridBook;
import util.gridwriter.GridSheet;

public class IGDXLSWorkbookBuilder {
    private final ISBSession session;
    private boolean separateChronostrat = false;
    private boolean separateBiozone = false;
    private boolean separateLithostrat = true;
    private final SampleFormatter sampleFormatter;

    public IGDXLSWorkbookBuilder(SampleFormatter sampleFormatter) {
        this(sampleFormatter, SbugsSession.getSession());
    }

    public IGDXLSWorkbookBuilder(SampleFormatter sampleFormatter, ISBSession session) {
        this.session = session;
        this.sampleFormatter = sampleFormatter;
    }

    public GridBook buildWorkbookData(List<Well> wells, int interpretationId) throws Exception {
        int i;
        GridBook book = new GridBook();
        ArrayList<IXLSWorksheetWriter> wsw = new ArrayList<IXLSWorksheetWriter>();
        if (this.separateChronostrat) {
            for (i = 1; i <= IGDIntervalZone.getNHier(3, true); ++i) {
                wsw.add(new IGDWorksheetWriterIntervalZone(IGDIntervalZone.getHierName(3, i), 3, this.sampleFormatter, this.session).setHierFilter(i));
            }
        } else {
            wsw.add(new IGDWorksheetWriterIntervalZone("Chronostratigraphy", 3, this.sampleFormatter, this.session));
        }
        if (this.separateLithostrat) {
            for (i = 1; i <= IGDIntervalZone.getNHier(2, true); ++i) {
                wsw.add(new IGDWorksheetWriterIntervalZone(IGDIntervalZone.getHierName(2, i), 2, this.sampleFormatter, this.session).setHierFilter(i));
            }
        } else {
            wsw.add(new IGDWorksheetWriterIntervalZone("Lithostratigraphy", 2, this.sampleFormatter, this.session));
        }
        if (this.separateBiozone) {
            for (i = 1; i <= IGDIntervalZone.getNHier(4, true); ++i) {
                wsw.add(new IGDWorksheetWriterIntervalZone(IGDIntervalZone.getHierName(4, i), 4, this.sampleFormatter, this.session).setHierFilter(i));
            }
        } else {
            wsw.add(new IGDWorksheetWriterIntervalZone("Biozone", 4, this.sampleFormatter, this.session).setIncludeDiscipline(true));
        }
        wsw.add(new IGDWorksheetWriterEvents(this.sampleFormatter));
        wsw.add(new IGDWorksheetWriterSQPick(this.sampleFormatter));
        wsw.add(new IGDWorksheetWriterBiocom("Micro Comments", Discipline.MICRO, this.sampleFormatter));
        wsw.add(new IGDWorksheetWriterBiocom("Nanno Comments", Discipline.NANNO, this.sampleFormatter));
        wsw.add(new IGDWorksheetWriterBiocom("Paly Comments", Discipline.PALY, this.sampleFormatter));
        wsw.add(new IGDWorksheetWriterIntcom());
        for (IXLSWorksheetWriter writer : wsw) {
            GridSheet sheet = this.buildWorksheetData(writer, wells, interpretationId);
            if (sheet == null) continue;
            book.addSheet(writer.getName(), sheet);
        }
        return book;
    }

    private GridSheet buildWorksheetData(IXLSWorksheetWriter writer, List<Well> wells, int interpretationId) throws Exception {
        GridSheet gs = null;
        for (Well w : wells) {
            if (!this.doesWellHaveInterp(w, interpretationId)) continue;
            WellInterp interp = w.getInterp(interpretationId);
            if (gs == null && writer.hasDataToWrite(w, interp)) {
                gs = new GridSheet();
                writer.writeHeader(gs);
            }
            if (gs == null) continue;
            writer.writeData(gs, w, interp);
        }
        if (gs != null) {
            return gs;
        }
        return null;
    }

    private boolean doesWellHaveInterp(Well w, int interpretationId) {
        Iterator<WellInterp> iterator = w.getInterpIterator();
        while (iterator.hasNext()) {
            WellInterp wi = iterator.next();
            if (wi.getInterpId() != interpretationId) continue;
            return true;
        }
        return false;
    }

    public boolean getSeparateChronostrat() {
        return this.separateChronostrat;
    }

    public void setSeparateChronostrat(boolean separateChronostrat) {
        this.separateChronostrat = separateChronostrat;
    }

    public boolean getSeparateBiozone() {
        return this.separateBiozone;
    }

    public void setSeparateBiozone(boolean separateBiozone) {
        this.separateBiozone = separateBiozone;
    }

    public boolean getSeparateLithostrat() {
        return this.separateLithostrat;
    }

    public void setSeparateLithostrat(boolean separateLithostrat) {
        this.separateLithostrat = separateLithostrat;
    }
}

