/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.ws.LinkedWorkspace;
import com.stratadata.model3.ws.Workspace;
import com.stratadata.model3.ws.reader.ParsedWorkspace;
import java.awt.Frame;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import jsbugs.DialogMatchAnalysts;
import jsbugs.DialogMatchTaxa;
import jsbugs.SbugsIO;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;

public class ImportWizard {
    private final Frame parent;
    private final SBdb sbdb;

    public ImportWizard(Frame parent, SBdb sbdb) {
        this.parent = parent;
        this.sbdb = sbdb;
    }

    public void startWizard() {
        File file = SbugsIO.chooseFileToOpen(this.sbdb, this.parent, "JZIPFILE", "Taxon dictionary/synonymy files", "sbg", "xml", "zip");
        try {
            DialogMatchTaxa dialogMatchTaxa;
            ParsedWorkspace parsedWorkspace = SbugsIO.getWorkspace(file, this.parent);
            Workspace workspace = parsedWorkspace.getWorkspace();
            System.out.println("Taxon count: " + workspace.getTaxonService().getTaxonCount());
            for (Taxon t : workspace.getTaxonService().getAllTaxa()) {
                System.out.println(t.toString() + " : " + workspace.getSynonymService().getPrefString(1, t.getSpecID(), workspace.getTaxonService()));
            }
            System.out.println("Genus count: " + workspace.getGenusService().getGenusCount());
            System.out.println("User count: " + workspace.getUserService().getAllUsers().size());
            LinkedWorkspace linkedWorkspace = new LinkedWorkspace(parsedWorkspace, this.sbdb);
            linkedWorkspace.matchUnmatchedUsers();
            if (linkedWorkspace.hasUnmatchedUsers()) {
                DialogMatchAnalysts dialogMatchAnalysts = new DialogMatchAnalysts(this.parent, true, linkedWorkspace, true);
                dialogMatchAnalysts.setLocationRelativeTo(this.parent);
                dialogMatchAnalysts.setVisible(true);
                if (!dialogMatchAnalysts.isOK()) {
                    return;
                }
            }
            try {
                dialogMatchTaxa = new DialogMatchTaxa(this.parent, true, linkedWorkspace, true);
            }
            catch (SQLException e) {
                SbugsExceptionHandler.showDialogStackError(e, this.parent);
                return;
            }
            dialogMatchTaxa.setLocationRelativeTo(this.parent);
            dialogMatchTaxa.setVisible(true);
        }
        catch (IOException | RuntimeException e) {
            SbugsExceptionHandler.showStackError(e, this.parent);
        }
    }
}

