/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.stratadata.util.io.FileChooserUtils;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Frame;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import jsbugs.io.IGDXLSWorkbookBuilder;
import jsbugs.io.JsonExport;
import jsbugs.io.igdxlsworkbook.DialogIGDWorksheetOptions;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import jsbugs.io.spdcworkbook.DialogSPDCSummaryWorkbook;
import jsbugs.io.welldata.DialogOccurrenceFlatFileOptions;
import jsbugs.io.welldata.GridBuilderMultiWellOccurrenceFlatFile;
import jsbugs.io.welldata.GridBuilderWellInterpSummary;
import jsbugs.userconnect.SbugsSession;
import jsbugs.util.UserPrefsHelper;
import model3.IGDScheme;
import model3.Lastval;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.SB;
import util.SBException;
import util.exception.StackError;
import util.gridwriter.GridBook;
import util.gridwriter.GridSheet;
import util.gridwriter.GridWriter;
import util.gridwriter.XLSExportOptions;
import util.gridwriter.XLSGridWriter;

public class OrganiserExportHelper {
    private Logger log = Logger.getLogger(OrganiserExportHelper.class.getName());
    private final SBdb db = SbugsSession.getDb();
    private final Frame parent;
    private final UserPrefsHelper prefs;

    public OrganiserExportHelper(Frame dialogParent) {
        this.parent = dialogParent;
        this.prefs = new UserPrefsHelper(this.db);
    }

    public void writeIGDXLSWorkbook(List<Well> wells, int interpId) {
        File lastFileFile = this.prefs.getLastIGDXLSWorkbookFile();
        Object fileName = "IGDWorkbook.xlsx";
        if (wells.size() == 1) {
            fileName = SB.makeFileName((String)wells.get(0).getWellCode()) + ".xlsx";
        }
        DialogIGDWorksheetOptions optionsDialog = new DialogIGDWorksheetOptions(this.parent, true);
        if (lastFileFile != null) {
            optionsDialog.setDefaultDirectory(this.getFilePath(lastFileFile));
            optionsDialog.setOutputFile(new File(this.getFilePath(lastFileFile.getParentFile()) + File.separator + (String)fileName));
        }
        optionsDialog.pack();
        optionsDialog.setLocationRelativeTo(this.parent);
        optionsDialog.setVisible(true);
        if (!optionsDialog.isOK()) {
            optionsDialog = null;
            return;
        }
        File file = optionsDialog.getOutputFile();
        if (file != null) {
            if (file.exists() && JOptionPane.showConfirmDialog(this.parent, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                return;
            }
            XLSGridWriter gw = new XLSGridWriter();
            SampleFormatter sf = new SampleFormatter(optionsDialog.getIncludeSampleType(), optionsDialog.getIncludeUnitChar(), optionsDialog.getCoreSampleCorrection(), optionsDialog.getCuttingSampleCorrection());
            IGDXLSWorkbookBuilder wbBuilder = new IGDXLSWorkbookBuilder(sf);
            wbBuilder.setSeparateChronostrat(optionsDialog.getChronoSeparated());
            wbBuilder.setSeparateBiozone(optionsDialog.getBioSeparated());
            wbBuilder.setSeparateLithostrat(optionsDialog.getLithoSeparated());
            gw.getOptions().setAuthorName(this.db.getUser().getName());
            try {
                GridBook book = wbBuilder.buildWorkbookData(wells, interpId);
                if (book.isEmpty()) {
                    JOptionPane.showMessageDialog(this.parent, "No matching interpretation data were found on the selected wells. \nNo output was written.", "Export aborted", 2);
                } else {
                    gw.write(file, book, false);
                    JOptionPane.showMessageDialog(this.parent, "File written", "Export complete", 1);
                    this.prefs.setLastIGDXLSWorkbookFile(file);
                    this.db.commit();
                }
            }
            catch (Exception ex) {
                StackError.showStackError((String)("Error writing file: " + ex.getMessage()), (Throwable)ex);
                this.log.log(Level.SEVERE, "Error exporting xls workbook file", ex);
                ex.printStackTrace();
            }
        }
    }

    public void writeBHPSummaryWorkbook(List<Well> wells, int interpId, Set<Integer> dataTypes) {
        File file;
        File lastFileFile = this.prefs.getLastInterpSummaryFile();
        String fileName = "";
        if (wells.size() == 1) {
            fileName = SB.makeFileName((String)wells.get(0).getWellCode());
        }
        if ((file = FileChooserUtils.saveAsGridDataDialog((Component)this.parent, (String)this.getFilePath(lastFileFile), (String)fileName)) != null) {
            if (file.exists() && JOptionPane.showConfirmDialog(this.parent, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                return;
            }
            GridWriter gw = new GridWriter();
            gw.getXLSOptions().setSheetName("StrataBugs Picks");
            gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
            gw.getXLSOptions().setAutoSizeColumns(true);
            if (file.getName().endsWith(".xlsx")) {
                gw.getXLSOptions().setEnableBufferedOutput(true);
            }
            GridBuilderWellInterpSummary gb = new GridBuilderWellInterpSummary(this.db);
            gb.setUseCoreSampleCorrections(true);
            gb.setUseCuttingSampleCorrections(false);
            gb.setIncludeWellCode(true);
            gb.setIncludeVersionName(true);
            gb.setDuplicateSingleDepths(false);
            gb.setIncludeUncorrectedDepths(false);
            try {
                Object[][] grid = null;
                grid = gb.buildGridBHP(wells, interpId, dataTypes);
                if (grid != null) {
                    gw.write(file, grid);
                }
                JOptionPane.showMessageDialog(this.parent, "File written: " + file.getPath(), "Export complete", 1);
                this.prefs.setLastInterpSummaryFile(file);
                this.db.commit();
            }
            catch (Exception ex) {
                StackError.showStackError((String)("Error writing file: " + ex.getMessage()), (Throwable)ex);
                Logger.getLogger(Lastval.class.getName()).log(Level.SEVERE, "Error exporting BHP xls file", ex);
                ex.printStackTrace();
            }
        }
    }

    public void writeSPDCSummaryWorkbooks(List<Well> wells, int interpId, Set<Integer> dataTypes) throws SQLException, SBException {
        File lastFileFolder = new File(Lastval.getString(this.db, "SPDCDIR"));
        LinkedList<IGDScheme> bzSchemes = new LinkedList<IGDScheme>();
        for (Well well : wells) {
            WellInterp wellInterp = well.getInterp(interpId);
            Set<Integer> schemeIDs = wellInterp.getBiozoneSchemes(null);
            for (Integer schemeID : schemeIDs) {
                IGDScheme scheme = this.db.getIGDScheme(schemeID);
                if (bzSchemes.contains(scheme)) continue;
                bzSchemes.add(scheme);
            }
        }
        Collections.sort(bzSchemes);
        DialogSPDCSummaryWorkbook dialog = new DialogSPDCSummaryWorkbook(this.parent, true, this.db, bzSchemes);
        if (lastFileFolder != null) {
            dialog.setDefaultDirectory(lastFileFolder.getPath());
        }
        dialog.pack();
        dialog.setLocationRelativeTo(this.parent);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            dialog = null;
            return;
        }
        File outputFolder = dialog.getOutputFolder();
        String extension = ".xlsx";
        if (dialog.getUseLegacyExcelOutput()) {
            extension = ".xls";
        }
        Boolean overwriteAll = null;
        try {
            block9: for (Well well : wells) {
                File file = new File(String.valueOf(outputFolder) + File.separator + SB.makeFileName((String)well.getWellName()) + extension);
                if (file.exists() && overwriteAll == null) {
                    Object[] buttons = new String[]{"Yes", "Yes to all", "No", "Cancel"};
                    int opt = JOptionPane.showOptionDialog(this.parent, "The file " + file.toString() + " already exists. \r\nOverwrite file?", "Confirm file overwrite", 0, 3, null, buttons, buttons[1]);
                    switch (opt) {
                        case 1: {
                            overwriteAll = true;
                            break;
                        }
                        case 2: {
                            continue block9;
                        }
                        case 3: {
                            return;
                        }
                    }
                }
                XLSGridWriter gw = new XLSGridWriter();
                XLSExportOptions options = new XLSExportOptions();
                options.setAuthorName(this.db.getUser().getName());
                gw.setOptions(options);
                GridBuilderWellInterpSummary gb = new GridBuilderWellInterpSummary(this.db);
                gb.setUseCoreSampleCorrections(true);
                gb.setUseCuttingSampleCorrections(false);
                gb.setIncludeWellCode(false);
                gb.setIncludeVersionName(true);
                gb.setDuplicateSingleDepths(false);
                gb.setIncludeUncorrectedDepths(false);
                GridSheet sheet = gb.buildGridSPDC(well, interpId, dataTypes, dialog.getCoreSampleCorrection(), dialog.getCuttingSampleCorrection(), dialog.getUseColours(), dialog.isSingleChronoStratColumn(), dialog.getSelectedSchemes());
                if (sheet == null) continue;
                GridBook book = new GridBook();
                book.addSheet("StrataBugs", sheet);
                gw.write(file, book);
            }
            Lastval.putString(this.db, "SPDCDIR", lastFileFolder.getPath());
            JOptionPane.showMessageDialog(this.parent, "File(s) written", "Export complete", 1);
            this.db.commit();
        }
        catch (IOException | SQLException | SBException ex) {
            StackError.showStackError((String)("Error writing file: " + ex.getMessage()), (Throwable)ex);
            Logger.getLogger(Lastval.class.getName()).log(Level.SEVERE, "Error exporting SPDC file", ex);
            ex.printStackTrace();
        }
    }

    private String getFilePath(File file) {
        if (file != null) {
            return file.getPath();
        }
        return null;
    }

    public void writeMultiWellFlatFile(List<Well> wells, String projectName) {
        File lastExportFolder = this.prefs.getLastExportFolder();
        Object fileName = "";
        if (projectName != null) {
            fileName = projectName + ".xlsx";
        } else if (wells.size() == 1) {
            fileName = SB.makeFileName((String)wells.get(0).getWellCode()) + ".xlsx";
        }
        DialogOccurrenceFlatFileOptions dialog = new DialogOccurrenceFlatFileOptions(this.parent, true);
        if (wells.size() > 0) {
            dialog.setDepthUnits(wells.get(0).getWellUnits());
        }
        if (lastExportFolder != null) {
            dialog.setDefaultDirectory(lastExportFolder.getAbsolutePath());
        }
        if (!((String)fileName).isEmpty()) {
            dialog.setDefaultFileName((String)fileName);
        }
        dialog.setWellsList(wells);
        dialog.setLocationRelativeTo(this.parent);
        GridBuilderMultiWellOccurrenceFlatFile gb = new GridBuilderMultiWellOccurrenceFlatFile();
        dialog.setIsOK(false);
        dialog.setVisible(true);
        if (!dialog.isOK()) {
            return;
        }
        this.updateMultiWellBuilderOptions(gb, dialog);
        try {
            boolean canContinue = false;
            do {
                List<String> validationErrors;
                if (!(validationErrors = gb.validateOptions(wells)).isEmpty()) {
                    StringBuilder sb = new StringBuilder();
                    sb.append("Can't generate output with the selected options for the following reasons:\n\n");
                    for (String error : validationErrors) {
                        sb.append(error).append("\n");
                    }
                    sb.append("\nPlease update the export options to coninue.");
                    JOptionPane.showMessageDialog(this.parent, sb.toString(), "Can't generate selected output.", 0);
                    dialog.setIsOK(false);
                    dialog.setVisible(true);
                    if (!dialog.isOK()) {
                        return;
                    }
                    this.updateMultiWellBuilderOptions(gb, dialog);
                    continue;
                }
                canContinue = true;
            } while (!canContinue);
            File file = dialog.getOutputFile();
            if (file != null) {
                if (file.exists() && JOptionPane.showConfirmDialog(this.parent, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                    return;
                }
                this.parent.setCursor(Cursor.getPredefinedCursor(3));
                GridWriter gw = new GridWriter();
                gw.getXLSOptions().setSheetName("Occurrence Summary");
                gw.getXLSOptions().setAuthorName(this.db.getUser().getName());
                gw.getXLSOptions().setAutoSizeColumns(false);
                gw.getXLSOptions().setEnableBufferedOutput(true);
                Object[][] grid = null;
                grid = gb.buildGrid(wells);
                if (grid != null) {
                    gw.write(file, grid);
                }
                JOptionPane.showMessageDialog(this.parent, "File written", "Export complete", 1);
                this.prefs.setLastExportFolder(file.getAbsoluteFile().getParentFile());
                this.db.commit();
            }
        }
        catch (Exception ex) {
            StackError.showStackError((String)("Error writing file: " + ex.getMessage()), (Throwable)ex);
            Logger.getLogger(Lastval.class.getName()).log(Level.SEVERE, "Error exporting multi well flat file", ex);
            ex.printStackTrace();
        }
    }

    private void updateMultiWellBuilderOptions(GridBuilderMultiWellOccurrenceFlatFile gb, DialogOccurrenceFlatFileOptions dialog) {
        gb.setIncludeMacro(dialog.getIncludeMacroDisc());
        gb.setIncludeMicro(dialog.getIncludeMicroDisc());
        gb.setIncludeNanno(dialog.getIncludeNanoDisc());
        gb.setIncludePally(dialog.getIncludePalyDisc());
        gb.setCoreCorrectionForCore(dialog.getUseCoreCorrections());
        gb.setCoreCorrectionForCutting(dialog.getUseCuttingCorrections());
        gb.setSelectedAnalysts(dialog.getSelectedAnalysts());
        gb.setExportUnits(dialog.getDepthUnits());
        gb.setInsertZeroWhenNoCount(dialog.getInsertZeroWhenNoCount());
        gb.setOneSamplePerRow(dialog.getUseOneSamplePerRow());
    }

    public void writeJSON(List<Well> wells, int interpId, Set<Integer> dataTypes) {
        File file;
        File lastFileFile = this.prefs.getLastInterpSummaryFile();
        Object fileName = "";
        if (wells.size() == 1) {
            fileName = SB.makeFileName((String)wells.get(0).getWellCode()) + ".json";
        }
        if ((file = FileChooserUtils.saveAsDialogWithFilters((Component)this.parent, (String)fileName, (FileNameExtensionFilter[])new FileNameExtensionFilter[]{FileChooserUtils.JSON_FILTER})) != null) {
            if (file.exists() && JOptionPane.showConfirmDialog(this.parent, "Overwrite file?", "Confirm File Overwrite", 0, 3) != 0) {
                return;
            }
            try (FileWriter out = new FileWriter(file);){
                JsonExport jso = new JsonExport(wells, interpId, dataTypes);
                GsonBuilder builder = new GsonBuilder();
                builder.setPrettyPrinting();
                Gson gson = builder.create();
                out.write(gson.toJson((Object)jso));
                JOptionPane.showMessageDialog(this.parent, "File written", "Export complete", 1);
                this.prefs.setLastInterpSummaryFile(file);
                this.db.commit();
            }
            catch (Exception ex) {
                StackError.showStackError((String)("Error writing file: " + ex.getMessage()), (Throwable)ex);
                Logger.getLogger(Lastval.class.getName()).log(Level.SEVERE, "Error exporting JSON file", ex);
                ex.printStackTrace();
            }
        }
    }
}

