/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import com.stratadata.model3.user.Userdef;
import java.io.IOException;
import java.io.Writer;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.SB;
import util.SBException;

public class TextExporterIGD {
    private char delimiter = (char)44;
    private boolean useCoreSampleCorrections = false;
    private boolean useCuttingSampleCorrections = false;
    private boolean writeWellcodes = false;
    private boolean useFixedDps = false;
    private int numFixedDps = 2;

    public TextExporterIGD() {
    }

    public TextExporterIGD(char delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isUseFixedDps() {
        return this.useFixedDps;
    }

    public void setUseFixedDps(boolean useFixedDps) {
        this.useFixedDps = useFixedDps;
    }

    public void setWriteWellCodes(boolean writeWellCodes) {
        this.writeWellcodes = writeWellCodes;
    }

    public int getNumFixedDps() {
        return this.numFixedDps;
    }

    public void setNumFixedDps(int numFixedDps) {
        this.numFixedDps = numFixedDps;
    }

    public char getDelimiter() {
        return this.delimiter;
    }

    public void setDelimiter(char delimiter) {
        this.delimiter = delimiter;
    }

    public void exportIntervalZonesAsOWCSV2(Writer writer, Well well, List<IGDIntervalZone> zones, char units, boolean extended) throws IOException, SQLException {
        String[] prefix = new String[]{"early", "middle", "late", "mid", "upper", "lower"};
        if (extended) {
            writer.write("Well name" + this.delimiter + "Pick" + this.delimiter + "Interp" + this.delimiter + "Obs" + this.delimiter + "Depth (" + Character.toLowerCase(units) + " MD)" + this.delimiter + "Confidence" + this.delimiter + "Qualifier" + this.delimiter + "Remarks" + this.delimiter + "Interval Remarks" + this.delimiter + "Source");
            writer.write("\r\n");
        }
        String[] tags = new String[]{" Top", " Base"};
        for (IGDIntervalZone zone : zones) {
            Object zoneName = zone.toString();
            for (String prefix1 : prefix) {
                if (!((String)zoneName).toLowerCase().startsWith(prefix1 + " ") || ((String)zoneName).toLowerCase().startsWith(prefix1 + " -")) continue;
                String suffix = ((String)zoneName).substring(0, prefix1.length());
                zoneName = ((String)zoneName).substring(suffix.length() + 1) + " " + suffix;
                break;
            }
            String[] depths = new String[]{this.getSampleDepthString(well, zone.getTopSample(), units), this.getSampleDepthString(well, zone.getBaseSample(), units)};
            for (int i = 0; i < depths.length; ++i) {
                if (extended) {
                    writer.write(well.getHeader().getWellName() + this.delimiter);
                }
                writer.write((String)zoneName + tags[i] + this.delimiter);
                if (extended) {
                    writer.write("BIOS" + this.delimiter + "1" + this.delimiter);
                }
                writer.write(depths[i] + this.delimiter);
                if (extended) {
                    Userdef modifier = well.getDataModel().getUser(zone.getModifier());
                    writer.write(this.getOWConfidenceString(zone.getTopBndInt()) + this.delimiter + this.getOWQualifierString(zone.getTopBndInt()) + this.delimiter + (modifier != null ? modifier.getAbr() : "BIOS") + this.delimiter);
                    writer.write(zone.toString() + this.delimiter + "SBUGS\r\n");
                    continue;
                }
                writer.write("BIOSTRAT\r\n");
            }
        }
    }

    private String getOWConfidenceString(int bnd) {
        switch (bnd) {
            default: {
                return "";
            }
            case 3: {
                return "G";
            }
            case 2: {
                return "F";
            }
            case 1: 
            case 4: 
            case 5: 
            case 6: 
        }
        return "P";
    }

    private String getOWQualifierString(int bnd) {
        switch (bnd) {
            default: {
                return "";
            }
            case 4: 
            case 5: 
            case 6: 
        }
        return "ER";
    }

    public void exportIntervalZonesAsCSV(Writer writer, Well well, List<IGDIntervalZone> zones, char units) throws IOException, SQLException {
        for (IGDIntervalZone zone : zones) {
            String zoneName = zone.toString();
            String topDepth = this.getSampleDepthString(well, zone.getTopSample(), units);
            String bottomDepth = this.getSampleDepthString(well, zone.getBaseSample(), units);
            writer.write(zoneName + this.delimiter + topDepth + this.delimiter + zone.getTopSample().getTypeString() + this.delimiter + zone.getTopBnd() + this.delimiter + bottomDepth + this.delimiter + zone.getBaseSample().getTypeString() + this.delimiter + zone.getBaseBnd() + "\r\n");
        }
    }

    private double getSampleDepth(Well well, Sample sample, char units) throws SQLException {
        return well.getDepth(sample, units, this.useCoreSampleCorrections, this.useCuttingSampleCorrections);
    }

    private String getSampleDepthString(Well well, Sample sample, char units) throws SQLException {
        if (this.useFixedDps) {
            double depth = this.getSampleDepth(well, sample, units);
            return SB.floatString((double)depth, (int)this.numFixedDps);
        }
        return this.sampleToStringWithCorrectedDepth(well, sample, units);
    }

    private String sampleToStringWithCorrectedDepth(Well well, Sample sample, char units) throws SQLException {
        if (sample.getType().correctDepth(this.useCoreSampleCorrections, this.useCuttingSampleCorrections)) {
            Double correctedTop = sample.getTopDepth() != null ? Double.valueOf(well.getCorrectedDepth(sample.getTopDepth())) : null;
            Double correctedBase = sample.getBaseDepth() != null ? Double.valueOf(well.getCorrectedDepth(sample.getBaseDepth())) : null;
            return sample.toString(units, false, false, false, false, correctedTop, correctedBase);
        }
        return sample.toString(units, false, false, false, false, null, null);
    }

    public void exportWellsToOWCSV(Writer writer, List<Well> wells, char units, Set<Integer> dataTypes, int interpID, SBdb db) throws IOException, SQLException, SBException {
        String eol = "\r\n";
        writer.write("WELL NAME" + this.delimiter + (String)(this.writeWellcodes ? "WELL CODE" + this.delimiter : "") + "ZONES" + this.delimiter + "DEPTH" + this.delimiter + "TYPE" + this.delimiter + "DISCIPLINE" + eol);
        Iterator<Well> it = wells.iterator();
        char expUnits = units;
        while (it.hasNext()) {
            Well well = it.next();
            if (units == 'D') {
                expUnits = well.getWellUnits();
            }
            WellInterp wellInterp = well.getInterp(interpID);
            for (Integer i : dataTypes) {
                List<Object> zones = new LinkedList();
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        zones = wellInterp.getIGDList(IGDIntervalZone.dType2IGDtype(i));
                        break;
                    }
                    case 13: 
                    case 14: {
                        List<SQPick> picks = wellInterp.getSQPicks();
                        for (SQPick pick : picks) {
                            writer.write(well.getWellName() + this.delimiter);
                            if (this.writeWellcodes) {
                                writer.write(well.getWellCode() + this.delimiter);
                            }
                            writer.write(pick.getName().replace(' ', '_') + this.delimiter);
                            String sampleDepth = this.getSampleDepthString(well, pick.getSample(), expUnits);
                            writer.write(sampleDepth + this.delimiter);
                            writer.write(pick.getSample().getTypeString() + this.delimiter);
                            writer.write(eol);
                        }
                        break;
                    }
                }
                if (zones == null || zones.isEmpty()) continue;
                for (IGDIntervalZone iGDIntervalZone : zones) {
                    writer.write(well.getWellName() + this.delimiter);
                    if (this.writeWellcodes) {
                        writer.write(well.getWellCode() + this.delimiter);
                    }
                    writer.write(iGDIntervalZone.toString() + (!iGDIntervalZone.isSpotZone() ? "_Top" : "") + this.delimiter);
                    String topSampleDepth = this.getSampleDepthString(well, iGDIntervalZone.getTopSample(), expUnits);
                    writer.write(topSampleDepth + this.delimiter);
                    writer.write(iGDIntervalZone.getTopSample().getTypeString() + this.delimiter);
                    IGDScheme scheme = db.getIGDScheme(iGDIntervalZone.getSchID());
                    if (scheme.getDiscipline() != null) {
                        writer.write(scheme.getDiscipline().getAbr(false) + eol);
                    } else {
                        writer.write(eol);
                    }
                    if (iGDIntervalZone.isSpotZone()) continue;
                    writer.write(well.getWellName() + this.delimiter);
                    if (this.writeWellcodes) {
                        writer.write(well.getWellCode() + this.delimiter);
                    }
                    writer.write(iGDIntervalZone.toString() + "_Base" + this.delimiter);
                    String baseSampleDepth = this.getSampleDepthString(well, iGDIntervalZone.getBaseSample(), expUnits);
                    writer.write(baseSampleDepth + this.delimiter);
                    writer.write(iGDIntervalZone.getBaseSample().getTypeString() + this.delimiter);
                    if (scheme.getDiscipline() != null) {
                        writer.write(scheme.getDiscipline().getAbr(false) + eol);
                        continue;
                    }
                    writer.write(eol);
                }
            }
        }
    }

    public void exportFlatZonesFromWellsAsCSV(Writer writer, List<Well> wells, char units, Set<Integer> dataTypes, int interpID, boolean includeBnds) throws IOException, SBException, SQLException {
        String eol = "\r\n";
        writer.write("Well" + this.delimiter + (String)(this.writeWellcodes ? "Code" + this.delimiter : "") + "Top Sample Depth" + this.delimiter + "Type" + this.delimiter);
        if (includeBnds) {
            writer.write("Boundary" + this.delimiter);
        }
        writer.write("Base Sample Depth" + this.delimiter + "Type" + this.delimiter);
        if (includeBnds) {
            writer.write("Boundary" + this.delimiter);
        }
        writer.write("Legend" + eol);
        char expUnits = units;
        for (Well well : wells) {
            if (units == 'D') {
                expUnits = well.getWellUnits();
            }
            WellInterp wellInterp = well.getInterp(interpID);
            block5: for (Integer i : dataTypes) {
                List<Object> zones = new LinkedList();
                switch (i) {
                    case 10: 
                    case 11: 
                    case 12: {
                        zones = wellInterp.getIGDList(IGDIntervalZone.dType2IGDtype(i));
                        if (zones == null || zones.isEmpty()) break;
                        for (IGDIntervalZone iGDIntervalZone : zones) {
                            writer.write(well.getWellName() + this.delimiter);
                            if (this.writeWellcodes) {
                                writer.write(well.getWellCode() + this.delimiter);
                            }
                            String topSampleDepth = this.getSampleDepthString(well, iGDIntervalZone.getTopSample(), expUnits);
                            writer.write(topSampleDepth + this.delimiter);
                            writer.write(iGDIntervalZone.getTopSample().getTypeString() + this.delimiter);
                            if (includeBnds) {
                                writer.write(iGDIntervalZone.getTopBnd() + this.delimiter);
                            }
                            String baseSampleDepth = this.getSampleDepthString(well, iGDIntervalZone.getBaseSample(), expUnits);
                            writer.write(baseSampleDepth + this.delimiter);
                            writer.write(iGDIntervalZone.getBaseSample().getTypeString() + this.delimiter);
                            if (includeBnds) {
                                writer.write(iGDIntervalZone.getBaseBnd() + this.delimiter);
                            }
                            writer.write(iGDIntervalZone.toString() + eol);
                        }
                        continue block5;
                    }
                    case 15: {
                        List<IGDIntervalEnv> envs = wellInterp.getEnvs();
                        if (envs == null || envs.isEmpty()) break;
                        for (IGDIntervalEnv env : envs) {
                            writer.write(well.getWellName() + this.delimiter);
                            if (this.writeWellcodes) {
                                writer.write(well.getWellCode() + this.delimiter);
                            }
                            String topSampleDepth = this.getSampleDepthString(well, env.getTopSample(), expUnits);
                            writer.write(topSampleDepth + this.delimiter);
                            writer.write(env.getTopSample().getTypeString() + this.delimiter);
                            String baseSampleDepth = this.getSampleDepthString(well, env.getBaseSample(), expUnits);
                            writer.write(baseSampleDepth + this.delimiter);
                            writer.write(env.getBaseSample().getTypeString() + this.delimiter);
                            writer.write(env.toString() + eol);
                        }
                        break;
                    }
                }
            }
        }
    }

    /*
     * Could not resolve type clashes
     */
    public void exportWellsToCSVWithOneColumnPerDataType(Writer writer, List<Well> wells, char units, Set<Integer> dataTypes, int interpID, SBdb db, boolean includeBase) throws IOException, SBException, SQLException {
        Well well;
        String eol = "\r\n";
        LinkedList<Object> headers = new LinkedList<Object>();
        LinkedList rows = new LinkedList();
        block8: for (int dType : dataTypes) {
            LinkedList<Integer> schemeIDs = new LinkedList<Integer>();
            switch (dType) {
                case 1: {
                    break;
                }
                default: {
                    break;
                }
                case 11: {
                    Object wellInterp2;
                    for (Well well2 : wells) {
                        wellInterp2 = well2.getInterp(interpID);
                        List<IGDScheme> schemes = ((WellInterp)wellInterp2).getIGDSchemes(4);
                        for (IGDScheme scheme : schemes) {
                            if (schemeIDs.contains(scheme.getID())) continue;
                            schemeIDs.add(scheme.getID());
                        }
                    }
                }
                case 10: 
                case 12: {
                    Sample rowSample;
                    Well rowWell;
                    List row;
                    WellInterp wellInterp;
                    Well well3;
                    if (schemeIDs.isEmpty()) {
                        schemeIDs.add(0);
                    }
                    int igdType = IGDIntervalZone.dType2IGDtype(dType);
                    Object wellInterp2 = schemeIDs.iterator();
                    while (wellInterp2.hasNext()) {
                        int schID = (Integer)wellInterp2.next();
                        for (int hier = 1; hier <= IGDIntervalZone.getNHier(igdType, true); ++hier) {
                            System.out.println("Processing level: " + hier);
                            Iterator<Well> wellIt = wells.iterator();
                            boolean hierUsed = false;
                            while (wellIt.hasNext()) {
                                well3 = wellIt.next();
                                wellInterp = well3.getInterp(interpID);
                                List<IGDIntervalZone> list = wellInterp.getIGDList(igdType, schID);
                                System.out.println("Found: " + list.size() + " at this level.");
                                for (IGDIntervalZone zone : list) {
                                    if (zone.getHier() != hier) continue;
                                    hierUsed = true;
                                    boolean sampleFound = false;
                                    for (List row2 : rows) {
                                        Well rowWell2 = (Well)row2.get(0);
                                        if (well3 != rowWell2) continue;
                                        Sample rowSample2 = (Sample)row2.get(1);
                                        Sample rowBaseSample = null;
                                        if (includeBase && row2.get(2) instanceof Sample) {
                                            rowBaseSample = (Sample)row2.get(2);
                                        }
                                        if (zone.getTopSample() != rowSample2 || includeBase && rowBaseSample != zone.getBaseSample()) continue;
                                        row2.add(zone.toString());
                                        sampleFound = true;
                                        break;
                                    }
                                    if (sampleFound) continue;
                                    LinkedList<Object> newRow = new LinkedList<Object>();
                                    newRow.add(well3);
                                    newRow.add(zone.getTopSample());
                                    if (includeBase) {
                                        newRow.add(zone.getBaseSample());
                                    }
                                    for (String header : headers) {
                                        newRow.add(null);
                                    }
                                    newRow.add(zone.toString());
                                    Iterator rowIt = rows.iterator();
                                    int rowCount = 0;
                                    boolean insert = false;
                                    boolean wellFound = false;
                                    while (rowIt.hasNext()) {
                                        row = (List)rowIt.next();
                                        rowWell = (Well)row.get(0);
                                        if (well3 == rowWell) {
                                            wellFound = true;
                                            rowSample = (Sample)row.get(1);
                                            if (zone.getTopSample().getDepth() < rowSample.getDepth()) {
                                                insert = true;
                                                break;
                                            }
                                        } else if (wellFound) {
                                            insert = true;
                                            break;
                                        }
                                        ++rowCount;
                                    }
                                    System.out.println("Inserting sample: " + String.valueOf(zone.getTopSample()) + " at row: " + rowCount);
                                    if (insert) {
                                        rows.add(rowCount, newRow);
                                        continue;
                                    }
                                    rows.add(newRow);
                                }
                            }
                            if (!hierUsed) continue;
                            String header = SBdb.dTypeNames[dType] + " - " + IGDIntervalZone.getHierName(IGDIntervalZone.dType2IGDtype(dType), hier);
                            if (igdType == 4) {
                                header = header + " (" + db.getIGDScheme(schID).toString() + ")";
                            }
                            headers.add(header);
                            for (List row3 : rows) {
                                while (row3.size() < headers.size() + (includeBase ? 3 : 2)) {
                                    row3.add(null);
                                }
                            }
                        }
                    }
                    continue block8;
                }
                case 14: {
                    System.out.println("Processing sequence picks ");
                    Iterator<Well> wellIt = wells.iterator();
                    boolean hasSqpick = false;
                    while (wellIt.hasNext()) {
                        Well well4 = wellIt.next();
                        WellInterp wellInterp = well4.getInterp(interpID);
                        List<SQPick> list = wellInterp.getSQPicks();
                        System.out.println("Found: " + list.size());
                        for (SQPick pick : list) {
                            hasSqpick = true;
                            boolean sampleFound = false;
                            for (List row : rows) {
                                Well rowWell = (Well)row.get(0);
                                if (well4 != rowWell) continue;
                                Sample rowSample = (Sample)row.get(1);
                                if (pick.getSample() != rowSample) continue;
                                row.add(pick.getName());
                                sampleFound = true;
                                break;
                            }
                            if (sampleFound) continue;
                            LinkedList<Object> newRow = new LinkedList<Object>();
                            newRow.add(well4);
                            newRow.add(pick.getSample());
                            for (String header : headers) {
                                newRow.add(null);
                            }
                            newRow.add(pick.getName());
                            Iterator rowIt = rows.iterator();
                            int rowCount = 0;
                            boolean insert = false;
                            boolean wellFound = false;
                            while (rowIt.hasNext()) {
                                List row = (List)rowIt.next();
                                Well rowWell = (Well)row.get(0);
                                if (well4 == rowWell) {
                                    wellFound = true;
                                    Sample rowSample = (Sample)row.get(1);
                                    if (pick.getSample().getDepth() < rowSample.getDepth()) {
                                        insert = true;
                                        break;
                                    }
                                } else if (wellFound) {
                                    insert = true;
                                    break;
                                }
                                ++rowCount;
                            }
                            System.out.println("Inserting sample: " + String.valueOf(pick.getSample()) + " at row: " + rowCount);
                            if (insert) {
                                rows.add(rowCount, newRow);
                                continue;
                            }
                            rows.add(newRow);
                        }
                    }
                    if (!hasSqpick) continue block8;
                    String header = SBdb.dTypeNames[dType];
                    headers.add(header);
                    for (List row : rows) {
                        while (row.size() < headers.size() + (includeBase ? 3 : 2)) {
                            row.add(null);
                        }
                    }
                    continue block8;
                }
                case 15: {
                    System.out.println("Processing envs");
                    Iterator<Well> wellIt = wells.iterator();
                    boolean envUsed = false;
                    while (wellIt.hasNext()) {
                        well = wellIt.next();
                        WellInterp wellInterp = well.getInterp(interpID);
                        List<IGDIntervalEnv> list = wellInterp.getEnvs();
                        for (IGDIntervalEnv env : list) {
                            envUsed = true;
                            boolean sampleFound = false;
                            for (List row : rows) {
                                Well rowWell = (Well)row.get(0);
                                if (well != rowWell) continue;
                                Sample rowSample = (Sample)row.get(1);
                                Sample rowBaseSample = null;
                                if (includeBase && row.get(2) instanceof Sample) {
                                    rowBaseSample = (Sample)row.get(2);
                                }
                                if (env.getTopSample() != rowSample || includeBase && rowBaseSample != env.getBaseSample()) continue;
                                row.add(env.toString());
                                sampleFound = true;
                                break;
                            }
                            if (sampleFound) continue;
                            LinkedList<Object> newRow = new LinkedList<Object>();
                            newRow.add(well);
                            newRow.add(env.getTopSample());
                            if (includeBase) {
                                newRow.add(env.getBaseSample());
                            }
                            for (String header : headers) {
                                newRow.add(null);
                            }
                            newRow.add(env.toString());
                            Iterator rowIt = rows.iterator();
                            int rowCount = 0;
                            boolean insert = false;
                            boolean wellFound = false;
                            while (rowIt.hasNext()) {
                                List row = (List)rowIt.next();
                                Well rowWell = (Well)row.get(0);
                                if (well == rowWell) {
                                    wellFound = true;
                                    Sample rowSample = (Sample)row.get(1);
                                    if (env.getTopSample().getDepth() < rowSample.getDepth()) {
                                        insert = true;
                                        break;
                                    }
                                } else if (wellFound) {
                                    insert = true;
                                    break;
                                }
                                ++rowCount;
                            }
                            System.out.println("Inserting sample: " + String.valueOf(env.getTopSample()) + " at row: " + rowCount);
                            if (insert) {
                                rows.add(rowCount, newRow);
                                continue;
                            }
                            rows.add(newRow);
                        }
                    }
                    if (!envUsed) continue block8;
                    headers.add(SBdb.dTypeNames[15]);
                    for (List row : rows) {
                        while (row.size() < headers.size() + (includeBase ? 3 : 2)) {
                            row.add(null);
                        }
                    }
                    continue block8;
                }
                case 16: {
                    Sample rowSample;
                    Well rowWell;
                    List row;
                    WellInterp wellInterp;
                    Well well3;
                    System.out.println("Processing events");
                    Iterator<Well> wellIt3 = wells.iterator();
                    boolean eventsUsed = false;
                    while (wellIt3.hasNext()) {
                        well3 = wellIt3.next();
                        wellInterp = well3.getInterp(interpID);
                        List<WellEvent> evlist = wellInterp.getEvents();
                        for (WellEvent event : evlist) {
                            eventsUsed = true;
                            boolean sampleFound = false;
                            for (List row4 : rows) {
                                Well rowWell3 = (Well)row4.get(0);
                                if (well3 != rowWell3) continue;
                                Sample rowSample3 = (Sample)row4.get(1);
                                if (event.getSample() != rowSample3) continue;
                                row4.add(event.toString(true, false, false, units, true, false));
                                if (event.getQualifier() != null && !event.getQualifier().isEmpty()) {
                                    row4.add(event.getQualifier());
                                }
                                sampleFound = true;
                                break;
                            }
                            if (sampleFound) continue;
                            LinkedList<Object> newRow = new LinkedList<Object>();
                            newRow.add(well3);
                            newRow.add(event.getSample());
                            for (String header : headers) {
                                newRow.add(null);
                            }
                            newRow.add(event.toString(true, false, false, units, true, false));
                            if (event.getQualifier() != null && !event.getQualifier().isEmpty()) {
                                newRow.add(event.getQualifier());
                            }
                            Iterator rowIt = rows.iterator();
                            int rowCount = 0;
                            boolean insert = false;
                            boolean wellFound = false;
                            while (rowIt.hasNext()) {
                                row = (List)rowIt.next();
                                rowWell = (Well)row.get(0);
                                if (well3 == rowWell) {
                                    wellFound = true;
                                    rowSample = (Sample)row.get(1);
                                    if (event.getSample().getDepth() < rowSample.getDepth()) {
                                        insert = true;
                                        break;
                                    }
                                } else if (wellFound) {
                                    insert = true;
                                    break;
                                }
                                ++rowCount;
                            }
                            System.out.println("Inserting sample: " + String.valueOf(event.getSample()) + " at row: " + rowCount);
                            if (insert) {
                                rows.add(rowCount, newRow);
                                continue;
                            }
                            rows.add(newRow);
                        }
                    }
                    if (!eventsUsed) continue block8;
                    headers.add(SBdb.dTypeNames[16]);
                    for (List row5 : rows) {
                        while (row5.size() < headers.size() + (includeBase ? 3 : 2)) {
                            row5.add(null);
                        }
                    }
                    continue block8;
                }
            }
        }
        writer.write("Well" + this.delimiter + (String)(this.writeWellcodes ? "Code" + this.delimiter : "") + (includeBase ? "Top " : "") + "Depth" + this.delimiter + (includeBase ? "Top " : "") + "Sample Type");
        if (includeBase) {
            writer.write(this.delimiter + "Base Depth" + this.delimiter + " Base Sample Type");
        }
        Iterator ith = headers.iterator();
        while (ith.hasNext()) {
            writer.write(this.delimiter + (String)ith.next());
        }
        writer.write(eol);
        char expUnits = units;
        for (List row : rows) {
            for (Object obj : row) {
                if (obj instanceof Well) {
                    Well well5 = (Well)obj;
                    writer.write(well5.getWellName() + this.delimiter);
                    if (this.writeWellcodes) {
                        writer.write(well5.getWellCode() + this.delimiter);
                    }
                    if (units != 'D') continue;
                    expUnits = well5.getWellUnits();
                    continue;
                }
                if (obj instanceof Sample) {
                    Sample sample = (Sample)obj;
                    well = (Well)row.get(0);
                    String depth = this.useFixedDps ? this.getSampleDepthString(well, sample, expUnits) : Double.toString(this.getSampleDepth(well, sample, expUnits));
                    writer.write(depth + this.delimiter + sample.getTypeString() + this.delimiter);
                    continue;
                }
                if (obj != null) {
                    writer.write(String.valueOf(obj));
                }
                writer.write(this.delimiter);
            }
            writer.write(eol);
        }
    }

    public boolean getUseCoreSampleCorrections() {
        return this.useCoreSampleCorrections;
    }

    public void setUseCoreSampleCorrections(boolean value) {
        this.useCoreSampleCorrections = value;
    }

    public boolean getUseCuttingSampleCorrections() {
        return this.useCuttingSampleCorrections;
    }

    public void setUseCuttingSampleCorrections(boolean value) {
        this.useCuttingSampleCorrections = value;
    }
}

