/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io;

import java.io.IOException;
import java.io.Writer;
import java.util.List;
import jsbugs.io.SampleReportOptions;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import util.SBException;

public class TextExporterSamples {
    public void writeSamplesCSV(Writer out, List<Sample> samples, SBdb sbdb, String wellName, char wellUnits, SampleReportOptions options) throws IOException, SBException {
        char delim = ',';
        out.write("StrataBugs sample report for well: " + wellName + "\n\n");
        if (options.includeDepthRange()) {
            out.write("top" + delim + "base" + delim);
        } else {
            out.write("sample" + delim);
        }
        if (options.includeSampleType()) {
            out.write("type" + delim);
        }
        if (options.includeLabel()) {
            out.write("label" + delim);
        }
        if (options.includeAnalysisSummary() && options.includeAnalysts()) {
            for (char discID : SBdb.discArr) {
                out.write(SBdb.getDiscAbr(discID) + delim);
            }
        }
        out.write("\n");
        Object object = samples.iterator();
        while (object.hasNext()) {
            Sample sample = (Sample)object.next();
            if (options.includeDepthRange()) {
                if (sample.hasTopDepth()) {
                    out.write("" + sample.getTopDepth(wellUnits));
                }
                out.write(delim);
                if (sample.hasBaseDepth()) {
                    out.write("" + sample.getBaseDepth(wellUnits));
                }
                out.write(delim);
            } else {
                out.write(sample.toString(wellUnits, true, false, false, false, null, null) + delim);
            }
            if (options.includeSampleType()) {
                out.write(sample.getType().getAbr() + delim);
            }
            if (options.includeLabel()) {
                out.write(sample.getLabel() + delim);
            }
            if (options.includeAnalysisSummary()) {
                for (char discID : SBdb.discArr) {
                    if (sample.hasDisciplineData(discID)) {
                        Object analystString = "";
                        for (Smpdtl dtl : sample.getSmpdtls()) {
                            if (dtl.getDiscID() != discID) continue;
                            if (options.includeAnalysts()) {
                                if (!((String)analystString).isEmpty()) {
                                    analystString = (String)analystString + " ";
                                }
                                analystString = (String)analystString + dtl.getHeader().toString();
                            } else if (((String)analystString).isEmpty()) {
                                analystString = (String)analystString + SBdb.getDiscAbr(discID);
                            }
                            if (!dtl.getBarren() || options.includeAnalysts() && ((String)analystString).contains("barren")) continue;
                            analystString = (String)analystString + "(barren)";
                        }
                        out.write((String)analystString);
                    }
                    out.write(delim);
                }
            }
            out.write("\n");
        }
    }
}

