/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.analysis;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.util.Objects;

public class AnalysisOccurrenceCategory
implements Comparable<AnalysisOccurrenceCategory> {
    private AbundanceScheme abnScheme = null;
    private final Double depth;
    private final Double topDepth;
    private final Double baseDepth;
    private final String type;
    private final String analyst;
    private final String label;
    private final String status;

    public AnalysisOccurrenceCategory(Double depth, Double topDepth, Double baseDepth, String type, String analyst, String label, String status) {
        this.depth = depth;
        this.topDepth = topDepth;
        this.baseDepth = baseDepth;
        this.type = type;
        this.analyst = analyst;
        this.label = label;
        this.status = status;
    }

    public void setAbundanceScheme(AbundanceScheme abnScheme) {
        this.abnScheme = abnScheme;
    }

    public AbundanceScheme getAbundanceScheme() {
        return this.abnScheme;
    }

    public Double getDepth() {
        return this.depth;
    }

    public Double getTopDepth() {
        return this.topDepth;
    }

    public Double getBaseDepth() {
        return this.baseDepth;
    }

    public String getType() {
        return this.type;
    }

    public String getAnalyst() {
        return this.analyst;
    }

    public String getLabel() {
        return this.label;
    }

    public String getStatus() {
        return this.status;
    }

    public int hashCode() {
        int hash = 7;
        hash = 71 * hash + Objects.hashCode(this.depth);
        hash = 71 * hash + Objects.hashCode(this.topDepth);
        hash = 71 * hash + Objects.hashCode(this.baseDepth);
        hash = 71 * hash + Objects.hashCode(this.type);
        hash = 71 * hash + Objects.hashCode(this.analyst);
        hash = 71 * hash + Objects.hashCode(this.label);
        hash = 71 * hash + Objects.hashCode(this.status);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AnalysisOccurrenceCategory other = (AnalysisOccurrenceCategory)obj;
        if (!Objects.equals(this.type, other.type)) {
            return false;
        }
        if (!Objects.equals(this.analyst, other.analyst)) {
            return false;
        }
        if (!Objects.equals(this.label, other.label)) {
            return false;
        }
        if (!Objects.equals(this.status, other.status)) {
            return false;
        }
        if (!Objects.equals(this.depth, other.depth)) {
            return false;
        }
        if (!Objects.equals(this.topDepth, other.topDepth)) {
            return false;
        }
        return Objects.equals(this.baseDepth, other.baseDepth);
    }

    @Override
    public int compareTo(AnalysisOccurrenceCategory o) {
        int comparison = Double.compare(this.getDepth(), o.getDepth());
        if (comparison == 0) {
            comparison = this.getAnalyst().compareTo(o.getAnalyst());
        }
        return comparison;
    }

    public Object getValueForHeader(String header) {
        if (header == null) {
            return null;
        }
        Object value = null;
        if (header.equals(HEADERS.TOP)) {
            value = this.getTopDepth();
        } else if (header.equals(HEADERS.BASE)) {
            value = this.getBaseDepth();
        } else if (header.equals(HEADERS.DEPTH)) {
            value = this.getDepth();
        } else if (header.equals(HEADERS.TYPE)) {
            value = this.getType();
        } else if (header.equals(HEADERS.LABEL)) {
            value = this.getLabel();
        } else if (header.equals(HEADERS.STATUS)) {
            value = this.getStatus();
        } else if (header.equals(HEADERS.ANALYST)) {
            value = this.getAnalyst();
        }
        return value;
    }

    public static class HEADERS {
        static String TOP = "top";
        static String BASE = "base";
        static String DEPTH = "depth";
        static String TYPE = "type";
        static String ANALYST = "analyst";
        static String LABEL = "label";
        static String STATUS = "status";
        static String TOTAL = "Total";
    }
}

