/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.analysis;

import com.stratadata.model3.taxon.TaxonNameService;
import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.sql.SQLException;
import java.util.List;
import jsbugs.io.analysis.AnalysisOccurrenceCategory;
import jsbugs.io.analysis.OccurrenceCollection;
import jsbugs.io.analysis.TaxonOccurrenceCategory;
import model3.SBdb;
import model3.Sample;
import model3.Smpdtl;
import model3.SynonymScheme;
import model3.Taxon;
import model3.TaxonOcc;
import model3.TxGroup;
import model3.TxGroupSet;
import model3.Well;
import util.SBException;

public class OccurrenceCollator {
    private char units = (char)77;
    private boolean useCoreCorrections = false;
    private boolean useCuttingCorrections = false;
    private boolean hasMultipleSuiteNos = true;
    private boolean separateQuestionableTaxa = false;
    private boolean useAuthorInTitle = false;
    private boolean combineSampleAnalysis = false;
    private boolean hidePreparedAnalysis = false;
    private SynonymScheme synonymScheme = null;
    private boolean includeEmptyAnalyses = true;

    public OccurrenceCollection collectOccurrenceData(Well well, List<Smpdtl> selectedAnalyses, SBdb db, List<Taxon> orderedTaxonToInclude, List<Taxon> taxonToIncludeInCount, TxGroupSet setForNaming, int synSchID) throws SQLException, SBException {
        OccurrenceCollection data = new OccurrenceCollection();
        TaxonNameService taxonNameService = new TaxonNameService(db.getSynonymService(), db.getTaxonService(), this.synonymScheme != null ? this.synonymScheme.getSchID() : 0);
        for (Sample sample : well.getSamples()) {
            AnalysisOccurrenceCategory analysisCat = null;
            if (this.combineSampleAnalysis) {
                analysisCat = this.buildCombinedAnalysisCategory(db, well, sample, selectedAnalyses);
            }
            for (Smpdtl sampleAnalysis : sample.getAnalysesCopy()) {
                if (!selectedAnalyses.contains((Object)sampleAnalysis) || this.hidePreparedAnalysis && this.isAnalysisPrepared(sampleAnalysis)) continue;
                if (!this.combineSampleAnalysis) {
                    analysisCat = this.buildAnalysisCategory(db, well, sample, sampleAnalysis);
                }
                if (this.includeEmptyAnalyses) {
                    data.addAnalysisCategoryToSet(analysisCat);
                }
                for (TaxonOcc occ : sampleAnalysis.getOccurUnsorted()) {
                    if (orderedTaxonToInclude.contains(occ.getTaxon())) {
                        TaxonOccurrenceCategory taxonCat = this.buildTaxonCategory(occ, orderedTaxonToInclude, setForNaming, synSchID, taxonNameService);
                        data.addOccurrence(analysisCat, taxonCat, occ);
                    }
                    if (!taxonToIncludeInCount.contains(occ.getTaxon())) continue;
                    data.addAnalysisTotalOccurrences(analysisCat, occ);
                }
            }
        }
        return data;
    }

    public OccurrenceCollection collectAndGroupOccurrenceData(Well well, List<Smpdtl> selectedAnalyses, SBdb db, TxGroupSet groupSet, List<Taxon> taxonToIncludeInCount, int synSchID) throws SQLException, SBException {
        OccurrenceCollection data = new OccurrenceCollection();
        for (Sample sample : well.getSamples()) {
            AnalysisOccurrenceCategory analysisCat = null;
            if (this.combineSampleAnalysis) {
                analysisCat = this.buildCombinedAnalysisCategory(db, well, sample, selectedAnalyses);
            }
            for (Smpdtl sampleAnalysis : sample.getAnalysesCopy()) {
                if (!selectedAnalyses.contains((Object)sampleAnalysis) || this.hidePreparedAnalysis && this.isAnalysisPrepared(sampleAnalysis)) continue;
                if (!this.combineSampleAnalysis) {
                    analysisCat = this.buildAnalysisCategory(db, well, sample, sampleAnalysis);
                }
                if (this.includeEmptyAnalyses) {
                    data.addAnalysisCategoryToSet(analysisCat);
                }
                for (TxGroup group : groupSet.getGroups()) {
                    TaxonOccurrenceCategory taxonCat = this.buildTaxonGroupCategory(group);
                    data.addTaxonCategoryToSet(taxonCat);
                    for (TaxonOcc occ : sampleAnalysis.getOccurUnsorted()) {
                        if (!group.isMember(occ.getTaxon().getSpecID(), synSchID)) continue;
                        data.addOccurrence(analysisCat, taxonCat, occ);
                    }
                }
                for (TaxonOcc occ : sampleAnalysis.getOccurUnsorted()) {
                    if (!taxonToIncludeInCount.contains(occ.getTaxon())) continue;
                    data.addAnalysisTotalOccurrences(analysisCat, occ);
                }
            }
        }
        return data;
    }

    public OccurrenceCollection collectTotalOccurrenceData(Well well, List<Smpdtl> selectedAnalyses, SBdb db, String aggregateName, List<Taxon> taxonToInclude, List<Taxon> taxonToIncludeInCount) throws SQLException, SBException {
        OccurrenceCollection data = new OccurrenceCollection();
        for (Sample sample : well.getSamples()) {
            AnalysisOccurrenceCategory analysisCat = null;
            if (this.combineSampleAnalysis) {
                analysisCat = this.buildCombinedAnalysisCategory(db, well, sample, selectedAnalyses);
            }
            for (Smpdtl sampleAnalysis : sample.getAnalysesCopy()) {
                if (!selectedAnalyses.contains((Object)sampleAnalysis) || this.hidePreparedAnalysis && this.isAnalysisPrepared(sampleAnalysis)) continue;
                if (!this.combineSampleAnalysis) {
                    analysisCat = this.buildAnalysisCategory(db, well, sample, sampleAnalysis);
                }
                if (this.includeEmptyAnalyses) {
                    data.addAnalysisCategoryToSet(analysisCat);
                }
                TaxonOccurrenceCategory totalOccurrenceCat = new TaxonOccurrenceCategory(aggregateName, null, null, null, null, 0);
                data.addTaxonCategoryToSet(totalOccurrenceCat);
                for (TaxonOcc occ : sampleAnalysis.getOccurUnsorted()) {
                    if (taxonToInclude.contains(occ.getTaxon())) {
                        data.addOccurrence(analysisCat, totalOccurrenceCat, occ);
                    }
                    if (!taxonToIncludeInCount.contains(occ.getTaxon())) continue;
                    data.addAnalysisTotalOccurrences(analysisCat, occ);
                }
            }
        }
        return data;
    }

    private TaxonOccurrenceCategory buildTaxonGroupCategory(TxGroup group) {
        TaxonOccurrenceCategory taxonCat = new TaxonOccurrenceCategory(group.getName(), null, null, null, null, 0);
        return taxonCat;
    }

    private TaxonOccurrenceCategory buildTaxonCategory(TaxonOcc occ, List<Taxon> taxonOrder, TxGroupSet setForNaming, int synSchID, TaxonNameService nameService) throws SQLException, SBException {
        Taxon taxon = occ.getTaxon();
        Object taxonTitle = nameService.getSynonymString(taxon.getSpecID(), false, this.useAuthorInTitle, false);
        if (this.separateQuestionableTaxa && occ.getQuestionable()) {
            taxonTitle = (String)taxonTitle + " ?";
        }
        int sortOrder = taxonOrder.indexOf(taxon);
        String setName = null;
        Object groupName = null;
        if (setForNaming != null) {
            setName = setForNaming.getName();
            groupName = "";
            for (TxGroup setGroup : setForNaming.getGroups()) {
                if (!setGroup.isMember(taxon.getSpecID(), synSchID)) continue;
                if (((String)groupName).length() > 0) {
                    groupName = (String)groupName + " + ";
                }
                groupName = (String)groupName + setGroup.getName();
            }
        }
        TaxonOccurrenceCategory taxonCat = new TaxonOccurrenceCategory((String)taxonTitle, taxon.getCatMnem(), taxon.getAlphaCode(), setName, (String)groupName, sortOrder);
        return taxonCat;
    }

    private AnalysisOccurrenceCategory buildAnalysisCategory(SBdb db, Well well, Sample sample, Smpdtl sampleAnalysis) throws SQLException, SBException {
        Double top = this.getSampleTopDepth(well, sample);
        Double base = this.getSampleBaseDepth(well, sample);
        Double depth = this.getSampleDepth(well, sample);
        String analysis = sampleAnalysis.getAnalystAbr() + (String)(this.hasMultipleSuiteNos ? "/" + sampleAnalysis.getAnalyNo() : "");
        AnalysisOccurrenceCategory analysisCat = new AnalysisOccurrenceCategory(depth, top, base, sample.getType().name(), analysis, sample.getLabel(), sampleAnalysis.getAnalysisType().getString());
        analysisCat.setAbundanceScheme(db.getAbundanceSchemeService().findAbundanceScheme(sampleAnalysis.getHeader().getAbnSchID()).orElse(null));
        return analysisCat;
    }

    private AnalysisOccurrenceCategory buildCombinedAnalysisCategory(SBdb db, Well well, Sample sample, List<Smpdtl> selectedAnalyses) throws SQLException, SBException {
        Double top = this.getSampleTopDepth(well, sample);
        Double base = this.getSampleBaseDepth(well, sample);
        Double depth = this.getSampleDepth(well, sample);
        StringBuilder combinedAnalysisBuilder = new StringBuilder();
        StringBuilder combinedStatusBuilder = new StringBuilder();
        boolean first = true;
        AbundanceScheme abnSch = null;
        for (Smpdtl sampleAnalysis : sample.getAnalysesCopy()) {
            if (!selectedAnalyses.contains((Object)sampleAnalysis)) continue;
            if (!first) {
                combinedAnalysisBuilder.append("+");
                combinedStatusBuilder.append("+");
            } else {
                first = false;
            }
            String analysis = sampleAnalysis.getAnalystAbr() + (String)(this.hasMultipleSuiteNos ? "/" + sampleAnalysis.getAnalyNo() : "");
            if (abnSch == null) {
                abnSch = db.getAbundanceSchemeService().findAbundanceScheme(sampleAnalysis.getHeader().getAbnSchID()).orElse(null);
            }
            combinedAnalysisBuilder.append(analysis);
            combinedStatusBuilder.append(sampleAnalysis.getAnalysisType().getString());
        }
        String analysis = combinedAnalysisBuilder.toString();
        String status = combinedStatusBuilder.toString();
        AnalysisOccurrenceCategory analysisCat = new AnalysisOccurrenceCategory(depth, top, base, sample.getType().name(), analysis, sample.getLabel(), status);
        analysisCat.setAbundanceScheme(abnSch);
        return analysisCat;
    }

    private Double getSampleTopDepth(Well well, Sample sample) throws SQLException, SBException {
        Double depth = null;
        if (sample.hasTopDepth()) {
            depth = well.getSampleTopDepth(sample, this.units, this.useCoreCorrections, this.useCuttingCorrections);
            if (well.getHeader().getType() == 'O') {
                depth = -1.0 * depth;
            }
        }
        return depth;
    }

    private Double getSampleBaseDepth(Well well, Sample sample) throws SQLException, SBException {
        Double depth = null;
        if (sample.hasBaseDepth()) {
            depth = well.getSampleBaseDepth(sample, this.units, this.useCoreCorrections, this.useCuttingCorrections);
            if (well.getHeader().getType() == 'O') {
                depth = -1.0 * depth;
            }
        }
        return depth;
    }

    private Double getSampleDepth(Well well, Sample sample) throws SQLException, SBException {
        Double depth = null;
        if (sample.hasDepth()) {
            depth = well.getDepth(sample, this.units, this.useCoreCorrections, this.useCuttingCorrections);
            if (well.getHeader().getType() == 'O') {
                depth = -1.0 * depth;
            }
        }
        return depth;
    }

    private boolean isAnalysisPrepared(Smpdtl sampleAnalysis) {
        if (sampleAnalysis.getBarren()) {
            return false;
        }
        return !sampleAnalysis.isAnalysed();
    }

    public void setUseAuthorInTaxaTiles(boolean value) {
        this.useAuthorInTitle = value;
    }

    public void setUseCoreSampleCorrections(boolean value) {
        this.useCoreCorrections = value;
    }

    public void setUseCuttingSampleCorrections(boolean value) {
        this.useCuttingCorrections = value;
    }

    public void setCombineSampleAnalysis(boolean value) {
        this.combineSampleAnalysis = value;
    }

    public void setSynonymScheme(SynonymScheme value) {
        this.synonymScheme = value;
    }

    public void setSeparateQuestionableTaxa(boolean value) {
        this.separateQuestionableTaxa = value;
    }

    public void setHasMultipleSuiteNos(boolean value) {
        this.hasMultipleSuiteNos = value;
    }

    public void setHidePreparedAnalysis(boolean value) {
        this.hidePreparedAnalysis = value;
    }

    public void setUnits(char value) {
        this.units = value;
    }
}

