/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.igdxlsworkbook;

import com.stratadata.model3.Discipline;
import jsbugs.io.igdxlsworkbook.IXLSWorksheetWriter;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import model3.Biocom;
import model3.Well;
import model3.WellInterp;
import util.gridwriter.GridSheet;

public class IGDWorksheetWriterBiocom
implements IXLSWorksheetWriter {
    private final String worksheetName;
    private final Discipline discipline;
    private final SampleFormatter sampleFormatter;

    public IGDWorksheetWriterBiocom(String name, Discipline disc, SampleFormatter sf) {
        this.worksheetName = name;
        this.discipline = disc;
        this.sampleFormatter = sf;
    }

    @Override
    public String getName() {
        return this.worksheetName;
    }

    @Override
    public boolean hasDataToWrite(Well w, WellInterp interp) {
        for (Biocom com : interp.getComments()) {
            if (com.getDiscipline() != this.discipline) continue;
            return true;
        }
        return false;
    }

    @Override
    public void writeHeader(GridSheet gb) {
        if (this.sampleFormatter.getIncludeSampleType()) {
            gb.addRow(new Object[]{"Well Name", "Well Code", "Depth", "Comment"});
        } else {
            gb.addRow(new Object[]{"Well Name", "Well Code", "Depth", "Type", "Comment"});
        }
    }

    @Override
    public void writeData(GridSheet gb, Well w, WellInterp interp) throws Exception {
        for (Biocom com : interp.getComments()) {
            if (com.getDiscipline() != this.discipline) continue;
            gb.addRow(new Object[]{w.getWellName(), w.getWellCode(), this.sampleFormatter.getDepthValue(com.getTopSample(), w)});
            if (!this.sampleFormatter.getIncludeSampleType()) {
                gb.append(new Object[]{com.getTopSample().getTypeString()});
            }
            gb.append(new Object[]{com.getText()});
        }
    }
}

