/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.igdxlsworkbook;

import jsbugs.io.igdxlsworkbook.IXLSWorksheetWriter;
import jsbugs.io.igdxlsworkbook.SampleFormatter;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import util.gridwriter.GridSheet;

public class IGDWorksheetWriterEvents
implements IXLSWorksheetWriter {
    private final SampleFormatter sampleFormatter;

    public IGDWorksheetWriterEvents(SampleFormatter sf) {
        this.sampleFormatter = sf;
    }

    @Override
    public String getName() {
        return "Events";
    }

    @Override
    public boolean hasDataToWrite(Well w, WellInterp interp) {
        return interp.getEvents().size() > 0;
    }

    @Override
    public void writeHeader(GridSheet gb) {
        gb.addRow(new Object[]{"Well Name", "Well Code", "Depth", "Type", "Event", "Discipline"});
    }

    @Override
    public void writeData(GridSheet gb, Well w, WellInterp interp) throws Exception {
        for (WellEvent evt : interp.getEvents()) {
            String discipline = null;
            if (evt.getDiscIDTaxon() != null) {
                discipline = evt.getDiscIDTaxon().getAbr(false);
            }
            gb.addRow(new Object[]{w.getWellName(), w.getWellCode(), this.sampleFormatter.getDepthValue(evt.getSample(), w), evt.getType(), evt.getSbEvent().getName(), discipline});
        }
    }
}

