/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.igdxlsworkbook;

import com.stratadata.model3.well.sample.SampleType;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.SQLException;
import model3.Sample;
import model3.Well;
import util.DepthUnits;

public class SampleFormatter {
    private final boolean includeSampleType;
    private final boolean includeUnitAbr;
    private final boolean useCoreCorrections;
    private final boolean useCuttingCorrections;

    public SampleFormatter(boolean includeSampleType, boolean includeUnitAbr, boolean useCoreCorrections, boolean useCuttingCorrections) {
        this.includeSampleType = includeSampleType;
        this.includeUnitAbr = includeUnitAbr;
        this.useCoreCorrections = useCoreCorrections;
        this.useCuttingCorrections = useCuttingCorrections;
    }

    public boolean getIncludeSampleType() {
        return this.includeSampleType;
    }

    public Object getDepthValue(Sample s, Well w) throws SQLException {
        return this.getDepthValue(s, w, w.getWellUnits());
    }

    public Object getDepthValue(Sample s, Well w, char units) throws SQLException {
        Object depthObject = null;
        if (s.hasDepth()) {
            double depth = this.useCoreCorrections || this.useCuttingCorrections ? w.getDepth(s, units, this.useCoreCorrections, this.useCuttingCorrections) : s.getDepth(units);
            depthObject = this.getDepthValue(depth, s.getType(), units);
        }
        return depthObject;
    }

    private Object getDepthValue(double depth, SampleType type, char units) {
        if (!this.includeSampleType && !this.includeUnitAbr) {
            return (double)Math.round(depth * 100.0) / 100.0;
        }
        StringBuilder sb = new StringBuilder();
        BigDecimal bd = new BigDecimal(Double.toString(depth));
        bd = bd.setScale(2, RoundingMode.HALF_UP).stripTrailingZeros();
        sb.append(bd.toPlainString());
        if (this.includeUnitAbr) {
            sb.append(DepthUnits.getUnits((char)units).getIndicatorStr());
        }
        if (this.includeSampleType) {
            sb.append(" ").append(type.getAbr());
        }
        return sb.toString();
    }
}

