/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.spdcworkbook;

import com.stratadata.util.ui.SBDialog;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.sql.SQLException;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import model3.IGDScheme;
import model3.Lastval;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import util.exception.StackError;

public class DialogSPDCSummaryWorkbook
extends SBDialog {
    private String defaultDirectory = null;
    private static Boolean useColours;
    private static Boolean useLegacyXLS;
    private static Boolean coreCorr;
    private static Boolean cuCorr;
    DefaultListModel model = new DefaultListModel();
    SBdb db;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonFolderSelect;
    private JButton jButtonOK;
    private JCheckBox jCheckBoxColours;
    private JCheckBox jCheckBoxCoreCorrections;
    private JCheckBox jCheckBoxCuttingCorrections;
    private JCheckBox jCheckBoxLegacyExcel;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JList<String> jListBiozones;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelCorrectionOptions;
    private JPanel jPanelExportOptions;
    private JRadioButton jRadioButton1column;
    private JRadioButton jRadioButton2column;
    private JScrollPane jScrollPane1;
    private JTextField jTextFieldOutputFolderPath;

    public DialogSPDCSummaryWorkbook(Frame parent, boolean modal, SBdb db, List<IGDScheme> schemes) throws SQLException {
        super(parent, modal);
        this.initComponents();
        this.db = db;
        this.setTitle("Interpretation Summary Export Options");
        GroupLayout layout = (GroupLayout)this.getContentPane().getLayout();
        layout.linkSize(0, this.jButtonOK, this.jButtonCancel);
        this.getRootPane().setDefaultButton(this.jButtonOK);
        this.setDefaults();
        for (IGDScheme scheme : schemes) {
            this.model.addElement(scheme);
        }
        this.jListBiozones.repaint();
        int[] prevSelection = this.getPreviousSchemeIDs();
        if (prevSelection == null) {
            this.jListBiozones.setSelectionInterval(0, this.model.getSize() - 1);
        } else {
            for (int i : prevSelection) {
                for (int is = 0; is < schemes.size(); ++is) {
                    if (schemes.get(is).getID() != i) continue;
                    this.jListBiozones.addSelectionInterval(is, is);
                }
            }
        }
    }

    private int[] getPreviousSchemeIDs() throws SQLException {
        String schemeIDs = Lastval.getString(this.db, "SPDCBZSCH");
        if (schemeIDs == null || schemeIDs.isEmpty()) {
            return null;
        }
        String[] IDs = StringUtils.split((String)schemeIDs, (char)'|');
        int[] intIDs = new int[IDs.length];
        int i = 0;
        for (String s : IDs) {
            intIDs[i++] = Integer.parseInt(s);
        }
        return intIDs;
    }

    private void putPreviousSchemeIDs(List<IGDScheme> selectedSchemes) throws SQLException {
        Object IDs = null;
        for (IGDScheme scheme : selectedSchemes) {
            IDs = IDs == null ? "" : (String)IDs + "|";
            IDs = (String)IDs + scheme.getID();
        }
        Lastval.putString(this.db, "SPDCBZSCH", IDs);
    }

    private void setDefaults() {
        if (useColours != null) {
            this.jCheckBoxColours.setSelected(useColours);
        }
        if (useLegacyXLS != null) {
            this.jCheckBoxLegacyExcel.setSelected(useLegacyXLS);
        }
        if (coreCorr != null) {
            this.jCheckBoxCoreCorrections.setSelected(coreCorr);
        }
        if (cuCorr != null) {
            this.jCheckBoxCuttingCorrections.setSelected(cuCorr);
        }
    }

    private void getDefaults() {
        useColours = this.jCheckBoxColours.isSelected();
        useLegacyXLS = this.jCheckBoxLegacyExcel.isSelected();
        coreCorr = this.jCheckBoxCoreCorrections.isSelected();
        cuCorr = this.jCheckBoxCuttingCorrections.isSelected();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel2 = new JLabel();
        this.jTextFieldOutputFolderPath = new JTextField();
        this.jButtonFolderSelect = new JButton();
        this.jPanelExportOptions = new JPanel();
        this.jCheckBoxLegacyExcel = new JCheckBox();
        this.jCheckBoxColours = new JCheckBox();
        this.jPanelCorrectionOptions = new JPanel();
        this.jCheckBoxCoreCorrections = new JCheckBox();
        this.jCheckBoxCuttingCorrections = new JCheckBox();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jPanel1 = new JPanel();
        this.jRadioButton1column = new JRadioButton();
        this.jRadioButton2column = new JRadioButton();
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListBiozones = new JList();
        this.jLabel1.setText("jLabel1");
        this.setDefaultCloseOperation(2);
        this.jLabel2.setText("Folder :");
        this.jTextFieldOutputFolderPath.setBackground(new Color(255, 255, 204));
        this.jButtonFolderSelect.setText("...");
        this.jButtonFolderSelect.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSPDCSummaryWorkbook this$0;
            {
                DialogSPDCSummaryWorkbook dialogSPDCSummaryWorkbook = this$0;
                Objects.requireNonNull(dialogSPDCSummaryWorkbook);
                this.this$0 = dialogSPDCSummaryWorkbook;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonFolderSelectActionPerformed(evt);
            }
        });
        this.jPanelExportOptions.setBorder(BorderFactory.createTitledBorder(null, "Export Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxLegacyExcel.setText("Output legacy .xls files");
        this.jCheckBoxColours.setSelected(true);
        this.jCheckBoxColours.setText("Use scheme colours for cell colour");
        GroupLayout jPanelExportOptionsLayout = new GroupLayout(this.jPanelExportOptions);
        this.jPanelExportOptions.setLayout(jPanelExportOptionsLayout);
        jPanelExportOptionsLayout.setHorizontalGroup(jPanelExportOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExportOptionsLayout.createSequentialGroup().addContainerGap().addGroup(jPanelExportOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxLegacyExcel).addComponent(this.jCheckBoxColours)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanelExportOptionsLayout.setVerticalGroup(jPanelExportOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelExportOptionsLayout.createSequentialGroup().addComponent(this.jCheckBoxLegacyExcel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxColours)));
        this.jPanelCorrectionOptions.setBorder(BorderFactory.createTitledBorder(null, "Correction Options", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jCheckBoxCoreCorrections.setText("Output core-corrected depths for core samples");
        this.jCheckBoxCuttingCorrections.setText("Output core-corrected depths for cutting samples");
        GroupLayout jPanelCorrectionOptionsLayout = new GroupLayout(this.jPanelCorrectionOptions);
        this.jPanelCorrectionOptions.setLayout(jPanelCorrectionOptionsLayout);
        jPanelCorrectionOptionsLayout.setHorizontalGroup(jPanelCorrectionOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCorrectionOptionsLayout.createSequentialGroup().addGap(0, 0, 0).addGroup(jPanelCorrectionOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jCheckBoxCuttingCorrections).addComponent(this.jCheckBoxCoreCorrections)).addContainerGap(147, Short.MAX_VALUE)));
        jPanelCorrectionOptionsLayout.setVerticalGroup(jPanelCorrectionOptionsLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanelCorrectionOptionsLayout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jCheckBoxCoreCorrections).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jCheckBoxCuttingCorrections)));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSPDCSummaryWorkbook this$0;
            {
                DialogSPDCSummaryWorkbook dialogSPDCSummaryWorkbook = this$0;
                Objects.requireNonNull(dialogSPDCSummaryWorkbook);
                this.this$0 = dialogSPDCSummaryWorkbook;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogSPDCSummaryWorkbook this$0;
            {
                DialogSPDCSummaryWorkbook dialogSPDCSummaryWorkbook = this$0;
                Objects.requireNonNull(dialogSPDCSummaryWorkbook);
                this.this$0 = dialogSPDCSummaryWorkbook;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Chronostratigraphy columns", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroup1.add(this.jRadioButton1column);
        this.jRadioButton1column.setText("1 Column");
        this.buttonGroup1.add(this.jRadioButton2column);
        this.jRadioButton2column.setSelected(true);
        this.jRadioButton2column.setText("2 Columns");
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(this.jRadioButton1column).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jRadioButton2column).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jRadioButton1column).addComponent(this.jRadioButton2column)).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(null, "Biozone schemes", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.jListBiozones.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jListBiozones);
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jScrollPane1));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addContainerGap().addComponent(this.jScrollPane1).addContainerGap()));
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE).addComponent(this.jPanelExportOptions, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.LEADING, layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldOutputFolderPath).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonFolderSelect)).addComponent(this.jPanelCorrectionOptions, GroupLayout.Alignment.LEADING, -1, -1, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOK).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonCancel))).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.jTextFieldOutputFolderPath, -2, -1, -2).addComponent(this.jButtonFolderSelect)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelExportOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanelCorrectionOptions, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -1, -1, Short.MAX_VALUE).addGap(18, 18, 18).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonCancel).addComponent(this.jButtonOK)).addContainerGap()));
        this.pack();
    }

    private void jButtonFolderSelectActionPerformed(ActionEvent evt) {
        File lastFolder = this.getOutputFolder();
        if (lastFolder == null) {
            lastFolder = new File(this.defaultDirectory);
        }
        JFileChooser fileChooser = new JFileChooser(lastFolder);
        fileChooser.setFileSelectionMode(1);
        int opt = fileChooser.showSaveDialog((Component)((Object)this));
        if (opt == 1) {
            return;
        }
        this.setOutputFolder(fileChooser.getSelectedFile());
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.getOutputFolder() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "No output folder selected, please select a folder.", this.getTitle(), 2);
        } else {
            try {
                this.getDefaults();
                this.putPreviousSchemeIDs(this.getSelectedSchemes());
                this.setIsOK(true);
                this.setVisible(false);
            }
            catch (SQLException ex) {
                StackError.showStackError((Exception)ex);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setIsOK(false);
        this.setVisible(false);
    }

    public File getOutputFolder() {
        String text = this.jTextFieldOutputFolderPath.getText();
        File f = null;
        if (!StringUtils.isEmpty((CharSequence)text) && !(f = new File(text)).isDirectory()) {
            f = null;
        }
        return f;
    }

    public boolean getUseLegacyExcelOutput() {
        return this.jCheckBoxLegacyExcel.isSelected();
    }

    public boolean getCoreSampleCorrection() {
        return this.jCheckBoxCoreCorrections.isSelected();
    }

    public boolean getCuttingSampleCorrection() {
        return this.jCheckBoxCuttingCorrections.isSelected();
    }

    public boolean getUseColours() {
        return this.jCheckBoxColours.isSelected();
    }

    public void setDefaultDirectory(String defaultDirectory) {
        this.defaultDirectory = defaultDirectory;
    }

    public void setOutputFolder(File folder) {
        if (folder != null) {
            this.jTextFieldOutputFolderPath.setText(folder.getPath());
        }
    }

    public List<IGDScheme> getSelectedSchemes() {
        int[] selected;
        LinkedList<IGDScheme> selectedSchemes = new LinkedList<IGDScheme>();
        for (int i : selected = this.jListBiozones.getSelectedIndices()) {
            selectedSchemes.add((IGDScheme)this.model.getElementAt(i));
        }
        return selectedSchemes;
    }

    public boolean isSingleChronoStratColumn() {
        return this.jRadioButton1column.isSelected();
    }
}

