/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.io.welldata;

import java.awt.Color;
import java.sql.SQLException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import jsbugs.io.welldata.GridHelperOneColumnPerDataType;
import jsbugs.io.welldata.ISampleSummaryRecordBuilder;
import jsbugs.io.welldata.SampleSummaryRecord;
import jsbugs.io.welldata.SampleSummaryRecordBuilder;
import jsbugs.io.welldata.WellDataSummaryRecord;
import model3.IGDColMap;
import model3.IGDInterval;
import model3.IGDIntervalEnv;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.SBdb;
import model3.SQPick;
import model3.Sample;
import model3.Well;
import model3.WellEvent;
import model3.WellInterp;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import util.CompareUtils;
import util.DepthUnits;
import util.SBException;
import util.gridwriter.CellDataFormat;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;

public class GridBuilderWellInterpSummary {
    private final ISampleSummaryRecordBuilder recordBuilder;
    private boolean includeWellCode = false;
    private boolean includeVersionName = false;
    private boolean includeUncorrectedDepths = false;
    private static final CellFormat DEPTH_FORMAT = new CellFormat().setDataFormat(CellDataFormat.Fixed2DP);

    public GridBuilderWellInterpSummary(SBdb db) {
        this(new SampleSummaryRecordBuilder(db));
    }

    public GridBuilderWellInterpSummary(ISampleSummaryRecordBuilder builder) {
        this.recordBuilder = builder;
    }

    public Object[][] buildGridOneColumnPerType(List<Well> wells, Set<Integer> interpIds, char units, Set<Integer> dataTypes, boolean includeBase) throws SBException, SQLException {
        GridHelperOneColumnPerDataType helper = new GridHelperOneColumnPerDataType();
        GridSheet gb = new GridSheet();
        List<WellDataSummaryRecord> records = this.recordBuilder.buildRecords(wells, units, dataTypes, interpIds);
        return helper.populateGridOneColumnPerType(gb, records, this.includeWellCode, this.includeVersionName, includeBase, units);
    }

    public Object[][] buildGridFlatWithExtra(List<Well> wells, Set<Integer> interpIds, char units, Set<Integer> dataTypes) throws SBException, SQLException {
        GridSheet gb = new GridSheet();
        List<WellDataSummaryRecord> records = this.recordBuilder.buildRecords(wells, units, dataTypes, interpIds);
        gb.addRow(new Object[]{"Well Name"});
        if (this.includeWellCode) {
            gb.append(new Object[]{"Well Code"});
        }
        if (this.includeVersionName) {
            gb.append(new Object[]{"Version"});
        }
        DepthUnits u = DepthUnits.getUnits((char)units);
        gb.append(new Object[]{"Top Sample Depth (" + u.getAbr() + ")"});
        if (this.includeUncorrectedDepths) {
            gb.append(new Object[]{"Top (uncorrected)"});
        }
        gb.append(new Object[]{"Top Sample Type", "Top Boundary", "Base Sample Depth (" + u.getAbr() + ")"});
        if (this.includeUncorrectedDepths) {
            gb.append(new Object[]{"Base (uncorrected)"});
        }
        gb.append(new Object[]{"Base Sample Type", "Base Boundary", "Data Type", "Scheme", "Pick Type", "Pick Name"});
        this.sortRecords(records);
        for (WellDataSummaryRecord rec : records) {
            gb.addRow();
            gb.append(new Object[]{rec.getWellName()});
            if (this.includeWellCode) {
                gb.append(new Object[]{rec.getWellCode()});
            }
            if (this.includeVersionName) {
                gb.append(new Object[]{rec.getVersionName()});
            }
            this.appendSample(gb, rec.getTopSample(), true);
            this.appendSample(gb, rec.getBaseSample(), true);
            String pickType = null;
            if (rec.getPickType() != null) {
                pickType = rec.getPickType().getName();
            }
            gb.append(new Object[]{SBdb.dTypeNames[rec.getDataType()], rec.getScheme(), pickType, rec.getValue()});
        }
        return gb.getObjectArray();
    }

    public Object[][] buildGridFlat(List<Well> wells, Set<Integer> interpIds, char units, Set<Integer> dataTypes, boolean includeBoundary) throws SBException, SQLException {
        GridSheet gb = new GridSheet();
        List<WellDataSummaryRecord> records = this.recordBuilder.buildRecords(wells, units, dataTypes, interpIds);
        DepthUnits u = DepthUnits.getUnits((char)units);
        gb.addRow(new Object[]{"Well"});
        if (this.includeWellCode) {
            gb.append(new Object[]{"Code"});
        }
        if (this.includeVersionName) {
            gb.append(new Object[]{"Version"});
        }
        gb.append(new Object[]{"Top Sample Depth (" + u.getAbr() + ")"});
        if (this.includeUncorrectedDepths) {
            gb.append(new Object[]{"Top (uncorrected)"});
        }
        gb.append(new Object[]{"Type"});
        if (includeBoundary) {
            gb.append(new Object[]{"Boundary"});
        }
        gb.append(new Object[]{"Base Sample Depth (" + u.getAbr() + ")"});
        if (this.includeUncorrectedDepths) {
            gb.append(new Object[]{"Base (uncorrected)"});
        }
        gb.append(new Object[]{"Type"});
        if (includeBoundary) {
            gb.append(new Object[]{"Boundary"});
        }
        gb.append(new Object[]{"Legend"});
        this.sortRecords(records);
        for (WellDataSummaryRecord rec : records) {
            gb.addRow();
            gb.append(new Object[]{rec.getWellName()});
            if (this.includeWellCode) {
                gb.append(new Object[]{rec.getWellCode()});
            }
            if (this.includeVersionName) {
                gb.append(new Object[]{rec.getVersionName()});
            }
            this.appendSample(gb, rec.getTopSample(), includeBoundary);
            this.appendSample(gb, rec.getBaseSample(), includeBoundary);
            gb.append(new Object[]{rec.getValue()});
        }
        return gb.getObjectArray();
    }

    public Object[][] buildGrid2LinesPerSample(List<Well> wells, Set<Integer> interpIds, char units, Set<Integer> dataTypes) throws SBException, SQLException {
        GridSheet gb = new GridSheet();
        List<WellDataSummaryRecord> records = this.recordBuilder.buildRecords(wells, units, dataTypes, interpIds);
        DepthUnits u = DepthUnits.getUnits((char)units);
        gb.addRow(new Object[]{"WELL NAME"});
        if (this.includeWellCode) {
            gb.append(new Object[]{"WELL CODE"});
        }
        if (this.includeVersionName) {
            gb.append(new Object[]{"VERSION"});
        }
        gb.append(new Object[]{"ZONES", "DEPTH (" + u.getAbr().toUpperCase() + ")"});
        if (this.includeUncorrectedDepths) {
            gb.append(new Object[]{"UNCORRECTED DEPTH (" + u.getAbr().toUpperCase() + ")"});
        }
        gb.append(new Object[]{"TYPE", "LEVEL", "DISCIPLINE"});
        this.sortRecords(records);
        for (WellDataSummaryRecord rec : records) {
            if (rec.getTopSample() == null || rec.getBaseSample() == null || rec.getTopSample().equalsDepthAndType(rec.getBaseSample())) {
                SampleSummaryRecord s = rec.getTopSample();
                if (s == null) {
                    s = rec.getBaseSample();
                }
                gb.addRow();
                gb.append(new Object[]{rec.getWellName()});
                if (this.includeWellCode) {
                    gb.append(new Object[]{rec.getWellCode()});
                }
                if (this.includeVersionName) {
                    gb.append(new Object[]{rec.getVersionName()});
                }
                gb.append(new Object[]{rec.getValue()});
                this.appendSample(gb, s, false);
                gb.append(new Object[]{rec.getPickType().getName()});
                gb.append(new Object[]{rec.getDiscipline()});
                continue;
            }
            gb.addRow();
            gb.append(new Object[]{rec.getWellName()});
            if (this.includeWellCode) {
                gb.append(new Object[]{rec.getWellCode()});
            }
            if (this.includeVersionName) {
                gb.append(new Object[]{rec.getVersionName()});
            }
            gb.append(new Object[]{rec.getValue() + "_Top"});
            this.appendSample(gb, rec.getTopSample(), false);
            gb.append(new Object[]{rec.getPickType().getName()});
            gb.append(new Object[]{rec.getDiscipline()});
            gb.addRow();
            gb.append(new Object[]{rec.getWellName()});
            if (this.includeWellCode) {
                gb.append(new Object[]{rec.getWellCode()});
            }
            if (this.includeVersionName) {
                gb.append(new Object[]{rec.getVersionName()});
            }
            gb.append(new Object[]{rec.getValue() + "_Base"});
            this.appendSample(gb, rec.getBaseSample(), false);
            gb.append(new Object[]{rec.getPickType().getName()});
            gb.append(new Object[]{rec.getDiscipline()});
        }
        return gb.getObjectArray();
    }

    public Object[][] buildGridBHP(List<Well> wells, int interpID, Set<Integer> dataTypes) throws SBException, SQLException {
        GridSheet gb = new GridSheet();
        HashSet<Integer> interpIds = new HashSet<Integer>();
        interpIds.add(interpID);
        DepthUnits u = DepthUnits.getUnits((char)'D');
        String IDString = "BIO" + (Calendar.getInstance().get(1) - 2000);
        List<WellDataSummaryRecord> records = this.recordBuilder.buildRecords(wells, 'D', dataTypes, interpIds);
        gb.addRow(new Object[]{"Well Name"});
        gb.append(new Object[]{"UWI"});
        gb.append(new Object[]{"ID"});
        gb.append(new Object[]{"Depth"});
        gb.append(new Object[]{"Pick"});
        gb.append(new Object[]{"Qualifier"});
        gb.append(new Object[]{"Confidence"});
        gb.append(new Object[]{"pick_kind"});
        for (WellDataSummaryRecord rec : records) {
            gb.addRow();
            gb.append(new Object[]{rec.getWellName()});
            gb.append(new Object[]{rec.getWellCode()});
            gb.append(new Object[]{IDString});
            Object o = rec.getObject();
            if (o instanceof WellEvent) {
                gb.append(new Object[]{(double)Math.round(rec.getTopSample().getDepth() * 100.0) / 100.0});
                WellEvent event = (WellEvent)o;
                gb.append(new Object[]{event.getEvent().getName()});
                gb.append(new Object[]{event.getQualifier()});
                switch (event.getConfidence()) {
                    case POSSIBLE: {
                        gb.append(new Object[]{"Low"});
                        break;
                    }
                    case PROBABLE: {
                        gb.append(new Object[]{"Medium"});
                        break;
                    }
                    case CONFIDENT: {
                        gb.append(new Object[]{"High"});
                    }
                }
                gb.append(new Object[]{""});
                continue;
            }
            if (!(o instanceof IGDIntervalZone)) continue;
            IGDIntervalZone zone = (IGDIntervalZone)o;
            if (zone.getIGDType() == 3) {
                gb.append(new Object[]{(double)Math.round(rec.getTopSample().getDepth() * 100.0) / 100.0});
                Object name = this.switchUnitTerm(zone.getUppInf());
                IGDUnit unit = zone.getUppUnit(false);
                if (unit != null && unit.getAbr() != null && !unit.getAbr().isEmpty()) {
                    name = unit.getAbr();
                }
                if (zone.getLowInf() != null && !zone.getLowInf().isEmpty()) {
                    name = (String)name + " " + zone.getSep() + " ";
                    unit = zone.getLowUnit(false);
                    name = unit != null && unit.getAbr() != null && !unit.getAbr().isEmpty() ? (String)name + unit.getAbr() : (String)name + this.switchUnitTerm(zone.getLowInf());
                }
                gb.append(new Object[]{name});
                gb.append(new Object[]{"TOP"});
                this.writeBHPBoundary(gb, zone.getTopBndInt());
                continue;
            }
            if (zone.getIGDType() != 4) continue;
            gb.append(new Object[]{(double)Math.round(rec.getBaseSample().getDepth() * 100.0) / 100.0});
            gb.append(new Object[]{rec.getValue()});
            gb.append(new Object[]{"BASE"});
            this.writeBHPBoundary(gb, zone.getBaseBndInt());
        }
        return gb.getObjectArray();
    }

    public GridSheet buildGridSPDC(Well well, int interpID, Set<Integer> dataTypes, boolean useCoreCorrections, boolean useCuttingCorrections, boolean useColours, boolean singleChronoStratColumn, List<IGDScheme> selectedBzSchemes) throws SBException, SQLException {
        GridSheet sheet = new GridSheet();
        CellFormat headerFormat = new CellFormat().setBold(true).setAlignment(HorizontalAlignment.CENTER).setBorder(15).setVerticalAlignment(VerticalAlignment.CENTER).setWrap(true);
        CellFormat rowFormat = new CellFormat().setBorder(8).setAlignment(HorizontalAlignment.CENTER);
        class SPDCInterpDataColumn {
            int dataType;
            int igdType;
            String dataTypeName;
            int schID;
            String schemeName;
            int hierFrom;
            int hierTo;
            String hierName;

            SPDCInterpDataColumn(GridBuilderWellInterpSummary this$0) {
                Objects.requireNonNull(this$0);
            }
        }
        LinkedList<SPDCInterpDataColumn> columns = new LinkedList<SPDCInterpDataColumn>();
        TreeSet<Sample> samples = new TreeSet<Sample>();
        sheet.addRowFormatted((short)3, headerFormat, new Object[]{"Well Code"});
        if (well.getHeader().getOcs() != null && !well.getHeader().getOcs().isEmpty()) {
            if (well.getHeader().getOcs().startsWith("OML")) {
                sheet.appendFormatted(headerFormat, new Object[]{"OML"});
            } else {
                sheet.appendFormatted(headerFormat, new Object[]{"OCS"});
            }
        }
        sheet.appendFormatted(headerFormat, new Object[]{"Well Name"});
        sheet.appendFormatted(headerFormat, new Object[]{"Depth" + (well.getWellUnits() == 'M' ? "(m)" : "(ft)")});
        sheet.appendFormatted(headerFormat, new Object[]{"SampleType"});
        WellInterp wellInterp = well.getInterp(interpID);
        well.loadInterp(wellInterp);
        block14: for (int dType : dataTypes) {
            int igdType;
            if (!SBdb.isInterpDataType(dType) || !wellInterp.hasData(igdType = IGDInterval.dType2IGDtype(dType))) continue;
            if (igdType != 5) {
                List<IGDScheme> schemes = igdType == 21 ? wellInterp.getSequenceSchemes() : wellInterp.getIGDSchemes(igdType);
                for (IGDScheme iGDScheme : schemes) {
                    if (igdType == 4 && !this.schemeWanted(selectedBzSchemes, iGDScheme.getID())) continue;
                    SPDCInterpDataColumn column = new SPDCInterpDataColumn(this);
                    column.dataType = dType;
                    column.igdType = igdType;
                    column.dataTypeName = IGDInterval.getIGDName(igdType);
                    column.schemeName = iGDScheme.getName();
                    column.schID = iGDScheme.getID();
                    column.hierTo = -1;
                    column.hierFrom = -1;
                    columns.add(column);
                    if (dType == 10) {
                        IGDColMap colMap = wellInterp.getColMap(well.getWellID(), igdType);
                        column.hierFrom = colMap.getMinhier(colMap.getSize() - 1);
                        column.hierTo = colMap.getMaxhier(colMap.getSize() - 1);
                        column.hierName = colMap.getColTitle(colMap.getSize() - 1);
                        SPDCInterpDataColumn column2 = singleChronoStratColumn ? column : new SPDCInterpDataColumn(this);
                        column2.dataType = column.dataType;
                        column2.igdType = column.igdType;
                        column2.dataTypeName = column.dataTypeName;
                        column2.schemeName = column.schemeName;
                        column2.hierFrom = colMap.getMinhier(colMap.getSize());
                        column2.hierTo = colMap.getMaxhier(colMap.getSize());
                        column2.hierName = colMap.getColTitle(colMap.getSize());
                        if (singleChronoStratColumn) continue;
                        columns.add(column2);
                        continue;
                    }
                    if (dType != 14) continue;
                    SPDCInterpDataColumn column2 = new SPDCInterpDataColumn(this);
                    column2.dataType = column.dataType;
                    column2.igdType = column.igdType;
                    column2.dataTypeName = "Confidence Rating";
                    column2.schemeName = null;
                    column2.hierFrom = 0;
                    column2.hierTo = 0;
                    column2.hierName = "";
                    columns.add(column2);
                }
            } else {
                SPDCInterpDataColumn column = new SPDCInterpDataColumn(this);
                column.dataType = dType;
                column.igdType = igdType;
                column.dataTypeName = IGDInterval.getIGDName(igdType);
                column.schemeName = "";
                column.schID = -1;
                column.hierTo = -1;
                column.hierFrom = -1;
                columns.add(column);
            }
            switch (igdType) {
                case 3: 
                case 4: {
                    List<IGDIntervalZone> zones = wellInterp.getIGDList(igdType);
                    for (IGDInterval iGDInterval : zones) {
                        if (igdType == 4 && !this.schemeWanted(selectedBzSchemes, iGDInterval.getSchID())) continue;
                        samples.add(iGDInterval.getTopSample());
                        samples.add(iGDInterval.getBaseSample());
                    }
                    continue block14;
                }
                case 21: {
                    List<SQPick> picks = wellInterp.getSQPicks();
                    for (Object pick : picks) {
                        samples.add(((SQPick)pick).getSample());
                    }
                    continue block14;
                }
                case 5: {
                    Object pick;
                    List<IGDIntervalEnv> list = wellInterp.getEnvs();
                    pick = list.iterator();
                    while (pick.hasNext()) {
                        IGDIntervalEnv env = pick.next();
                        samples.add(env.getTopSample());
                        samples.add(env.getBaseSample());
                    }
                    break;
                }
            }
        }
        for (SPDCInterpDataColumn column : columns) {
            sheet.appendFormatted(headerFormat, new Object[]{column.dataTypeName + (String)(column.hierFrom > 0 ? " - " + column.hierName : (column.schemeName != null ? ": " + column.schemeName : ""))});
        }
        for (Sample sample : samples) {
            sheet.addRowFormatted(rowFormat, new Object[0]);
            sheet.appendFormatted(rowFormat, new Object[]{well.getWellCode()});
            if (well.getHeader().getOcs() != null && !well.getHeader().getOcs().isEmpty()) {
                sheet.appendFormatted(rowFormat, new Object[]{well.getHeader().getOcs()});
            }
            sheet.appendFormatted(rowFormat, new Object[]{well.getWellName()});
            double depth = useCoreCorrections || useCuttingCorrections ? well.getDepth(sample, well.getWellUnits(), useCoreCorrections, useCuttingCorrections) : sample.getDepth(well.getWellUnits());
            depth = (double)Math.round(depth * 100.0) / 100.0;
            sheet.appendFormatted(rowFormat, new Object[]{depth});
            sheet.appendFormatted(rowFormat, new Object[]{sample.getTypeString()});
            for (SPDCInterpDataColumn sPDCInterpDataColumn : columns) {
                Object columnString = "";
                CellFormat intervalCellFormat = new CellFormat();
                intervalCellFormat.setAlignment(rowFormat.getAlignment()).setBorder(rowFormat.getBorder());
                wellInterp.getIGDList(sPDCInterpDataColumn.igdType);
                switch (sPDCInterpDataColumn.igdType) {
                    case 3: 
                    case 4: {
                        List<IGDIntervalZone> zones = sPDCInterpDataColumn.igdType == 3 ? wellInterp.getIGDList(sPDCInterpDataColumn.igdType, 0, sPDCInterpDataColumn.hierFrom, sPDCInterpDataColumn.hierTo) : wellInterp.getIGDList(sPDCInterpDataColumn.igdType, sPDCInterpDataColumn.schID);
                        for (IGDIntervalZone iGDIntervalZone : zones) {
                            if (sPDCInterpDataColumn.igdType == 4 && !this.schemeWanted(selectedBzSchemes, iGDIntervalZone.getSchID())) continue;
                            if (sample == iGDIntervalZone.getTopSample() && sample == iGDIntervalZone.getBaseSample()) {
                                if (!((String)columnString).isEmpty()) {
                                    columnString = (String)columnString + ", ";
                                }
                                columnString = (String)columnString + iGDIntervalZone.toString();
                                if (!useColours || iGDIntervalZone.getUnitColour(true) == Color.WHITE) continue;
                                intervalCellFormat.setFillColour(iGDIntervalZone.getUnitColour(true));
                                continue;
                            }
                            if (sample == iGDIntervalZone.getTopSample()) {
                                if (!((String)columnString).isEmpty()) {
                                    columnString = (String)columnString + ", ";
                                }
                                columnString = (String)columnString + iGDIntervalZone.toString() + " Top";
                                if (!useColours || iGDIntervalZone.getUnitColour(true) == Color.WHITE) continue;
                                intervalCellFormat.setFillColour(iGDIntervalZone.getUnitColour(true));
                                continue;
                            }
                            if (sample != iGDIntervalZone.getBaseSample()) continue;
                            if (!((String)columnString).isEmpty()) {
                                columnString = (String)columnString + ", ";
                            }
                            columnString = (String)columnString + iGDIntervalZone.toString() + " Base";
                            if (!useColours || iGDIntervalZone.getUnitColour(true) == Color.WHITE) continue;
                            intervalCellFormat.setFillColour(iGDIntervalZone.getUnitColour(true));
                        }
                        break;
                    }
                    case 21: {
                        List<SQPick> picks = wellInterp.getSQPicks();
                        block23: for (SQPick pick : picks) {
                            if (sample != pick.getSample()) continue;
                            if (!((String)columnString).isEmpty()) {
                                columnString = (String)columnString + ", ";
                            }
                            if (sPDCInterpDataColumn.dataTypeName.equalsIgnoreCase("Confidence Rating")) {
                                switch (pick.getBndInt()) {
                                    default: {
                                        columnString = (String)columnString + "Good";
                                        continue block23;
                                    }
                                    case 2: {
                                        columnString = (String)columnString + "Fair";
                                        continue block23;
                                    }
                                    case 1: 
                                }
                                columnString = (String)columnString + "Poor";
                                continue;
                            }
                            columnString = (String)columnString + pick.toString();
                        }
                        break;
                    }
                    case 5: {
                        List<IGDIntervalEnv> list = wellInterp.getEnvs();
                        for (IGDIntervalEnv env : list) {
                            if (sample == env.getTopSample() && sample == env.getBaseSample()) {
                                if (!((String)columnString).isEmpty()) {
                                    columnString = (String)columnString + ", ";
                                }
                                columnString = (String)columnString + env.toString();
                                if (!useColours) continue;
                                intervalCellFormat.setFillColour(env.getColour());
                                continue;
                            }
                            if (sample == env.getTopSample()) {
                                if (!((String)columnString).isEmpty()) {
                                    columnString = (String)columnString + ", ";
                                }
                                columnString = (String)columnString + env.toString() + " Top";
                                if (!useColours) continue;
                                intervalCellFormat.setFillColour(env.getColour());
                                continue;
                            }
                            if (sample != env.getBaseSample()) continue;
                            if (!((String)columnString).isEmpty()) {
                                columnString = (String)columnString + ", ";
                            }
                            columnString = (String)columnString + env.toString() + " Base";
                            if (!useColours) continue;
                            intervalCellFormat.setFillColour(env.getColour());
                        }
                        break;
                    }
                }
                sheet.appendFormatted(intervalCellFormat, new Object[]{columnString});
            }
        }
        return sheet;
    }

    private boolean schemeWanted(List<IGDScheme> selectedBzSchemes, int schemeID) {
        for (IGDScheme selectedScheme : selectedBzSchemes) {
            if (selectedScheme.getID() != schemeID) continue;
            return true;
        }
        return false;
    }

    private void appendSample(GridSheet b, SampleSummaryRecord s, boolean includeBoundary) {
        Double depth = null;
        Double uncorrectedDepth = null;
        String type = null;
        String boundary = null;
        if (s != null) {
            depth = s.getDepth();
            uncorrectedDepth = s.getUncorrectedDepth();
            type = s.getType();
            boundary = s.getBoundary();
        }
        b.appendFormatted(DEPTH_FORMAT, new Object[]{depth});
        if (this.includeUncorrectedDepths) {
            b.appendFormatted(DEPTH_FORMAT, new Object[]{uncorrectedDepth});
        }
        b.append(new Object[]{type});
        if (includeBoundary) {
            b.append(new Object[]{boundary});
        }
    }

    private void sortRecords(List<WellDataSummaryRecord> records) {
        Collections.sort(records, new Comparator<WellDataSummaryRecord>(this){
            {
                Objects.requireNonNull(this$0);
            }

            @Override
            public int compare(WellDataSummaryRecord o1, WellDataSummaryRecord o2) {
                int result = CompareUtils.compareToStringAsLower((String)o1.getWellName(), (String)o2.getWellName());
                if (result == 0) {
                    result = CompareUtils.compareToStringAsLower((String)o1.getVersionName(), (String)o2.getVersionName());
                }
                if (result == 0) {
                    result = CompareUtils.compareNullableDoubles((Double)o1.getTopDepth(), (Double)o2.getTopDepth());
                }
                if (result == 0) {
                    result = CompareUtils.compareNullableDoubles((Double)o1.getBaseDepth(), (Double)o2.getBaseDepth());
                }
                if (result == 0) {
                    result = Integer.compare(o1.getDataType(), o2.getDataType());
                }
                return result;
            }
        });
    }

    public boolean getUseCoreSampleCorrections() {
        return this.recordBuilder.getUseCoreSampleCorrections();
    }

    public void setUseCoreSampleCorrections(boolean value) {
        this.recordBuilder.setUseCoreSampleCorrections(value);
    }

    public boolean getUseCuttingSampleCorrections() {
        return this.recordBuilder.getUseCuttingSampleCorrections();
    }

    public void setUseCuttingSampleCorrections(boolean value) {
        this.recordBuilder.setUseCuttingSampleCorrections(value);
    }

    public void setIncludeUncorrectedDepths(boolean value) {
        this.includeUncorrectedDepths = value;
    }

    public boolean getIncludeUncorrectedDepths() {
        return this.includeUncorrectedDepths;
    }

    public void setIncludeWellCode(boolean value) {
        this.includeWellCode = value;
    }

    public boolean getIncludeWellCode() {
        return this.includeWellCode;
    }

    public void setIncludeVersionName(boolean value) {
        this.includeVersionName = value;
    }

    public boolean getIncludeVersionName() {
        return this.includeVersionName;
    }

    public void setDuplicateSingleDepths(boolean b) {
        this.recordBuilder.setDuplicateSingleDepths(b);
    }

    public boolean getDuplicateSingleDepths() {
        return this.recordBuilder.getDuplicateSingleDepths();
    }

    private String switchUnitTerm(String term) {
        term = term.replace("Late ", "L. ");
        term = term.replace("Middle ", "M. ");
        term = term.replace("Early ", "E.");
        return term;
    }

    private void writeBHPBoundary(GridSheet gb, int bndInt) throws SBException {
        switch (bndInt) {
            case 1: {
                gb.append(new Object[]{"Low"});
                gb.append(new Object[]{""});
                break;
            }
            case 2: {
                gb.append(new Object[]{"Medium"});
                gb.append(new Object[]{""});
                break;
            }
            case 3: {
                gb.append(new Object[]{"High"});
                gb.append(new Object[]{""});
                break;
            }
            case 4: {
                gb.append(new Object[]{""});
                gb.append(new Object[]{"Unconformity"});
                break;
            }
            case 5: {
                gb.append(new Object[]{""});
                gb.append(new Object[]{"?Unconformity"});
                break;
            }
            case 6: {
                gb.append(new Object[]{""});
                gb.append(new Object[]{"Fault"});
                break;
            }
            case 7: {
                gb.append(new Object[]{""});
                gb.append(new Object[]{"?Fault"});
                break;
            }
            case 8: {
                gb.append(new Object[]{""});
                gb.append(new Object[]{"ReverseFault"});
                break;
            }
            default: {
                throw new SBException("Unrecognised boundary type in writeBHPBoundary");
            }
        }
    }
}

