/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.list;

import com.stratadata.model3.well.SectionType;
import com.stratadata.util.depth.DepthUnits;
import com.stratadata.util.depth.DepthUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import jsbugs.uiutil.icon.IconFactory;
import model3.Well;
import util.SBException;

public class WellsListRenderer
extends JPanel
implements ListCellRenderer<Well> {
    private static final Border NO_FOCUS_BORDER = new EmptyBorder(1, 1, 1, 1);
    private static final int ICON_WIDTH = 10;
    private final JLabel label = new JLabel();
    private final JLabel altnameLabel = new JLabel();
    private final JLabel kickoffLabel = new JLabel();
    private final Component glue = Box.createHorizontalGlue();
    private final JLabel lockIcon = new JLabel(IconFactory.getLockedIcon());
    private final JLabel locationIcon = new JLabel(IconFactory.getPrefIcon("location"));
    private final JTextField colourField = new JTextField();
    private WellsListIcons icons = new WellsListIcons(true, true, true);

    public WellsListRenderer() {
        this.setOpaque(true);
        this.setLayout(new BoxLayout(this, 0));
        this.lockIcon.setAlignmentX(1.0f);
        this.altnameLabel.setFont(this.altnameLabel.getFont().deriveFont(2));
        this.altnameLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
        this.kickoffLabel.setForeground(Color.GRAY);
        this.kickoffLabel.setBorder(new EmptyBorder(0, 4, 0, 4));
        Dimension d = new Dimension(10, 10);
        this.colourField.setMaximumSize(d);
        this.colourField.setMinimumSize(d);
        this.colourField.setPreferredSize(d);
    }

    public void setIcons(WellsListIcons icons) {
        this.icons = icons;
    }

    @Override
    public Component getListCellRendererComponent(JList<? extends Well> list, Well value, int index, boolean isSelected, boolean cellHasFocus) {
        this.removeAll();
        this.add(this.label);
        String altname = value.getHeader().getWellAltName();
        if (altname != null && !altname.isBlank()) {
            this.altnameLabel.setText(altname);
            this.add(this.altnameLabel);
        }
        int parentID = value.getHeader().getParentWellID();
        String FIRST_SIDETRACK = "\u251c";
        String LAST_SIDETRACK = "\u2514";
        String ORPHANED_SIDETRACK = "\u2500";
        Object sidetrackPrefix = "";
        if (parentID > 0) {
            sidetrackPrefix = "\u2500";
            sidetrackPrefix = (String)sidetrackPrefix + " ";
            this.kickoffLabel.setText(" (KO: " + DepthUtils.depthString((double)value.getHeader().getKickoValue(), (DepthUnits)value.getHeader().getDepthUnits(), (int)2, (SectionType)value.getHeader().getSectionType()) + ")");
            this.add(this.kickoffLabel);
        }
        this.label.setText((String)sidetrackPrefix + String.valueOf(value));
        this.add(this.glue);
        if (this.icons.lock) {
            try {
                if (value.isReadOnly(true)) {
                    this.add(this.lockIcon);
                } else {
                    this.add(Box.createHorizontalStrut(10));
                }
            }
            catch (SBException e) {
                throw new RuntimeException(e);
            }
        }
        if (this.icons.location) {
            if (value.getHeader().hasLocation()) {
                this.add(this.locationIcon);
            } else {
                this.add(Box.createHorizontalStrut(10));
            }
        }
        if (this.icons.colour) {
            this.add(Box.createHorizontalStrut(2));
            Color wellColour = value.getHeader().getColour();
            if (!Color.BLACK.equals(wellColour)) {
                this.colourField.setBackground(wellColour);
                this.add(this.colourField);
            } else {
                this.add(Box.createHorizontalStrut(10));
            }
        }
        this.label.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        this.altnameLabel.setForeground(isSelected ? list.getSelectionForeground() : list.getForeground());
        Color background = list.getBackground();
        if (value.isRestricted()) {
            background = Color.pink;
        }
        this.setBackground(isSelected ? list.getSelectionBackground() : background);
        Border border = null;
        if (cellHasFocus) {
            if (isSelected) {
                border = UIManager.getBorder("List.focusSelectedCellHighlightBorder");
            }
            if (border == null) {
                border = UIManager.getBorder("List.focusCellHighlightBorder");
            }
        } else {
            border = UIManager.getBorder("List.cellNoFocusBorder");
        }
        this.setBorder(border);
        return this;
    }

    public record WellsListIcons(boolean lock, boolean location, boolean colour) {
    }
}

