/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.event;

import com.stratadata.model3.event.EventType;
import com.stratadata.model3.scheme.Confidence;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.UIManager;
import jsbugs.DialogSelectEvent;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CompositeStandard;
import model3.CompositeStandardEvent;
import model3.SBdb;
import org.jdesktop.layout.GroupLayout;
import util.InvalidFieldException;
import util.SB;
import util.SBException;
import util.SBPermissionException;
import util.exception.StackError;

public class DialogCmpStdEvent
extends SBDialog {
    private static final int NAMELEN = 100;
    private static final int CSULEN = 6;
    private static final int COMMENTSLEN = 1000;
    private final SBdb db;
    private final CompositeStandard cmpStd;
    final CompositeStandardEvent cmpStdEvent;
    final CompositeStandardEvent.Builder builder;
    private final DefaultComboBoxModel confModel = new DefaultComboBoxModel<Confidence>(Confidence.values());
    private ButtonGroup buttonGroupType;
    private JButton jButtonCancel;
    private JButton jButtonEvent;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JComboBox jComboBoxConfidence;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabelCSUAge;
    private JPanel jPanel1;
    private JRadioButton jRadioButtonBase;
    private JRadioButton jRadioButtonSingle;
    private JRadioButton jRadioButtonTop;
    private JScrollPane jScrollPane1;
    private JTextArea jTextAreaComment;
    private JTextField jTextFieldCSU;
    private JTextField jTextFieldEventName;

    public DialogCmpStdEvent(JDialog parent, boolean modal, SBdb db, CompositeStandardEvent.Builder builder, boolean isAgeScale) {
        super((Window)parent, modal);
        this.db = db;
        this.cmpStd = null;
        this.cmpStdEvent = null;
        if (builder == null) {
            this.setTitle("Event : Add");
            this.builder = new CompositeStandardEvent.Builder();
        } else {
            this.setTitle("Event : Edit");
            this.builder = builder;
        }
        this.initComponents();
        this.init(isAgeScale);
        if (this.builder.inheritedFromParent) {
            this.jButtonEvent.setEnabled(false);
            this.jRadioButtonBase.setEnabled(false);
            this.jRadioButtonTop.setEnabled(false);
            this.jRadioButtonSingle.setEnabled(false);
        }
    }

    public DialogCmpStdEvent(JFrame parent, boolean modal, SBdb db, CompositeStandard cmpStd, CompositeStandardEvent event, CompositeStandardEvent.Builder builder) throws SQLException {
        super((Frame)parent, modal);
        if (cmpStd == null) {
            throw new IllegalArgumentException("Composite is null");
        }
        this.db = db;
        this.cmpStd = cmpStd;
        this.cmpStdEvent = event;
        if (builder != null) {
            assert (event == null);
            this.builder = builder;
            this.setTitle("Event : Add");
        } else if (event != null) {
            this.builder = CompositeStandardEvent.Builder.copyOf(event);
            this.builder.event(event.getEvent());
            this.setTitle("Event : Edit");
        } else {
            this.builder = new CompositeStandardEvent.Builder();
            this.setTitle("Event : Add");
        }
        this.initComponents();
        this.init(cmpStd.isAgeScale());
        if (!cmpStd.canWrite(db, null)) {
            this.jButtonOK.setEnabled(false);
            this.jButtonOK.setToolTipText(cmpStd.getDeniedReason(db, "composite standard", false));
        }
    }

    private void init(boolean isAgeScale) {
        if (this.builder.getEvent() != null) {
            this.jTextFieldEventName.setText(this.builder.getEvent().toString(true, false, false, false));
            this.setEventType();
        }
        if (this.builder.getType() != null) {
            switch (this.builder.getType()) {
                case TOP: {
                    this.jRadioButtonTop.setSelected(true);
                    break;
                }
                case BASE: {
                    this.jRadioButtonBase.setSelected(true);
                    break;
                }
                case SINGLE: {
                    this.jRadioButtonSingle.setSelected(true);
                    break;
                }
                default: {
                    assert (false);
                    break;
                }
            }
        }
        if (!this.getTitle().contains("Add") || this.builder.getCSU() > 0.0) {
            this.jTextFieldCSU.setText("" + this.builder.getCSU());
        }
        this.jComboBoxConfidence.setSelectedItem(this.builder.getConfidence());
        if (this.cmpStdEvent != null) {
            this.jRadioButtonBase.setEnabled(false);
            this.jRadioButtonSingle.setEnabled(false);
            this.jRadioButtonTop.setEnabled(false);
            this.jButtonEvent.setEnabled(false);
        }
        this.jTextAreaComment.setText(this.builder.getComments());
        this.jRadioButtonTop.setText(CompositeStandardEvent.getEvTypeString(EventType.TOP));
        this.jRadioButtonBase.setText(CompositeStandardEvent.getEvTypeString(EventType.BASE));
        if (isAgeScale) {
            this.jLabelCSUAge.setText("Age:");
        } else {
            this.jLabelCSUAge.setText("CSU:");
        }
        try {
            if (this.cmpStd != null && this.db.isConnected() && !this.cmpStd.canWrite(this.db, null)) {
                this.jButtonOK.setEnabled(false);
                this.jButtonOK.setToolTipText("This is a read-only Composite Standard");
            } else {
                this.getRootPane().setDefaultButton(this.jButtonOK);
            }
        }
        catch (SQLException sqle) {
            sqle.printStackTrace();
        }
    }

    private void setEventType() {
        this.jRadioButtonTop.setEnabled(this.builder.getEvent().hasEvType(EventType.TOP));
        this.jRadioButtonBase.setEnabled(this.builder.getEvent().hasEvType(EventType.BASE));
        this.jRadioButtonSingle.setEnabled(this.builder.getEvent().hasEvType(EventType.SINGLE));
    }

    private void initComponents() {
        this.buttonGroupType = new ButtonGroup();
        this.jButtonEvent = new JButton();
        this.jTextFieldCSU = new JTextField();
        this.jTextFieldEventName = new JTextField();
        this.jLabelCSUAge = new JLabel();
        this.jLabel2 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jRadioButtonTop = new JRadioButton();
        this.jRadioButtonBase = new JRadioButton();
        this.jRadioButtonSingle = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonHelp = new JButton();
        this.jButtonOK = new JButton();
        this.jLabel1 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.jTextAreaComment = new JTextArea();
        this.jLabel3 = new JLabel();
        this.jComboBoxConfidence = new JComboBox();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jButtonEvent.setText("...");
        this.jButtonEvent.setToolTipText("Choose name from Event Dictionary");
        this.jButtonEvent.putClientProperty("JComponent.sizeVariant", "small");
        this.jButtonEvent.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonEventActionPerformed(evt);
            }
        });
        this.jTextFieldCSU.addFocusListener(new FocusAdapter(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void focusGained(FocusEvent evt) {
                this.this$0.jTextFieldCSUFocusGained(evt);
            }
        });
        this.jTextFieldCSU.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldCSUKeyTyped(evt);
            }
        });
        this.jTextFieldEventName.setEditable(false);
        this.jTextFieldEventName.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldEventNameKeyTyped(evt);
            }
        });
        this.jLabelCSUAge.setText("CSU/Age:");
        this.jLabel2.setText("Event name:");
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(null, "Event Type", 0, 0, UIManager.getFont("TitledBorder.font"), UIManager.getColor("TitledBorder.titleColor")));
        this.buttonGroupType.add(this.jRadioButtonTop);
        this.jRadioButtonTop.setText("Top event");
        this.jRadioButtonTop.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonTop.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonBase);
        this.jRadioButtonBase.setText("Base event");
        this.jRadioButtonBase.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonBase.setMargin(new Insets(0, 0, 0, 0));
        this.buttonGroupType.add(this.jRadioButtonSingle);
        this.jRadioButtonSingle.setText("Single event");
        this.jRadioButtonSingle.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.jRadioButtonSingle.setMargin(new Insets(0, 0, 0, 0));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jRadioButtonTop).addPreferredGap(1).add((Component)this.jRadioButtonBase).addPreferredGap(1).add((Component)this.jRadioButtonSingle).addContainerGap(123, Short.MAX_VALUE)));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap(-1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jRadioButtonTop).add((Component)this.jRadioButtonBase).add((Component)this.jRadioButtonSingle)).addContainerGap()));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Comment / reference:");
        this.jTextAreaComment.setColumns(20);
        this.jTextAreaComment.setFont(this.jTextAreaComment.getFont());
        this.jTextAreaComment.setLineWrap(true);
        this.jTextAreaComment.setRows(3);
        this.jTextAreaComment.setWrapStyleWord(true);
        this.jTextAreaComment.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogCmpStdEvent this$0;
            {
                DialogCmpStdEvent dialogCmpStdEvent = this$0;
                Objects.requireNonNull(dialogCmpStdEvent);
                this.this$0 = dialogCmpStdEvent;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextAreaCommentKeyTyped(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTextAreaComment);
        this.jLabel3.setText("Confidence:");
        this.jComboBoxConfidence.setModel(this.confModel);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel2).add((Component)this.jLabelCSUAge)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jTextFieldCSU, -2, 84, -2).add(18, 18, 18).add((Component)this.jLabel3).addPreferredGap(0).add((Component)this.jComboBoxConfidence, 0, -1, Short.MAX_VALUE)).add((Component)this.jTextFieldEventName, -1, 281, Short.MAX_VALUE)).addPreferredGap(0).add((Component)this.jButtonEvent, -2, 28, -2)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).add(0, 0, Short.MAX_VALUE)).add((Component)this.jScrollPane1)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabelCSUAge).add((Component)this.jTextFieldCSU, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.jComboBoxConfidence, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jButtonEvent).add((Component)this.jTextFieldEventName, -2, -1, -2)).addPreferredGap(1).add((Component)this.jPanel1, -2, -1, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jScrollPane1, -2, 63, -2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonHelp).add((Component)this.jButtonOK)).addContainerGap(-1, Short.MAX_VALUE)));
        this.pack();
    }

    private void jButtonEventActionPerformed(ActionEvent evt) {
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            DialogSelectEvent dialog = new DialogSelectEvent((JDialog)((Object)this), true, this.db, this.builder.getEvent(), null, false);
            dialog.setLocationRelativeTo((Component)((Object)this));
            this.setCursor(Cursor.getDefaultCursor());
            dialog.setVisible(true);
            if (dialog.getSelectedItem() != null) {
                this.builder.event(dialog.getSelectedItem());
                this.jTextFieldEventName.setText(this.builder.getEvent().toString(true, false, false, false));
                this.setEventType();
            }
        }
        catch (RuntimeException | SQLException | SBException e) {
            SbugsExceptionHandler.showStackError(e);
        }
        finally {
            this.setCursor(Cursor.getDefaultCursor());
        }
    }

    private void jTextFieldCSUFocusGained(FocusEvent evt) {
        this.jTextFieldCSU.setSelectionStart(0);
        this.jTextFieldCSU.setSelectionEnd(this.jTextFieldCSU.getText().length());
    }

    private void jTextFieldCSUKeyTyped(KeyEvent evt) {
        if (SB.floatFieldVal((JTextField)this.jTextFieldCSU, (int)6, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jTextFieldEventNameKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextField)this.jTextFieldEventName, (int)100, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        if (this.buttonGroupType.getSelection() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an event type", this.getTitle(), 0);
            return;
        }
        if (this.builder.getEvent() == null) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Select an event", this.getTitle(), 0);
            return;
        }
        if (this.jTextFieldCSU.getText().trim().isEmpty()) {
            JOptionPane.showMessageDialog((Component)((Object)this), "Enter a value for Age/CSU", this.getTitle(), 0);
            return;
        }
        EventType type = this.jRadioButtonTop.isSelected() ? EventType.TOP : (this.jRadioButtonBase.isSelected() ? EventType.BASE : EventType.SINGLE);
        this.builder.type(type);
        this.builder.csu(Double.parseDouble(this.jTextFieldCSU.getText()));
        this.builder.confidence((Confidence)this.jComboBoxConfidence.getSelectedItem());
        this.builder.comment(this.jTextAreaComment.getText());
        if (this.cmpStd == null) {
            this.builder.inheritedFromParent = false;
            this.setOK();
        } else {
            if (this.cmpStd.hasEvent(this.builder, this.cmpStdEvent)) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Event already exists in composite standard", this.getTitle(), 0);
                return;
            }
            if (!this.cmpStd.checkCSU(this.builder)) {
                String msg = type == EventType.TOP ? "Top event cannot be older than existing base event" : "Base event cannot be younger than existing top event";
                JOptionPane.showMessageDialog((Component)((Object)this), msg, this.getTitle(), 2);
                return;
            }
            try {
                if (this.cmpStdEvent != null) {
                    this.cmpStd.updateCsu(this.cmpStdEvent, this.builder.getCSU(), this.builder.getErrPlus(), this.builder.getErrMinus(), this.builder.getConfidence());
                    this.cmpStd.updateEventComment(this.cmpStdEvent, this.builder.getComments());
                } else {
                    this.cmpStd.addEvent(this.builder);
                }
                this.db.commit();
                this.cmpStd.notifyObservers();
                this.setOK();
            }
            catch (InvalidFieldException | SBException | SBPermissionException pe) {
                JOptionPane.showMessageDialog((Component)((Object)this), pe.getMessage(), this.getTitle(), 2);
            }
            catch (SQLException sql) {
                this.db.doRollback();
                FrameJsbugs.showStackError("SQL Error", sql, this.db);
            }
            catch (RuntimeException re) {
                StackError.showStackError((String)"", (Throwable)re);
            }
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        FrameJsbugs.openHelp("dialogeventcomposite.html");
    }

    private void jTextAreaCommentKeyTyped(KeyEvent evt) {
        if (SB.lenField((JTextArea)this.jTextAreaComment, (int)1000, (KeyEvent)evt)) {
            this.getToolkit().beep();
        }
    }
}

