/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.model3.well.SectionType;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileFilter;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.FrameJsbugs;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.IGDUnitBase;
import model3.Lastval;
import model3.LithostratUnit;
import model3.SBdb;
import model3.Sample;
import model3.Well;
import model3.project.Project;
import org.jdesktop.layout.GroupLayout;
import util.SB;
import util.SBException;
import util.SbugsFileFilter;
import util.exception.StackError;

public class DialogUnitUsage
extends JDialog {
    static String[] titles = new String[]{"Well Name", "Version", "Top Sample", "Base Sample", "Interval"};
    static final int COL_WELL = 0;
    static final int COL_VERSION = 1;
    static final int COL_TOP = 2;
    static final int COL_BASE = 3;
    static final int COL_INTERVAL = 4;
    static int[] widths = new int[]{30, 30, 30, 30, 60};
    private final IGDUnitBase unit;
    private final DefaultComboBoxModel projectModel = new DefaultComboBoxModel();
    private final TableModelUnitUsage model = new TableModelUnitUsage(this);
    private final SBdb sbdb;
    private static final String ALL_PROJECTS = "<All Projects>";
    private LinkedList<UnitUse> usageMaster;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonSaveAs;
    private JComboBox jComboBoxProject;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton jRadioButtonF;
    private JRadioButton jRadioButtonM;
    private JScrollPane jScrollPane1;
    private JTable jTableUsage;

    public DialogUnitUsage(JDialog parent, boolean modal, IGDUnitBase unit, SBdb sbdb) {
        super((Dialog)parent, modal);
        this.unit = unit;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    public DialogUnitUsage(Frame parent, boolean modal, IGDUnitBase unit, SBdb sbdb) {
        super(parent, modal);
        this.unit = unit;
        this.sbdb = sbdb;
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle(this.unit.toString());
        this.fillProjectCombo();
        this.model.setUpTable(this.jTableUsage);
        this.usageMaster = this.queryUsage();
        this.model.usages = this.usageMaster;
        this.setModelUnits();
    }

    private LinkedList<UnitUse> queryUsage() {
        String sql = "SELECT DISTINCT w.well_id,w.well_name,w.well_code,ip.descrip, i.top_id,i.base_id, i.q_uzone, i.upp_inf, i.q_lzone, i.low_inf, i.sep FROM " + this.sbdb.DBTableName(this.unit instanceof LithostratUnit ? "IGD_LSTRAT" : "IGD") + " i," + this.sbdb.DBTableName("INTERP") + " ip," + this.sbdb.DBTableName("WELLS") + " w WHERE (i.upp_zone=" + this.unit.getUnitID() + " OR i.low_zone=" + this.unit.getUnitID() + ") AND i.well_id=w.well_id AND ip.interp_id=i.interp_id ORDER BY well_name, ip.descrip";
        LinkedList<UnitUse> usages = new LinkedList<UnitUse>();
        try {
            Statement stmt = this.sbdb.getDatabase().createStatement();
            ResultSet rs = stmt.executeQuery(this.sbdb.modQuery(sql));
            while (rs.next()) {
                UnitUse use = new UnitUse();
                use.wellID = rs.getInt("well_id");
                use.wellName = rs.getString("well_name");
                use.wellCode = rs.getString("well_code");
                use.version = rs.getString("descrip");
                use.topSample = Sample.load(this.sbdb, use.wellID, rs.getInt("top_id"), SectionType.WELL, null);
                use.baseSample = Sample.load(this.sbdb, use.wellID, rs.getInt("base_id"), SectionType.WELL, null);
                String s = rs.getString("q_uzone");
                use.intervalName = "";
                if (s != null && s.equalsIgnoreCase("Y")) {
                    use.intervalName = "?";
                }
                use.intervalName = use.intervalName + rs.getString("upp_inf");
                String lowInf = rs.getString("low_inf");
                if (lowInf != null && !lowInf.isEmpty()) {
                    String sep = rs.getString("sep");
                    if (sep == null || !sep.isEmpty()) {
                        sep = "-";
                    }
                    use.intervalName = use.intervalName + " " + sep + " ";
                    s = rs.getString("q_lzone");
                    if (s != null && s.equalsIgnoreCase("Y")) {
                        use.intervalName = "?";
                    }
                    use.intervalName = use.intervalName + lowInf;
                }
                usages.add(use);
            }
        }
        catch (SQLException | SBException ex) {
            StackError.showStackError((String)"Error getting unit usage", (Throwable)ex);
        }
        return usages;
    }

    private void fillProjectCombo() {
        this.projectModel.removeAllElements();
        this.projectModel.addElement(ALL_PROJECTS);
        try {
            this.sbdb.loadProjectCombo(this.projectModel, false);
        }
        catch (Exception e) {
            StackError.showStackError((String)"Error loading projects", (Throwable)e);
        }
        this.projectModel.setSelectedItem(ALL_PROJECTS);
    }

    private void setModelUnits() {
        this.model.units = (char)(this.jRadioButtonM.isSelected() ? 77 : 70);
        this.model.fireTableDataChanged();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jScrollPane1 = new JScrollPane();
        this.jTableUsage = new JTable();
        this.jButtonCancel = new JButton();
        this.jButtonSaveAs = new JButton();
        this.jLabel2 = new JLabel();
        this.jComboBoxProject = new JComboBox();
        this.jLabel1 = new JLabel();
        this.jRadioButtonM = new JRadioButton();
        this.jRadioButtonF = new JRadioButton();
        this.setDefaultCloseOperation(2);
        this.setMinimumSize(new Dimension(350, 350));
        this.setModal(true);
        this.jTableUsage.setModel(this.model);
        this.jScrollPane1.setViewportView(this.jTableUsage);
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnitUsage this$0;
            {
                DialogUnitUsage dialogUnitUsage = this$0;
                Objects.requireNonNull(dialogUnitUsage);
                this.this$0 = dialogUnitUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonSaveAs.setText("Save as...");
        this.jButtonSaveAs.setToolTipText("Save the current list as a text file");
        this.jButtonSaveAs.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnitUsage this$0;
            {
                DialogUnitUsage dialogUnitUsage = this$0;
                Objects.requireNonNull(dialogUnitUsage);
                this.this$0 = dialogUnitUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonSaveAsActionPerformed(evt);
            }
        });
        this.jLabel2.setText("Project:");
        this.jComboBoxProject.setMaximumRowCount(30);
        this.jComboBoxProject.setModel(this.projectModel);
        this.jComboBoxProject.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnitUsage this$0;
            {
                DialogUnitUsage dialogUnitUsage = this$0;
                Objects.requireNonNull(dialogUnitUsage);
                this.this$0 = dialogUnitUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxProjectActionPerformed(evt);
            }
        });
        this.jLabel1.setText("Units:");
        this.buttonGroup1.add(this.jRadioButtonM);
        this.jRadioButtonM.setSelected(true);
        this.jRadioButtonM.setText("Metres");
        this.jRadioButtonM.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnitUsage this$0;
            {
                DialogUnitUsage dialogUnitUsage = this$0;
                Objects.requireNonNull(dialogUnitUsage);
                this.this$0 = dialogUnitUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonF);
        this.jRadioButtonF.setText("Feet");
        this.jRadioButtonF.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogUnitUsage this$0;
            {
                DialogUnitUsage dialogUnitUsage = this$0;
                Objects.requireNonNull(dialogUnitUsage);
                this.this$0 = dialogUnitUsage;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonFActionPerformed(evt);
            }
        });
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(0).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jRadioButtonM).addPreferredGap(0).add((Component)this.jRadioButtonF).add(0, 192, Short.MAX_VALUE)).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jComboBoxProject, 0, -1, Short.MAX_VALUE).addContainerGap()))).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().add(0, 0, Short.MAX_VALUE).add((Component)this.jButtonSaveAs).addPreferredGap(0).add((Component)this.jButtonCancel)).add(2, (Component)this.jScrollPane1, -2, 0, Short.MAX_VALUE)).addContainerGap()))));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonSaveAs}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jComboBoxProject, -2, -1, -2).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jRadioButtonM).add((Component)this.jRadioButtonF)).add(19, 19, 19).add((Component)this.jScrollPane1, -1, 225, Short.MAX_VALUE).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonSaveAs)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jRadioButtonMActionPerformed(ActionEvent evt) {
        this.setModelUnits();
    }

    private void jRadioButtonFActionPerformed(ActionEvent evt) {
        this.setModelUnits();
    }

    private void jComboBoxProjectActionPerformed(ActionEvent evt) {
        this.filterList();
    }

    private void jButtonSaveAsActionPerformed(ActionEvent evt) {
        File setDir = null;
        try {
            setDir = new File(Lastval.getString(this.sbdb, "JLISTFILE"));
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        JFileChooser jFileChooser1 = new JFileChooser();
        jFileChooser1.setCurrentDirectory(setDir);
        SbugsFileFilter filter = new SbugsFileFilter();
        filter.addExtension("txt");
        filter.setDescription("Text files");
        jFileChooser1.addChoosableFileFilter((FileFilter)filter);
        SimpleDateFormat df = new SimpleDateFormat("dd-MMM-yyyy");
        Date date = new Date();
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (0 == jFileChooser1.showSaveDialog(this)) {
            try {
                Object fileName = jFileChooser1.getSelectedFile().getPath();
                if (!((String)fileName).toLowerCase().endsWith(".txt")) {
                    fileName = (String)fileName + ".txt";
                }
                try (FileWriter out = new FileWriter((String)fileName);){
                    String eol = "\r\n";
                    out.write("StrataBugs output: " + df.format(date) + eol);
                    out.write(this.getTitle() + eol + eol);
                    for (int i = 0; i < this.model.getRowCount(); ++i) {
                        for (int j = 0; j < this.model.getColumnCount(); ++j) {
                            String text = this.model.getValueAt(i, j).toString();
                            out.write(text + "\t");
                        }
                        out.write(eol);
                    }
                }
                if (JOptionPane.showConfirmDialog(this, "File '" + (String)fileName + "' written", "File Saved", 2) == 0) {
                    Lastval.putString(this.sbdb, "JLISTFILE", (String)fileName);
                    this.sbdb.commit();
                }
            }
            catch (IOException | SQLException ex) {
                SbugsExceptionHandler.showStackError(ex, this);
            }
        }
        this.setCursor(Cursor.getDefaultCursor());
    }

    private void filterList() {
        if (this.jComboBoxProject.getSelectedItem() instanceof Project) {
            LinkedList<UnitUse> filtered = new LinkedList<UnitUse>();
            Project project = (Project)((Object)this.jComboBoxProject.getSelectedItem());
            HashSet<Integer> wellIDs = new HashSet<Integer>();
            try {
                Iterator<Well> it = this.sbdb.getWellIterator(project.getID());
                while (it.hasNext()) {
                    Well well = it.next();
                    wellIDs.add(well.getWellID());
                }
            }
            catch (SQLException sql) {
                FrameJsbugs.showStackError("SQL Error loading projects", sql, this.sbdb);
            }
            catch (SBException sbe) {
                StackError.showStackError((String)"Error", (Throwable)sbe);
            }
            for (UnitUse use : this.usageMaster) {
                if (!wellIDs.contains(use.wellID)) continue;
                filtered.add(use);
            }
            this.model.usages = filtered;
        } else {
            this.model.usages = this.usageMaster;
        }
        this.model.fireTableDataChanged();
    }

    private class TableModelUnitUsage
    extends AbstractTableModel {
        LinkedList<UnitUse> usages;
        char units;
        final /* synthetic */ DialogUnitUsage this$0;

        private TableModelUnitUsage(DialogUnitUsage dialogUnitUsage) {
            DialogUnitUsage dialogUnitUsage2 = dialogUnitUsage;
            Objects.requireNonNull(dialogUnitUsage2);
            this.this$0 = dialogUnitUsage2;
            this.units = (char)77;
        }

        @Override
        public int getRowCount() {
            if (this.usages == null) {
                return 0;
            }
            return this.usages.size();
        }

        @Override
        public int getColumnCount() {
            return titles.length;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            UnitUse use = this.usages.get(rowIndex);
            if (use == null) {
                return null;
            }
            switch (columnIndex) {
                case 0: {
                    return use.wellName;
                }
                case 1: {
                    return use.version;
                }
                case 2: {
                    return use.topSample.toString(this.units, true, false);
                }
                case 3: {
                    return use.baseSample.toString(this.units, true, false);
                }
                case 4: {
                    return use.intervalName;
                }
            }
            return null;
        }

        void setUpTable(JTable table) {
            SB.setTableHeaderBold((JTable)table);
            TableColumnModel columnModel = table.getTableHeader().getColumnModel();
            for (int i = 0; i < this.getColumnCount(); ++i) {
                columnModel.getColumn(i).setHeaderValue(titles[i]);
                columnModel.getColumn(i).setWidth(widths[i]);
            }
            table.getTableHeader().setReorderingAllowed(false);
        }
    }

    private static class UnitUse {
        String wellName;
        String wellCode;
        String version;
        int wellID;
        Sample topSample;
        Sample baseSample;
        String intervalName;

        private UnitUse() {
        }
    }
}

