/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.model3.Discipline;
import java.sql.SQLException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import jsbchart.core.ChartManager;
import jsbugs.userconnect.SbugsSession;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.SBdb;
import model3.Surface;
import org.apache.commons.lang3.StringUtils;
import util.InvalidFieldException;
import util.SBException;
import util.process.ModelProcess;
import util.process.ProcessMessage;
import util.process.SbugsProcess;
import util.process.SbugsProcessStep;

public class IGDSchemeUpdate
extends SbugsProcess<IGDSchemeUpdateStep> {
    private final int igdType;
    private final IGDScheme scheme;
    private final SBdb sbdb;
    private final ChartManager chartManager;
    private String schemeName;
    private Discipline disc;
    private IGDScheme.SequenceType sqType;
    private IGDScheme parentScheme;
    private int parentID;
    private boolean archive;
    private List<IGDUnitBase.Builder> units;
    private List<Surface.Builder> surfaces;
    private final List<IGDUnitBase> deletedUnits = new LinkedList<IGDUnitBase>();
    private final List<Surface> deletedSurfaces = new LinkedList<Surface>();
    private List<IGDScheme.UnlinkedInterval> unlinkedIntervals;
    private int nUnlinkedIntervalOccurrences;
    private IGDScheme schemeAdded;

    public IGDSchemeUpdate(int igdType, IGDScheme scheme) {
        this.igdType = igdType;
        this.scheme = scheme;
        this.sbdb = SbugsSession.getDb();
        this.chartManager = SbugsSession.getSession().getChartManager();
    }

    public void setDetails(String schemeName, IGDScheme parentScheme, Discipline disc, IGDScheme.SequenceType sqType, List<IGDUnitBase.Builder> units, List<Surface.Builder> surfaces, boolean archive) {
        this.schemeName = StringUtils.trimToNull((String)schemeName);
        this.parentScheme = parentScheme;
        this.disc = disc;
        this.sqType = sqType;
        this.units = units;
        this.surfaces = surfaces;
        this.archive = archive;
    }

    protected boolean validate() throws InvalidFieldException, SQLException, SBException {
        IGDScheme existingScheme;
        if (this.schemeName == null) {
            throw new InvalidFieldException("You must choose a scheme name.");
        }
        if (this.igdType == 4 && this.disc == null) {
            throw new InvalidFieldException("You must select a discipline.");
        }
        if (this.igdType == 10 && this.sqType == null) {
            throw new InvalidFieldException("You must select a sequence scheme type.");
        }
        if (this.parentScheme == null && this.igdType != 3 && this.igdType != 2) {
            throw new InvalidFieldException("You must link to a chronostratigraphy scheme.");
        }
        this.parentID = this.parentScheme != null ? this.parentScheme.getID() : 0;
        IGDScheme.checkSchemeUnits(this.units);
        if (this.scheme != null) {
            this.scheme.checkChildSchemes(this.units);
        }
        if (this.igdType == 10) {
            IGDScheme.checkSchemeSurfaces(this.surfaces);
        }
        if ((existingScheme = this.sbdb.getIGDScheme(this.schemeName, this.igdType)) != null && existingScheme != this.scheme) {
            throw new InvalidFieldException("A Scheme of this name already exists in database.");
        }
        return true;
    }

    protected void process() throws SQLException, SBException {
        boolean completed;
        if (this.scheme == null) {
            this.addNewScheme();
            completed = true;
        } else if (this.scheme.getDatabase().isConnected()) {
            completed = this.updateExistingScheme();
        } else {
            this.copyWorkspaceSchemeToDatabase();
            completed = true;
        }
        if (!completed) {
            return;
        }
        this.sbdb.commit();
        if (this.scheme != null) {
            this.scheme.notifyObservers();
        }
        if (this.schemeAdded != null) {
            this.sbdb.addIGDScheme(this.schemeAdded);
        }
    }

    protected void postProcess() throws SQLException, SBException {
        if (this.scheme != null && this.scheme.getDatabase().isConnected()) {
            boolean completed = this.linkInformalTerms();
            if (!completed) {
                return;
            }
            if (this.archive != this.scheme.isArchived()) {
                this.scheme.setArchived(this.archive);
            }
            this.sbdb.commit();
        }
        super.postProcess();
    }

    private void addNewScheme() throws SQLException, SBException {
        this.schemeAdded = new IGDScheme(this.sbdb, this.igdType, this.schemeName, "", this.disc, this.sqType, this.parentID);
        this.schemeAdded.storeDetails();
        if (!this.units.isEmpty() || !this.surfaces.isEmpty()) {
            this.schemeAdded.update(this.units, this.surfaces, this.schemeName, "", this.disc, this.sqType, this.parentID);
        }
    }

    private boolean updateExistingScheme() throws SQLException, SBException {
        if (!this.hasResponse(IGDSchemeUpdateStep.UNLINK_DELETED_INTERVALS)) {
            if (!this.scheme.checkDeletedUnits(this.units)) {
                String msg = "Deleted units are linked to intervals in wells.\nDo you want to continue, and unlink these intervals?";
                this.addProcessMessage(msg, "Deleted Units", IGDSchemeUpdateStep.UNLINK_DELETED_INTERVALS);
                return false;
            }
        } else if (this.getResponse(IGDSchemeUpdateStep.UNLINK_DELETED_INTERVALS) != ProcessMessage.Response.YES) {
            throw new IllegalStateException("Avoiding scheme update");
        }
        if (!this.hasResponse(IGDSchemeUpdateStep.DELETE_CORRLINES)) {
            boolean deleted;
            for (IGDUnitBase existingUnit : this.scheme.getUnitBases()) {
                deleted = true;
                for (IGDUnitBase.Builder builder : this.units) {
                    if (builder.getOriginalID() != existingUnit.getUnitID()) continue;
                    deleted = false;
                    break;
                }
                if (!deleted) continue;
                this.deletedUnits.add(existingUnit);
            }
            if (this.scheme.getIGDType() == 10) {
                for (Surface existingSurface : this.scheme.getSurfaces()) {
                    deleted = true;
                    for (Surface.Builder builder : this.surfaces) {
                        if (builder.getOriginalID() != existingSurface.getSurfaceID()) continue;
                        deleted = false;
                        break;
                    }
                    if (!deleted) continue;
                    this.deletedSurfaces.add(existingSurface);
                }
            }
            if (!this.deletedUnits.isEmpty() || !this.deletedSurfaces.isEmpty()) {
                LinkedList<ChartManager.ChartOcc> chartOccs = new LinkedList<ChartManager.ChartOcc>();
                if (!this.deletedUnits.isEmpty()) {
                    chartOccs.addAll(this.chartManager.getIGDUnitUsages(this.deletedUnits));
                }
                if (!this.deletedSurfaces.isEmpty()) {
                    chartOccs.addAll(this.chartManager.getSurfaceUsages(this.deletedSurfaces));
                }
                if (chartOccs.size() > 0) {
                    Object msg = "Deleted units or surfaces are linked to chart correlation templates:\n";
                    for (ChartManager.ChartOcc occ : chartOccs) {
                        msg = (String)msg + "\n" + String.valueOf(occ.what);
                    }
                    msg = (String)msg + "\n\nCorrelation lines referencing deleted units or surfaces will be deleted. Do you want to continue?";
                    this.addProcessMessage((String)msg, "Deleted Units", IGDSchemeUpdateStep.DELETE_CORRLINES);
                    return false;
                }
            }
        } else if (this.getResponse(IGDSchemeUpdateStep.DELETE_CORRLINES) != ProcessMessage.Response.YES) {
            throw new IllegalStateException("Avoiding scheme update");
        }
        ModelProcess deleteUnitCorrelationLinesProcess = this.chartManager.deleteCorrelationLinesLinkedToUnits(this.deletedUnits);
        deleteUnitCorrelationLinesProcess.doDatabaseProcess();
        ModelProcess deleteSurfaceCorrelationLinesProcess = this.chartManager.deleteCorrelationLinesLinkedToSurfaces(this.deletedSurfaces);
        deleteSurfaceCorrelationLinesProcess.doDatabaseProcess();
        this.scheme.update(this.units, this.surfaces, this.schemeName, "", this.disc, this.sqType, this.parentID);
        deleteUnitCorrelationLinesProcess.doModelProcess();
        deleteSurfaceCorrelationLinesProcess.doModelProcess();
        return true;
    }

    private void copyWorkspaceSchemeToDatabase() throws SQLException, SBException {
        this.schemeAdded = new IGDScheme(this.sbdb, this.igdType, this.schemeName, "", this.disc, this.sqType, this.parentID);
        this.schemeAdded.storeDetails();
        Collections.sort(this.units, new IGDScheme.UnitHierComparator());
        try {
            for (IGDUnitBase.Builder unit : this.units) {
                IGDUnitBase base = this.schemeAdded.addUnit(unit);
                for (IGDUnitBase.Builder unit2 : this.units) {
                    if (unit2 == unit || !(unit2 instanceof IGDUnit.Builder)) continue;
                    if (((IGDUnit.Builder)unit2).u_age_ref == unit) {
                        ((IGDUnit.Builder)unit2).u_age_ref = base;
                    }
                    if (((IGDUnit.Builder)unit2).l_age_ref != unit) continue;
                    ((IGDUnit.Builder)unit2).l_age_ref = base;
                }
            }
            if (this.schemeAdded.isSequence()) {
                for (Surface.Builder surface : this.surfaces) {
                    this.schemeAdded.addSurface(surface);
                }
            }
        }
        catch (InvalidFieldException e) {
            throw new RuntimeException("Unexpected error adding units/surfaces", e);
        }
    }

    private boolean linkInformalTerms() throws SQLException {
        if (this.unlinkedIntervals == null) {
            List<IGDScheme.UnlinkedInterval> list = this.scheme.getUnlinkedIntervals();
            this.unlinkedIntervals = new LinkedList<IGDScheme.UnlinkedInterval>();
            this.nUnlinkedIntervalOccurrences = 0;
            for (IGDScheme.UnlinkedInterval interval : list) {
                if (interval.getMatchingUnitID() == null) continue;
                this.unlinkedIntervals.add(interval);
                this.nUnlinkedIntervalOccurrences += interval.getOccs();
            }
        }
        if (!this.hasResponse(IGDSchemeUpdateStep.LINK_INFORMAL) && !this.unlinkedIntervals.isEmpty()) {
            String msg = "Do you want to link " + this.unlinkedIntervals.size() + " units to " + this.nUnlinkedIntervalOccurrences + " occurrence(s) of informal terms in the well database?";
            this.addProcessMessage(msg, "Link Informal Intervals", IGDSchemeUpdateStep.LINK_INFORMAL);
            return false;
        }
        if (this.getResponse(IGDSchemeUpdateStep.LINK_INFORMAL) == ProcessMessage.Response.YES) {
            for (IGDScheme.UnlinkedInterval interval : this.unlinkedIntervals) {
                this.scheme.linkInformal(interval);
            }
        }
        return true;
    }

    public IGDScheme getSchemeAdded() {
        return this.schemeAdded;
    }

    public static enum IGDSchemeUpdateStep implements SbugsProcessStep
    {
        UNLINK_DELETED_INTERVALS,
        DELETE_CORRLINES,
        LINK_INFORMAL;

    }
}

