/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.model2.igdscheme;

import com.stratadata.model3.scheme.Confidence;
import java.util.LinkedList;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import jsbugs.table.ColouredRenderer;
import jsbugs.table.ComboRenderer;
import jsbugs.table.EnumEditor;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.IGDUnitBase;
import model3.Surface;
import util.SB;

class SurfaceTableModel
extends AbstractTableModel {
    static String[] colTitles = new String[]{"Surface Name", "Type", "Magnitude", "Age", "Confidence", "Occs", "Unit"};
    static int[] colWidths = new int[]{90, 20, 20, 20, 25, 20, 30};
    static final int COL_NAME = 0;
    static final int COL_TYPE = 1;
    static final int COL_MAG = 2;
    static final int COL_AGE = 3;
    static final int COL_CONF = 4;
    static final int COL_OCCS = 5;
    static final int COL_UNIT = 6;
    private final LinkedList<IGDUnitBase.Builder> units;
    LinkedList<Surface.Builder> scheme = new LinkedList();

    SurfaceTableModel(LinkedList<IGDUnitBase.Builder> list) {
        this.units = list;
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public int getRowCount() {
        if (this.scheme == null) {
            return 0;
        }
        return this.scheme.size();
    }

    @Override
    public Object getValueAt(int row, int col) {
        if (this.scheme.isEmpty()) {
            return "";
        }
        Surface.Builder surface = this.scheme.get(row);
        switch (col) {
            case 0: {
                return surface.getName();
            }
            case 1: {
                return surface.getTypeString();
            }
            case 2: {
                return surface.getType() == Surface.SurfaceType.MFS ? Surface.Magnitude.getMagnitude(surface.getMagnitude()) : null;
            }
            case 3: {
                return surface.getAge();
            }
            case 4: {
                return surface.getConfidence();
            }
            case 5: {
                return surface.getNOccs();
            }
            case 6: {
                IGDUnitBase.Builder unit = IGDScheme.findUnit(this.units, surface.getAge(), false);
                if (unit == null) {
                    return "";
                }
                return unit.getName();
            }
        }
        return "";
    }

    @Override
    public void setValueAt(Object obj, int row, int col) {
        if (this.scheme.isEmpty()) {
            return;
        }
        Surface.Builder surface = this.scheme.get(row);
        switch (col) {
            case 0: {
                surface.name((String)obj);
                break;
            }
            case 1: {
                surface.type((Surface.SurfaceType)((Object)obj));
                break;
            }
            case 3: {
                surface.age((Double)obj);
                break;
            }
            case 4: {
                surface.confidence((Confidence)obj);
                break;
            }
            case 6: {
                break;
            }
            case 2: {
                surface.magnitude(((Surface.Magnitude)((Object)obj)).getValue());
                break;
            }
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            case 0: 
            case 1: {
                return String.class;
            }
            case 3: {
                return Double.class;
            }
            case 5: {
                return Integer.class;
            }
            case 6: {
                return IGDUnit.class;
            }
            case 2: {
                return Surface.Magnitude.class;
            }
        }
        return Object.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            case 2: 
            case 5: 
            case 6: {
                if (!this.scheme.isEmpty()) {
                    Surface.Builder surface = this.scheme.get(row);
                    return surface.getType() == Surface.SurfaceType.MFS;
                }
                return false;
            }
        }
        return true;
    }

    void setupTable(JTable table, JComboBox typeCombo) {
        SB.setTableHeaderBold((JTable)table);
        table.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < colTitles.length; ++i) {
            table.getColumnModel().getColumn(i).setPreferredWidth(colWidths[i]);
            table.getColumnModel().getColumn(i).setHeaderValue(colTitles[i]);
        }
        table.getColumnModel().getColumn(1).setCellEditor(new DefaultCellEditor(typeCombo));
        table.getColumnModel().getColumn(5).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 4));
        table.getColumnModel().getColumn(6).setCellRenderer(new ColouredRenderer(false, ColouredRenderer.GREY, 4));
        table.getColumnModel().getColumn(1).setCellRenderer(new ComboRenderer());
        table.getColumnModel().getColumn(2).setCellEditor(new EnumEditor(new JComboBox(), Surface.Magnitude.class, null));
        table.getColumnModel().getColumn(2).setCellRenderer(new ComboRenderer());
        table.getColumnModel().getColumn(4).setCellRenderer(new ComboRenderer());
        table.getColumnModel().getColumn(4).setCellEditor(new EnumEditor(new JComboBox(), Confidence.class, null));
    }
}

