/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.organiser;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PanelColumnSelection
extends JPanel {
    public static final String UNSELECTED_TEXT = "Not Selected";
    private Color colour = null;
    private Color defaultBackground = null;
    private JComboBox<String> jComboBoxOptions;
    private JLabel jLabel1;
    private JPanel jPanel1;

    public PanelColumnSelection() {
        this.initComponents();
        this.defaultBackground = this.jLabel1.getBackground();
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jPanel1 = new JPanel();
        this.jComboBoxOptions = new JComboBox();
        this.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        this.setLayout(new BorderLayout(5, 5));
        this.jLabel1.setText("Column Name");
        this.jLabel1.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 0));
        this.jLabel1.setMaximumSize(new Dimension(100, 14));
        this.jLabel1.setMinimumSize(new Dimension(100, 14));
        this.jLabel1.setPreferredSize(new Dimension(100, 14));
        this.add((Component)this.jLabel1, "Before");
        this.jPanel1.setLayout(new BoxLayout(this.jPanel1, 1));
        this.jComboBoxOptions.setModel(new DefaultComboBoxModel<String>(new String[]{UNSELECTED_TEXT}));
        this.jComboBoxOptions.setAlignmentX(1.0f);
        this.jComboBoxOptions.setMaximumSize(new Dimension(100, 23));
        this.jComboBoxOptions.setMinimumSize(new Dimension(10, 23));
        this.jComboBoxOptions.setPreferredSize(new Dimension(200, 20));
        this.jComboBoxOptions.addActionListener(new ActionListener(this){
            final /* synthetic */ PanelColumnSelection this$0;
            {
                PanelColumnSelection panelColumnSelection = this$0;
                Objects.requireNonNull(panelColumnSelection);
                this.this$0 = panelColumnSelection;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jComboBoxOptionsActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jComboBoxOptions);
        this.add((Component)this.jPanel1, "Center");
    }

    private void jComboBoxOptionsActionPerformed(ActionEvent evt) {
        if (this.isSelected() && this.colour != null) {
            this.jLabel1.setBackground(this.colour);
            this.jLabel1.setOpaque(true);
        } else {
            this.jLabel1.setBackground(this.defaultBackground);
            this.jLabel1.setOpaque(false);
        }
    }

    public String getDescription() {
        return this.jLabel1.getText();
    }

    public void setDescription(String description) {
        this.jLabel1.setText(description);
    }

    public void setMaxComboboxSize(Dimension maximumSize) {
        this.jComboBoxOptions.setMaximumSize(maximumSize);
    }

    public Dimension getMaxComboboxSize() {
        return this.jComboBoxOptions.getMaximumSize();
    }

    public JComboBox getOptionsBox() {
        return this.jComboBoxOptions;
    }

    public void setSelectionOptions(List<String> options) {
        ArrayList<String> cboOptions = new ArrayList<String>();
        cboOptions.add(UNSELECTED_TEXT);
        cboOptions.addAll(options);
        this.jComboBoxOptions.setModel(new DefaultComboBoxModel<Object>(cboOptions.toArray()));
    }

    public boolean isSelected() {
        if (this.jComboBoxOptions.getSelectedItem() == null) {
            return false;
        }
        String selectedText = (String)this.jComboBoxOptions.getSelectedItem();
        return !selectedText.equals(UNSELECTED_TEXT);
    }

    public int getSelectedColumn() {
        if (!this.isSelected()) {
            return -1;
        }
        return this.getOptionsBox().getSelectedIndex() - 1;
    }

    public void clearSelection() {
        this.jComboBoxOptions.setSelectedIndex(0);
    }

    public Color getColour() {
        return this.colour;
    }

    public void setColour(Color colour) {
        this.colour = colour;
    }
}

