/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.organiser;

import com.stratadata.util.ui.table.TableUtils;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import jsbugs.organiser.IGDWellUnits;
import jsbugs.table.ArrowCellRenderer;
import model3.IGDIntervalZone;
import model3.IGDScheme;
import model3.IGDUnit;
import model3.SBdb;
import model3.Well;
import model3.WellInterp;
import util.exception.StackError;

class TableModelMatchIGDWellUnits
extends AbstractTableModel {
    static final int COL_WS_NAME = 0;
    static final int COL_WS_UNIT = 1;
    static final int COL_WS_OCCS = 2;
    static final int COL_ARROW = 3;
    static final int COL_HOST_SCHEME = 4;
    static final int COL_HOST_UNIT = 5;
    static final String[] colTitles = new String[]{"Interval name", "Workspace Unit", "No. Occs.", "", "Database Scheme", "Database Unit"};
    static final int[] colWidths = new int[]{80, 20, 40, 20, 50, 80};
    List<IGDWellUnits> data;

    TableModelMatchIGDWellUnits() {
    }

    @Override
    public int getRowCount() {
        return this.data == null ? 0 : this.data.size();
    }

    @Override
    public int getColumnCount() {
        return colTitles.length;
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.data == null) {
            return "";
        }
        IGDWellUnits row = this.data.get(rowIndex);
        if (row == null) {
            return "";
        }
        try {
            switch (columnIndex) {
                case 0: {
                    return row.wsUnitName;
                }
                case 1: {
                    return row.wsUnit;
                }
                case 2: {
                    return row.nOccs;
                }
                case 3: {
                    return row.dbUnit != null;
                }
                case 4: {
                    return row.dbScheme;
                }
                case 5: {
                    return row.dbUnit;
                }
            }
            return "";
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Class getColumnClass(int c) {
        switch (c) {
            default: {
                return String.class;
            }
            case 2: {
                return Integer.class;
            }
            case 4: {
                return IGDScheme.class;
            }
            case 1: 
            case 5: {
                return IGDUnit.class;
            }
            case 3: 
        }
        return Boolean.class;
    }

    @Override
    public boolean isCellEditable(int row, int col) {
        switch (col) {
            default: 
        }
        return false;
    }

    void setUpTable(JTable table) {
        TableUtils.setTableHeaderBold((JTable)table);
        TableColumnModel columnModel = table.getTableHeader().getColumnModel();
        for (int i = 0; i < columnModel.getColumnCount(); ++i) {
            columnModel.getColumn(i).setHeaderValue(colTitles[i]);
            columnModel.getColumn(i).setPreferredWidth(colWidths[i]);
        }
        columnModel.getColumn(3).setMaxWidth(colWidths[3]);
        table.setDefaultRenderer(Boolean.class, new ArrowCellRenderer());
        table.getTableHeader().setReorderingAllowed(false);
    }

    void init(SBdb ws, IGDScheme scheme) {
        HashMap<String, IGDWellUnits> map = new HashMap<String, IGDWellUnits>();
        try {
            Iterator<Well> it = ws.getWellIterator();
            while (it.hasNext()) {
                Well well = it.next();
                Iterator<WellInterp> iit = well.getInterpIterator();
                while (iit.hasNext()) {
                    WellInterp interp = iit.next();
                    List<IGDIntervalZone> zones = interp.getIGDList(scheme.getIGDType(), scheme.getID());
                    for (IGDIntervalZone zone : zones) {
                        String term = zone.getUppInf();
                        if (term != null && !term.isBlank()) {
                            this.buildMapEntry(map, scheme, term, zone.getUppUnit(false));
                        }
                        if ((term = zone.getLowInf()) == null || term.isBlank()) continue;
                        this.buildMapEntry(map, scheme, term, zone.getLowUnit(false));
                    }
                }
            }
            this.data = new LinkedList(map.values());
            Collections.sort(this.data);
        }
        catch (SQLException sql) {
            StackError.showStackError((String)"SQL Error checking matches", (SQLException)sql);
        }
        catch (RuntimeException re) {
            StackError.showStackError((String)"", (Throwable)re);
        }
    }

    private void buildMapEntry(HashMap<String, IGDWellUnits> map, IGDScheme scheme, String term, IGDUnit unit) {
        if (map.containsKey(term)) {
            ++map.get((Object)term).nOccs;
        } else {
            IGDWellUnits u = new IGDWellUnits();
            u.wsUnitName = term;
            u.nOccs = 1;
            u.wsUnit = unit;
            if (unit != null && unit.getLink() != null) {
                u.dbUnit = unit.getLink();
            }
            if (scheme.getLink() != null) {
                u.dbScheme = scheme.getLink();
            }
            map.put(term, u);
        }
    }
}

