/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;

public class FontSizeFinder {
    private final String fontName;
    private final int fontStyle;

    public FontSizeFinder(String fontName, int fontStyle) {
        this.fontName = fontName;
        this.fontStyle = fontStyle;
    }

    public int findFontSize(Graphics2D g, String text, Dimension area, int maxFontSize) {
        Font maxSizeFont = this.getFont(maxFontSize);
        Dimension areaNeeded = this.calculateTextDimension(g, text, maxSizeFont);
        if (this.fitsInsize(areaNeeded, area)) {
            return maxFontSize;
        }
        int step = Math.max(1, maxFontSize / 2);
        boolean fits = false;
        int testSize = maxFontSize;
        int sizeThatFits = 0;
        for (int i = 0; i < 8; ++i) {
            testSize = fits ? (testSize += step) : (testSize -= step);
            Font f = this.getFont(testSize);
            Dimension testArea = this.calculateTextDimension(g, text, f);
            fits = this.fitsInsize(testArea, area);
            step = Math.max(1, step / 2);
            if (!fits) continue;
            sizeThatFits = testSize;
        }
        return sizeThatFits;
    }

    private boolean fitsInsize(Dimension a, Dimension b) {
        return a.getWidth() < b.getWidth() && a.getHeight() < b.getHeight();
    }

    public Dimension calculateTextDimension(Graphics2D g, String string, Font f) {
        FontMetrics fm = g.getFontMetrics(f);
        int width = fm.stringWidth(string);
        int height = fm.getHeight();
        return new Dimension(width, height);
    }

    private Font getFont(int size) {
        return new Font(this.fontName, this.fontStyle, size);
    }
}

