/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import jsbugs.overlay.IOverlayDesignControlsListener;

public class JPanelOverlayDesignControls
extends JPanel {
    private static final Color PALE_BLUE = new Color(230, 230, 255);
    private boolean imagesSelected;
    private IOverlayDesignControlsListener listener;
    private boolean insertByRow = true;
    private JButton jButtonAutoArrange;
    private JButton jButtonCancel;
    private JButton jButtonInsertByColumn;
    private JButton jButtonInsertByRow;
    private JButton jButtonOk;
    private JButton jButtonRemoveSelected;
    private JButton jButtonTaxonImage;

    public JPanelOverlayDesignControls() {
        this.initComponents();
    }

    public void setListener(IOverlayDesignControlsListener listener) {
        this.listener = listener;
    }

    public void setShowImages(boolean value) {
        this.imagesSelected = value;
        this.updateImageButtonColour();
    }

    private void colourButtonSelected(JButton selected) {
        selected.setBackground(new Color(102, 102, 102));
        selected.setForeground(Color.WHITE);
    }

    private void colourButtonUnselected(JButton b) {
        b.setBackground(new Color(204, 204, 204));
        b.setForeground(Color.BLACK);
    }

    private void updateInsertButtonColours() {
        if (this.insertByRow) {
            this.colourButtonSelected(this.jButtonInsertByRow);
            this.colourButtonUnselected(this.jButtonInsertByColumn);
        } else {
            this.colourButtonSelected(this.jButtonInsertByColumn);
            this.colourButtonUnselected(this.jButtonInsertByRow);
        }
    }

    private void updateImageButtonColour() {
        if (this.imagesSelected) {
            this.jButtonTaxonImage.setBackground(PALE_BLUE);
        } else {
            this.jButtonTaxonImage.setBackground(Color.white);
        }
    }

    private void initComponents() {
        this.jButtonInsertByRow = new JButton();
        this.jButtonInsertByColumn = new JButton();
        this.jButtonRemoveSelected = new JButton();
        this.jButtonAutoArrange = new JButton();
        this.jButtonTaxonImage = new JButton();
        this.jButtonOk = new JButton();
        this.jButtonCancel = new JButton();
        this.setBackground(new Color(255, 255, 255));
        this.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setLayout(new GridBagLayout());
        this.jButtonInsertByRow.setBackground(new Color(102, 102, 102));
        this.jButtonInsertByRow.setFont(new Font("Tahoma", 0, 18));
        this.jButtonInsertByRow.setForeground(new Color(255, 255, 255));
        this.jButtonInsertByRow.setText("Insert by Row");
        this.jButtonInsertByRow.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonInsertByRow.setContentAreaFilled(false);
        this.jButtonInsertByRow.setFocusPainted(false);
        this.jButtonInsertByRow.setOpaque(true);
        this.jButtonInsertByRow.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertByRowActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonInsertByRow, gridBagConstraints);
        this.jButtonInsertByColumn.setBackground(new Color(204, 204, 204));
        this.jButtonInsertByColumn.setFont(new Font("Tahoma", 0, 18));
        this.jButtonInsertByColumn.setText("Insert by Column");
        this.jButtonInsertByColumn.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonInsertByColumn.setContentAreaFilled(false);
        this.jButtonInsertByColumn.setFocusPainted(false);
        this.jButtonInsertByColumn.setOpaque(true);
        this.jButtonInsertByColumn.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonInsertByColumnActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonInsertByColumn, gridBagConstraints);
        this.jButtonRemoveSelected.setBackground(new Color(255, 255, 255));
        this.jButtonRemoveSelected.setFont(new Font("Tahoma", 0, 18));
        this.jButtonRemoveSelected.setText("Remove Selected");
        this.jButtonRemoveSelected.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonRemoveSelected.setContentAreaFilled(false);
        this.jButtonRemoveSelected.setFocusPainted(false);
        this.jButtonRemoveSelected.setOpaque(true);
        this.jButtonRemoveSelected.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonRemoveSelectedActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonRemoveSelected, gridBagConstraints);
        this.jButtonAutoArrange.setBackground(new Color(255, 255, 255));
        this.jButtonAutoArrange.setFont(new Font("Tahoma", 0, 18));
        this.jButtonAutoArrange.setText("Auto Arrange");
        this.jButtonAutoArrange.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonAutoArrange.setContentAreaFilled(false);
        this.jButtonAutoArrange.setFocusPainted(false);
        this.jButtonAutoArrange.setOpaque(true);
        this.jButtonAutoArrange.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonAutoArrangeActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonAutoArrange, gridBagConstraints);
        this.jButtonTaxonImage.setBackground(new Color(255, 255, 255));
        this.jButtonTaxonImage.setFont(new Font("Tahoma", 0, 18));
        this.jButtonTaxonImage.setIcon(new ImageIcon(this.getClass().getResource("/resources/icon/camera.png")));
        this.jButtonTaxonImage.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonTaxonImage.setContentAreaFilled(false);
        this.jButtonTaxonImage.setFocusPainted(false);
        this.jButtonTaxonImage.setOpaque(true);
        this.jButtonTaxonImage.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonTaxonImageActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonTaxonImage, gridBagConstraints);
        this.jButtonOk.setBackground(new Color(255, 255, 255));
        this.jButtonOk.setFont(new Font("Tahoma", 0, 18));
        this.jButtonOk.setText("OK");
        this.jButtonOk.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonOk.setContentAreaFilled(false);
        this.jButtonOk.setFocusPainted(false);
        this.jButtonOk.setOpaque(true);
        this.jButtonOk.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOkActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonOk, gridBagConstraints);
        this.jButtonCancel.setBackground(new Color(255, 255, 255));
        this.jButtonCancel.setFont(new Font("Tahoma", 0, 18));
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.jButtonCancel.setContentAreaFilled(false);
        this.jButtonCancel.setFocusPainted(false);
        this.jButtonCancel.setOpaque(true);
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ JPanelOverlayDesignControls this$0;
            {
                JPanelOverlayDesignControls jPanelOverlayDesignControls = this$0;
                Objects.requireNonNull(jPanelOverlayDesignControls);
                this.this$0 = jPanelOverlayDesignControls;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jButtonCancel, gridBagConstraints);
    }

    private void jButtonInsertByRowActionPerformed(ActionEvent evt) {
        if (!this.insertByRow) {
            this.insertByRow = true;
            this.updateInsertButtonColours();
            if (this.listener != null) {
                this.listener.setInsertByRow();
            }
        }
    }

    private void jButtonInsertByColumnActionPerformed(ActionEvent evt) {
        if (this.insertByRow) {
            this.insertByRow = false;
            this.updateInsertButtonColours();
            if (this.listener != null) {
                this.listener.setInsertByColumn();
            }
        }
    }

    private void jButtonRemoveSelectedActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.removeSelectedClick();
        }
    }

    private void jButtonAutoArrangeActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.autoArrangeClick();
        }
    }

    private void jButtonTaxonImageActionPerformed(ActionEvent evt) {
        this.imagesSelected = !this.imagesSelected;
        this.updateImageButtonColour();
        if (this.listener != null) {
            this.listener.showTaxonImagesChanged(this.imagesSelected);
        }
    }

    private void jButtonOkActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.okButtonClicked();
        }
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        if (this.listener != null) {
            this.listener.cancelButtonClicked();
        }
    }
}

