/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.overlay;

import com.stratadata.model3.image.ImageLoader;
import com.stratadata.model3.image.ImageRecordService;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Shape;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.ImageIcon;
import jsbugs.overlay.CellLayoutImageLeft;
import jsbugs.overlay.CellLayoutImageTop;
import jsbugs.overlay.CellLayoutNoImage;
import jsbugs.overlay.FontSizeFinder;
import jsbugs.overlay.ICellLayout;
import jsbugs.overlay.OverlayCellData;
import util.RectUtils;

public class OverlayCellArtist {
    private static final Logger log = Logger.getLogger(OverlayCellArtist.class.getName());
    private static final int HORIZONTAL_PADDING_PX = 6;
    private static final int VERTICAL_PADDING_PX = 6;
    private static final int MIN_FONT_SIZE_PX = 12;
    private static final boolean DEBUG = false;
    Font countFontNoImage = new Font("Tahoma", 0, 9);
    Font taxaFontNoImage = new Font("Tahoma", 0, 18);
    Font countFontImage = new Font("Tahoma", 0, 9);
    Font taxaFontImage = new Font("Tahoma", 0, 18);
    private FontSizeFinder fontSizeFinder;
    private ICellLayout imageLayout = new CellLayoutImageTop();
    private ICellLayout noImageLayout = new CellLayoutNoImage();
    private final ImageRecordService imageRecordService;
    private final ImageLoader imageLoader;

    public OverlayCellArtist(ImageRecordService imageRecordService, ImageLoader imageLoader) {
        this.imageRecordService = imageRecordService;
        this.imageLoader = imageLoader;
        this.fontSizeFinder = new FontSizeFinder("Tahoma", 1);
    }

    public void drawGridCell(Graphics2D g, Rectangle location, OverlayCellData data, boolean showImages, boolean useCodes) {
        Rectangle innerCellLoc = this.calculateCellPadding(location);
        Shape oldClip = g.getClip();
        g.setClip(innerCellLoc.x, innerCellLoc.y, innerCellLoc.width, innerCellLoc.height);
        if (!showImages || data.getImageSet() == null) {
            this.drawGridCellNoImage(g, innerCellLoc, data, useCodes);
        } else {
            this.drawGridCellWithImage(g, innerCellLoc, data, useCodes);
        }
        g.setClip(oldClip);
    }

    private void drawGridCellWithImage(Graphics2D g, Rectangle innerCellLoc, OverlayCellData data, boolean useCodes) {
        g.setColor(Color.BLACK);
        g.setFont(this.taxaFontImage);
        FontMetrics fm = g.getFontMetrics();
        Rectangle imageArea = this.imageLayout.getImageArea(innerCellLoc);
        Rectangle taxaArea = this.imageLayout.getTaxonArea(innerCellLoc);
        Rectangle countArea = this.imageLayout.getCountArea(innerCellLoc);
        Dimension imageDimensions = null;
        if (data.getImageSet() != null) {
            try {
                Image image = data.getImageSet().getFirstImage(this.imageRecordService, this.imageLoader, new Dimension(imageArea.width, imageArea.height));
                if (image != null) {
                    ImageIcon imageIcon = new ImageIcon(image);
                    g.drawImage(image, imageArea.x, imageArea.y, null);
                    imageDimensions = new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight());
                }
            }
            catch (RuntimeException ex) {
                Logger.getLogger(OverlayCellArtist.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
        int halfTaxonHeight = taxaArea.height / 2;
        if (this.imageLayout instanceof CellLayoutImageLeft && imageDimensions != null && imageDimensions.width < imageArea.width) {
            taxaArea = RectUtils.rectangleExtendedLeft((Rectangle)taxaArea, (int)(imageArea.width - imageDimensions.width));
        }
        if (this.imageLayout instanceof CellLayoutImageTop && imageDimensions != null && imageDimensions.height < imageArea.height) {
            taxaArea = RectUtils.rectangleExtendedUp((Rectangle)taxaArea, (int)(imageArea.height - imageDimensions.height));
        }
        if (useCodes && data.getAlphaCode() != null && data.getAlphaCode().length() > 0) {
            g.drawString(data.getAlphaCode(), taxaArea.x, taxaArea.y + halfTaxonHeight + (fm.getAscent() - fm.getDescent()) / 2);
        } else {
            int genusBaseline = taxaArea.y + halfTaxonHeight - fm.getDescent();
            if (this.imageLayout instanceof CellLayoutImageTop && genusBaseline - fm.getAscent() < taxaArea.y) {
                genusBaseline = taxaArea.y + fm.getAscent();
            }
            int speciesBaseline = genusBaseline + fm.getHeight();
            if (data.getGenus() != null) {
                g.drawString(data.getGenus(), taxaArea.x, genusBaseline);
            }
            if (data.getSpecies() != null) {
                g.drawString(data.getSpecies(), taxaArea.x, speciesBaseline);
            }
        }
        g.setFont(this.countFontImage);
        g.setColor(Color.BLUE);
        fm = g.getFontMetrics();
        Dimension size = this.fontSizeFinder.calculateTextDimension(g, data.getCount(), g.getFont());
        int countBaseline = countArea.y + countArea.height - fm.getDescent();
        int countStart = countArea.x + countArea.width - size.width;
        g.drawString(data.getCount(), countStart, countBaseline);
    }

    private void drawGridCellNoImage(Graphics2D g, Rectangle innerCellLoc, OverlayCellData data, boolean useCodes) {
        g.setColor(Color.BLACK);
        g.setFont(this.taxaFontNoImage);
        FontMetrics fm = g.getFontMetrics();
        Rectangle taxaArea = this.noImageLayout.getTaxonArea(innerCellLoc);
        Rectangle countArea = this.noImageLayout.getCountArea(innerCellLoc);
        int halfHeight = taxaArea.height / 2;
        if (useCodes && data.getAlphaCode() != null && data.getAlphaCode().length() > 0) {
            g.drawString(data.getAlphaCode(), taxaArea.x, taxaArea.y + halfHeight + (fm.getAscent() - fm.getDescent()) / 2);
        } else {
            int genusBaseline = taxaArea.y + halfHeight - fm.getLeading() - fm.getDescent();
            int speciesBaseline = genusBaseline + fm.getHeight();
            if (data.getGenus() != null) {
                g.drawString(data.getGenus(), taxaArea.x, genusBaseline);
            }
            if (data.getSpecies() != null) {
                g.drawString(data.getSpecies(), taxaArea.x, speciesBaseline);
            }
        }
        g.setFont(this.countFontNoImage);
        g.setColor(Color.BLUE);
        fm = g.getFontMetrics();
        Dimension size = this.fontSizeFinder.calculateTextDimension(g, data.getCount(), g.getFont());
        int countBaseline = countArea.y + countArea.height - fm.getDescent();
        int countStart = countArea.x + countArea.width - size.width;
        g.drawString(data.getCount(), countStart, countBaseline);
    }

    private Rectangle calculateCellPadding(Rectangle location) {
        int newX = location.x + 6;
        int newY = location.y + 6;
        int newWidth = location.width - 12;
        int newHeight = location.height - 12;
        Rectangle innerCellLoc = new Rectangle(newX, newY, newWidth, newHeight);
        return innerCellLoc;
    }

    public void setupFontSize(Graphics2D g, OverlayCellData[] data, Dimension cellDimension, boolean useAlpha, boolean maximiseText) {
        Rectangle innerCellLoc = this.calculateCellPadding(new Rectangle(0, 0, cellDimension.width, cellDimension.height));
        int maxSize = cellDimension.height / 2;
        String longestTaxa = this.getLongestTaxa(g, data, this.getFont(maxSize), useAlpha);
        String avareageTaxa = "nnnnnnnnnnnn";
        if (maximiseText) {
            avareageTaxa = this.getAverageTaxa(g, data, this.getFont(maxSize), useAlpha);
        }
        String longestCount = this.getLongestCountString(g, data, this.getFont(maxSize));
        int taxaSizeNoImage = this.calculateTaxaFontSize(g, this.noImageLayout, innerCellLoc, longestTaxa, maxSize);
        if (taxaSizeNoImage < 28 && maximiseText) {
            taxaSizeNoImage = this.calculateTaxaFontSize(g, this.noImageLayout, innerCellLoc, avareageTaxa, maxSize);
        }
        if (taxaSizeNoImage < 12) {
            taxaSizeNoImage = 12;
        }
        this.taxaFontNoImage = this.getFont(taxaSizeNoImage);
        int countSizeNoImage = this.calculateCountFontSize(g, this.noImageLayout, innerCellLoc, longestCount, (int)((double)taxaSizeNoImage * 0.8));
        if (countSizeNoImage < 12) {
            countSizeNoImage = 12;
        }
        this.countFontNoImage = this.getFont(countSizeNoImage);
        ICellLayout[] imageLayouts = new ICellLayout[]{new CellLayoutImageTop(), new CellLayoutImageLeft()};
        int maxImageTaxaSize = -1;
        ICellLayout bestImageLayout = new CellLayoutImageTop();
        for (ICellLayout il : imageLayouts) {
            int imageTaxaSize = this.calculateTaxaFontSize(g, il, innerCellLoc, longestTaxa, maxSize);
            log.log(Level.FINE, il.getClass().getName() + " " + imageTaxaSize);
            if (imageTaxaSize < 28 && maximiseText) {
                imageTaxaSize = this.calculateTaxaFontSize(g, il, innerCellLoc, avareageTaxa, maxSize);
            }
            log.log(Level.FINE, il.getClass().getName() + " " + imageTaxaSize);
            if (imageTaxaSize <= maxImageTaxaSize) continue;
            maxImageTaxaSize = imageTaxaSize;
            bestImageLayout = il;
        }
        if (maxImageTaxaSize < 12) {
            maxImageTaxaSize = 12;
        }
        this.taxaFontImage = this.getFont(maxImageTaxaSize);
        int countSizeImage = this.calculateCountFontSize(g, bestImageLayout, innerCellLoc, longestCount, (int)((double)maxImageTaxaSize * 0.8));
        if (countSizeImage < 12) {
            countSizeImage = 12;
        }
        this.countFontImage = this.getFont(countSizeImage);
        this.imageLayout = bestImageLayout;
        log.log(Level.FINE, "font sizes no-image:" + this.taxaFontNoImage.getSize() + "," + this.countFontNoImage.getSize() + " image:" + this.taxaFontImage.getSize() + "," + this.countFontImage.getSize());
    }

    private int calculateTaxaFontSize(Graphics2D g, ICellLayout layout, Rectangle cell, String longestTaxa, int maxSize) {
        int maxLineHeight = layout.getTaxonArea((Rectangle)cell).height / 2;
        int maxLineWidth = layout.getTaxonArea((Rectangle)cell).width;
        Dimension maxTaxaArea = new Dimension(maxLineWidth, maxLineHeight);
        return this.fontSizeFinder.findFontSize(g, longestTaxa, maxTaxaArea, maxSize);
    }

    private int calculateCountFontSize(Graphics2D g, ICellLayout layout, Rectangle cell, String longestCount, int maxSize) {
        Rectangle countArea = layout.getCountArea(cell);
        Dimension maxCountArea = new Dimension(countArea.width, countArea.height);
        int maxCountFontSize = Math.max(12, maxSize);
        return this.fontSizeFinder.findFontSize(g, longestCount, maxCountArea, maxCountFontSize);
    }

    private String getLongestTaxa(Graphics2D g, OverlayCellData[] data, Font maxSizeFont, boolean useAlpha) {
        FontMetrics fm = g.getFontMetrics(maxSizeFont);
        String longestString = "";
        int longest = -1;
        for (OverlayCellData d : data) {
            int speciesWidth;
            int genusWidth;
            if (useAlpha && d.hasAlpha()) {
                int alphaWidth = fm.stringWidth(d.getAlphaCode());
                if (alphaWidth <= longest) continue;
                longest = alphaWidth;
                longestString = d.getAlphaCode();
                continue;
            }
            if (d.hasGenus() && (genusWidth = fm.stringWidth(d.getGenus())) > longest) {
                longest = genusWidth;
                longestString = d.getGenus();
            }
            if (!d.hasSpecies() || (speciesWidth = fm.stringWidth(d.getSpecies())) <= longest) continue;
            longest = speciesWidth;
            longestString = d.getSpecies();
        }
        return longestString;
    }

    private String getAverageTaxa(Graphics2D g, OverlayCellData[] data, Font maxSizeFont, boolean useAlpha) {
        FontMetrics fm = g.getFontMetrics(maxSizeFont);
        HashMap<String, Integer> sizes = new HashMap<String, Integer>();
        int total = 0;
        for (OverlayCellData d : data) {
            if (useAlpha && d.hasAlpha()) {
                int alphaWidth = fm.stringWidth(d.getAlphaCode());
                sizes.put(d.getAlphaCode(), alphaWidth);
                total += alphaWidth;
                continue;
            }
            if (d.hasGenus()) {
                int genusWidth = fm.stringWidth(d.getGenus());
                sizes.put(d.getGenus(), genusWidth);
                total += genusWidth;
            }
            if (!d.hasSpecies()) continue;
            int speciesWidth = fm.stringWidth(d.getSpecies());
            sizes.put(d.getSpecies(), speciesWidth);
            total += speciesWidth;
        }
        double mean = (float)total / (float)sizes.size();
        double target = mean + 15.0;
        int lowest = Integer.MAX_VALUE;
        String targetString = "nnnnnnnnnnnn";
        for (String s : sizes.keySet()) {
            int length = (Integer)sizes.get(s);
            if (length >= lowest || !((double)length > target)) continue;
            targetString = s;
            lowest = length;
        }
        return targetString;
    }

    private String getLongestCountString(Graphics2D g, OverlayCellData[] data, Font maxSizeFont) {
        FontMetrics fm = g.getFontMetrics(maxSizeFont);
        String longestString = "";
        int longest = -1;
        for (OverlayCellData d : data) {
            int width = fm.stringWidth(d.getCount());
            if (width <= longest) continue;
            longest = width;
            longestString = d.getCount();
        }
        return longestString;
    }

    private Font getFont(int size) {
        return new Font("Tahoma", 1, size);
    }
}

