/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.refresh;

import com.stratadata.util.ui.HelpUtils;
import com.stratadata.util.ui.SBDialog;
import java.awt.Component;
import java.awt.Font;
import java.awt.Frame;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.sql.SQLException;
import java.util.Objects;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import jsbugs.refresh.RefreshHelper;
import jsbugs.userconnect.SbugsSession;
import model3.Lastval;
import model3.SBdb;
import org.apache.commons.lang3.StringUtils;
import org.jdesktop.layout.GroupLayout;
import util.SB;

public class DialogRefresh
extends SBDialog {
    private static final int MINIMUM_INTERVAL_SECONDS = 15;
    private boolean isSecondsSelected = false;
    private ButtonGroup buttonGroup1;
    private JButton jButtonCancel;
    private JButton jButtonHelp;
    private JButton jButtonOK;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JRadioButton jRadioButtonMinutes;
    private JRadioButton jRadioButtonNorefresh;
    private JRadioButton jRadioButtonSeconds;
    private JSeparator jSeparator1;
    private JTextField jTextFieldRefresh;

    public DialogRefresh(Frame parent) {
        super(parent, true);
        this.initComponents();
        this.init();
    }

    private void init() {
        this.setTitle("Data Refresh Rate");
        this.getRootPane().setDefaultButton(this.jButtonOK);
        int seconds = (int)RefreshHelper.getRefreshInterval() / 1000;
        if (seconds == 0) {
            this.jRadioButtonNorefresh.setSelected(true);
            this.jTextFieldRefresh.setText("");
            this.jTextFieldRefresh.setEnabled(false);
        } else if (seconds > 59) {
            this.jRadioButtonMinutes.setSelected(true);
            this.jTextFieldRefresh.setText("" + seconds / 60);
            this.isSecondsSelected = false;
        } else {
            this.jRadioButtonSeconds.setSelected(true);
            this.jTextFieldRefresh.setText("" + seconds);
            this.isSecondsSelected = true;
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jLabel1 = new JLabel();
        this.jTextFieldRefresh = new JTextField();
        this.jRadioButtonSeconds = new JRadioButton();
        this.jRadioButtonMinutes = new JRadioButton();
        this.jRadioButtonNorefresh = new JRadioButton();
        this.jButtonCancel = new JButton();
        this.jButtonOK = new JButton();
        this.jSeparator1 = new JSeparator();
        this.jButtonHelp = new JButton();
        this.jLabel2 = new JLabel();
        this.setDefaultCloseOperation(2);
        this.setResizable(false);
        this.jLabel1.setText("Refresh displayed data every:");
        this.jTextFieldRefresh.addKeyListener(new KeyAdapter(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void keyTyped(KeyEvent evt) {
                this.this$0.jTextFieldRefreshKeyTyped(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonSeconds);
        this.jRadioButtonSeconds.setText("Seconds");
        this.jRadioButtonSeconds.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonSecondsActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonMinutes);
        this.jRadioButtonMinutes.setText("Minutes");
        this.jRadioButtonMinutes.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonMinutesActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jRadioButtonNorefresh);
        this.jRadioButtonNorefresh.setText("Don't refresh data");
        this.jRadioButtonNorefresh.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jRadioButtonNorefreshActionPerformed(evt);
            }
        });
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonCancelActionPerformed(evt);
            }
        });
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonOKActionPerformed(evt);
            }
        });
        this.jButtonHelp.setText("Help");
        this.jButtonHelp.addActionListener(new ActionListener(this){
            final /* synthetic */ DialogRefresh this$0;
            {
                DialogRefresh dialogRefresh = this$0;
                Objects.requireNonNull(dialogRefresh);
                this.this$0 = dialogRefresh;
            }

            @Override
            public void actionPerformed(ActionEvent evt) {
                this.this$0.jButtonHelpActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Tahoma", 1, 11));
        this.jLabel2.setText("This is for getting data changed by other users in a shared database");
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(1).add((Component)this.jRadioButtonNorefresh).add((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.jTextFieldRefresh, -2, 52, -2).addPreferredGap(0).add((Component)this.jRadioButtonSeconds).addPreferredGap(1).add((Component)this.jRadioButtonMinutes)).add(2, (GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jButtonOK).addPreferredGap(0).add((Component)this.jButtonHelp).addPreferredGap(0).add((Component)this.jButtonCancel))).add((Component)this.jSeparator1).add((Component)this.jLabel2)).addContainerGap()));
        layout.linkSize(new Component[]{this.jButtonCancel, this.jButtonHelp, this.jButtonOK}, 1);
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add(2, (GroupLayout.Group)layout.createSequentialGroup().addContainerGap(20, Short.MAX_VALUE).add((Component)this.jLabel2).addPreferredGap(1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jTextFieldRefresh, -2, -1, -2).add((Component)this.jRadioButtonSeconds).add((Component)this.jRadioButtonMinutes)).addPreferredGap(1).add((Component)this.jRadioButtonNorefresh).add(7, 7, 7).add((Component)this.jSeparator1, -2, 10, -2).add(1, 1, 1).add((GroupLayout.Group)layout.createParallelGroup(3).add((Component)this.jButtonCancel).add((Component)this.jButtonOK).add((Component)this.jButtonHelp)).addContainerGap()));
        this.pack();
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        int seconds;
        if (this.jRadioButtonNorefresh.isSelected()) {
            seconds = 0;
        } else {
            String fieldText = this.jTextFieldRefresh.getText().trim();
            if (fieldText.isEmpty()) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Please enter a refresh interval.", this.getTitle(), 2);
                return;
            }
            try {
                seconds = Integer.parseInt(this.jTextFieldRefresh.getText().trim());
            }
            catch (NumberFormatException nfe) {
                JOptionPane.showMessageDialog((Component)((Object)this), "Could not parse number of seconds.", "Error", 0);
                return;
            }
            if (this.jRadioButtonMinutes.isSelected()) {
                seconds *= 60;
            }
            if (seconds < 15) {
                JOptionPane.showMessageDialog((Component)((Object)this), "The minimum refresh rate is 15 seconds. This value will be used.", "Minimum Refresh Rate", 1);
                seconds = 15;
            }
        }
        SBdb db = SbugsSession.getDb();
        try {
            Lastval.putInt(db, "DMONITOR", seconds);
            db.commit();
        }
        catch (SQLException sql) {
            sql.printStackTrace();
        }
        RefreshHelper.setRefreshInterval(seconds * 1000);
        this.setOK();
    }

    private void jRadioButtonSecondsActionPerformed(ActionEvent evt) {
        this.jTextFieldRefresh.setEnabled(true);
        if (StringUtils.isBlank((CharSequence)this.jTextFieldRefresh.getText().trim())) {
            this.jTextFieldRefresh.setText("900");
        } else if (!this.isSecondsSelected) {
            this.jTextFieldRefresh.setText("" + Integer.parseInt(this.jTextFieldRefresh.getText()) * 60);
        }
        this.isSecondsSelected = true;
    }

    private void jRadioButtonMinutesActionPerformed(ActionEvent evt) {
        this.jTextFieldRefresh.setEnabled(true);
        if (StringUtils.isBlank((CharSequence)this.jTextFieldRefresh.getText().trim())) {
            this.jTextFieldRefresh.setText("15");
        } else if (this.isSecondsSelected) {
            this.jTextFieldRefresh.setText("" + Integer.parseInt(this.jTextFieldRefresh.getText()) / 60);
        }
        this.isSecondsSelected = false;
    }

    private void jRadioButtonNorefreshActionPerformed(ActionEvent evt) {
        this.jTextFieldRefresh.setEnabled(false);
    }

    private void jTextFieldRefreshKeyTyped(KeyEvent evt) {
        if (SB.intFieldVal((JTextField)this.jTextFieldRefresh, (int)3, (KeyEvent)evt, (boolean)false)) {
            this.getToolkit().beep();
        }
    }

    private void jButtonHelpActionPerformed(ActionEvent evt) {
        HelpUtils.openHelp((String)"control_panel.html#refresh");
    }
}

