/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.sampleage;

import java.util.List;
import model3.Sample;
import util.AgeFormat;
import util.AgeUtils;
import util.DepthUnits;
import util.gridwriter.CellFormat;
import util.gridwriter.GridSheet;

public class TextExporterSampleAge {
    public Object[][] getSampleAgeData(List<Sample> samples, int interpId, DepthUnits units, AgeFormat ageUnits) {
        GridSheet gb = new GridSheet();
        char unitChar = units.getChar();
        CellFormat bold = new CellFormat().setBold(true);
        gb.setFormat(bold);
        gb.appendString("Top Depth (%s)", new Object[]{units.getAbr()});
        gb.appendString("Base Depth (%s)", new Object[]{units.getAbr()});
        gb.append(new Object[]{"Label"});
        gb.append(new Object[]{"Type"});
        gb.appendString("Age (%s)", new Object[]{ageUnits.getDescr()});
        gb.appendString("Positive Error (%s)", new Object[]{ageUnits.getDescr()});
        gb.appendString("Negative Error (%s)", new Object[]{ageUnits.getDescr()});
        gb.append(new Object[]{"Isotope Ratio"});
        gb.clearFormat();
        for (Sample s : samples) {
            gb.addRow();
            if (s.hasTopDepth()) {
                gb.append(new Object[]{s.getTopDepth(unitChar)});
            } else {
                gb.append(new Object[]{""});
            }
            if (s.hasBaseDepth()) {
                gb.append(new Object[]{s.getBaseDepth(unitChar)});
            } else {
                gb.append(new Object[]{""});
            }
            gb.append(new Object[]{s.getLabel()});
            gb.append(new Object[]{s.getTypeString()});
            gb.append(new Object[]{AgeUtils.convertFromMa((Double)s.getAge(interpId), (AgeFormat)ageUnits)});
            gb.append(new Object[]{AgeUtils.convertFromMa((Float)s.getAgeErrorPlus(interpId), (AgeFormat)ageUnits)});
            gb.append(new Object[]{AgeUtils.convertFromMa((Float)s.getAgeErrorMinus(interpId), (AgeFormat)ageUnits)});
            gb.append(new Object[]{s.getRatio(interpId)});
        }
        return gb.getObjectArray();
    }
}

