/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps;

import java.awt.BorderLayout;
import java.io.File;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.icepdf.ri.common.SwingController;
import org.icepdf.ri.common.SwingViewBuilder;
import org.icepdf.ri.util.PropertiesManager;

public class JPanelPdfPreview
extends JPanel {
    private final SwingController controller = new SwingController();
    private JPanel viewerComponentPanel;
    private File currentFile;
    private String currentDocTitle;

    public JPanelPdfPreview() {
        this.init();
    }

    private void init() {
        Properties props = new Properties();
        PropertiesManager iceProperties = new PropertiesManager(System.getProperties(), props, ResourceBundle.getBundle("org.icepdf.ri.resources.MessageBundle"));
        iceProperties.setBoolean("application.toolbar.show.utility.save", false);
        iceProperties.setBoolean("application.toolbar.show.forms", false);
        iceProperties.setBoolean("application.toolbar.show.tool", false);
        iceProperties.setBoolean("application.toolbar.show.annotation", false);
        iceProperties.setBoolean("application.toolbar.show.utility.upane", false);
        SwingViewBuilder factory = new SwingViewBuilder(this.controller, iceProperties);
        this.viewerComponentPanel = factory.buildViewerPanel();
        this.setLayout(new BorderLayout());
    }

    public void clearDisplay() {
        this.removeAll();
        this.repaint();
    }

    public void displayPdf(File pdfFile, String documentTitle) {
        this.controller.openDocument(pdfFile.toString());
        this.controller.setPageFitMode(4, true);
        if (this.getComponentCount() < 1) {
            this.add(this.viewerComponentPanel);
        }
        this.currentFile = pdfFile;
        this.currentDocTitle = documentTitle;
        this.repaint();
    }

    public JFrame createDetachedViewer(String WellName) {
        if (this.currentFile == null) {
            return null;
        }
        JPanelPdfPreview jPanelPdfPreview = new JPanelPdfPreview();
        jPanelPdfPreview.displayPdf(this.currentFile, this.currentDocTitle);
        JFrame frame = new JFrame();
        frame.setTitle("Well Document : " + WellName + " : " + this.currentDocTitle);
        frame.add(jPanelPdfPreview);
        frame.pack();
        return frame;
    }
}

