/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps;

import com.stratadata.model3.Discipline;

public class TabView {
    private final TabType tabType;
    private Discipline disc;
    private String analyst;
    private Integer suiteNo;
    private Integer interpsTabDataType;
    private Integer interpID;
    private Integer blockTemplateID;
    private Integer chartTemplateID;

    private TabView(TabType tabType) {
        this.tabType = tabType;
    }

    public static TabView createSamplesTabView() {
        return new TabView(TabType.SAMPLES);
    }

    public static TabView createAnalysesTabView(Discipline disc, String analyst, Integer suiteNo) {
        TabView tabView = new TabView(TabType.ANALYSES);
        tabView.disc = disc;
        tabView.analyst = analyst;
        tabView.suiteNo = suiteNo;
        return tabView;
    }

    public static TabView createOccurrencesTabView(Discipline disc, String analyst, int suiteNo) {
        TabView tabView = new TabView(TabType.OCCURRENCES);
        tabView.disc = disc;
        tabView.analyst = analyst;
        tabView.suiteNo = suiteNo;
        return tabView;
    }

    public static TabView createInterpsTabView(int interpID, int interpsTabDataType) {
        TabView tabView = new TabView(TabType.INTERPS);
        tabView.interpID = interpID;
        tabView.interpsTabDataType = interpsTabDataType;
        return tabView;
    }

    public static TabView createChartsTabView(int interpID, Integer blockTemplateID, Integer chartTemplateID) {
        TabView tabView = new TabView(TabType.CHARTS);
        tabView.interpID = interpID;
        tabView.blockTemplateID = blockTemplateID;
        tabView.chartTemplateID = chartTemplateID;
        return tabView;
    }

    public static TabView createDocumentsTabView(int interpID) {
        TabView tabView = new TabView(TabType.DOCUMENTS);
        tabView.interpID = interpID;
        return tabView;
    }

    public static TabView createDecodedTabView(String encodedView) {
        String[] vals = encodedView.split(",");
        TabView tabView = null;
        block10: for (int i = 0; i < vals.length; ++i) {
            if (vals[i] == null || vals[i].equals("null")) continue;
            switch (i) {
                case 0: {
                    tabView = new TabView(TabType.valueOf(vals[i]));
                    continue block10;
                }
                case 1: {
                    tabView.disc = Discipline.getDisc((String)vals[i]);
                    continue block10;
                }
                case 2: {
                    tabView.analyst = vals[i];
                    continue block10;
                }
                case 3: {
                    tabView.suiteNo = Integer.parseInt(vals[i]);
                    continue block10;
                }
                case 4: {
                    tabView.interpID = Integer.parseInt(vals[4]);
                    continue block10;
                }
                case 5: {
                    tabView.blockTemplateID = Integer.parseInt(vals[5]);
                    continue block10;
                }
                case 6: {
                    tabView.chartTemplateID = Integer.parseInt(vals[6]);
                    continue block10;
                }
                case 7: {
                    tabView.interpsTabDataType = Integer.parseInt(vals[7]);
                }
            }
        }
        return tabView;
    }

    public String encode() {
        return this.tabType.toString() + "," + String.valueOf(this.disc != null ? Character.valueOf(this.disc.getChar()) : "null") + "," + this.analyst + "," + this.suiteNo + "," + this.interpID + "," + this.blockTemplateID + "," + this.chartTemplateID + "," + (this.interpsTabDataType != null ? this.interpsTabDataType.toString() : "null");
    }

    public TabType getTabType() {
        return this.tabType;
    }

    public Discipline getDisc() {
        return this.disc;
    }

    public String getAnalyst() {
        return this.analyst;
    }

    public Integer getSuiteNo() {
        return this.suiteNo;
    }

    public Integer getInterpID() {
        return this.interpID;
    }

    public Integer getBlockTemplateID() {
        return this.blockTemplateID;
    }

    public Integer getChartTemplateID() {
        return this.chartTemplateID;
    }

    public Integer getInterpsTabDataType() {
        return this.interpsTabDataType;
    }

    public static enum TabType {
        SAMPLES,
        ANALYSES,
        OCCURRENCES,
        INTERPS,
        CHARTS,
        DOCUMENTS;

    }
}

