/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.samplesandinterps.taxonoccurrences;

import com.stratadata.model3.well.analysis.hdr.AbundanceScheme;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import javax.swing.table.AbstractTableModel;
import jsbugs.samplesandinterps.taxonoccurrences.TaxonOccurrencesTableRow;
import jsbugs.table.IGetValue;
import jsbugs.table.SimpleTableColumn;
import jsbugs.uiutil.ComboboxItem;
import model3.TaxonOcc;

public class TaxonOccurrencesTableModel
extends AbstractTableModel {
    private final SimpleTableColumn<TaxonOccurrencesTableRow> situationColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Situation", 70, String.class, row -> row.situation.getAbr());
    private final SimpleTableColumn<TaxonOccurrencesTableRow> questionableColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("?", 20, String.class, new IGetValue<TaxonOccurrencesTableRow>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(TaxonOccurrencesTableRow row) {
            return row.questionable ? "?" : "";
        }
    });
    private final SimpleTableColumn<TaxonOccurrencesTableRow> markerColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Mkr?", 10, Boolean.class, row -> row.marker);
    private final SimpleTableColumn<TaxonOccurrencesTableRow> subjectiveColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Abund.", 30, String.class, new IGetValue<TaxonOccurrencesTableRow>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(TaxonOccurrencesTableRow row) {
            return row.subjective;
        }
    }, true);
    private final SimpleTableColumn<TaxonOccurrencesTableRow> typeColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Type", 10, String.class, row -> row.specType > 0 ? row.specTypeString : "");
    private final SimpleTableColumn<TaxonOccurrencesTableRow> coarseColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Coarse", 30, Integer.class, new IGetValue<TaxonOccurrencesTableRow>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(TaxonOccurrencesTableRow row) {
            return row.coarse;
        }
    }, true);
    private final SimpleTableColumn<TaxonOccurrencesTableRow> mediumColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Medium", 30, Integer.class, new IGetValue<TaxonOccurrencesTableRow>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(TaxonOccurrencesTableRow row) {
            return row.medium;
        }
    }, true);
    private final SimpleTableColumn<TaxonOccurrencesTableRow> fineColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Fine", 30, Integer.class, new IGetValue<TaxonOccurrencesTableRow>(this){
        {
            Objects.requireNonNull(this$0);
        }

        @Override
        public Object getValue(TaxonOccurrencesTableRow row) {
            return row.fine;
        }
    }, true);
    private final SimpleTableColumn<TaxonOccurrencesTableRow> totalColumn = new SimpleTableColumn<TaxonOccurrencesTableRow>("Total", 30, String.class, new IGetValue<TaxonOccurrencesTableRow>(this){
        final /* synthetic */ TaxonOccurrencesTableModel this$0;
        {
            TaxonOccurrencesTableModel taxonOccurrencesTableModel = this$0;
            Objects.requireNonNull(taxonOccurrencesTableModel);
            this.this$0 = taxonOccurrencesTableModel;
        }

        @Override
        public Object getValue(TaxonOccurrencesTableRow row) {
            return this.this$0.buildTotalString(row);
        }
    });
    List<SimpleTableColumn<TaxonOccurrencesTableRow>> columns = new ArrayList<SimpleTableColumn<TaxonOccurrencesTableRow>>();
    public List<TaxonOccurrencesTableRow> rows;
    private AbundanceScheme abundanceScheme;

    public TaxonOccurrencesTableModel(boolean includeSplitFactions, boolean includeSemiquant, boolean semiQuantOnly) {
        this.columns.addAll(Arrays.asList(this.markerColumn, this.situationColumn, this.questionableColumn, this.typeColumn));
        if (semiQuantOnly) {
            this.columns.add(this.subjectiveColumn);
        } else if (!includeSplitFactions && !includeSemiquant) {
            this.columns.add(this.mediumColumn);
            this.mediumColumn.setTitle("Count");
        } else {
            if (includeSemiquant) {
                this.columns.add(this.subjectiveColumn);
            }
            if (includeSplitFactions) {
                this.columns.add(this.coarseColumn);
                this.columns.add(this.mediumColumn);
                this.columns.add(this.fineColumn);
                this.columns.add(this.totalColumn);
            } else {
                this.columns.add(this.mediumColumn);
                this.mediumColumn.setTitle("Count");
            }
        }
    }

    public void setRows(List<TaxonOccurrencesTableRow> rows) {
        this.rows = rows;
    }

    public void setAbundanceScheme(AbundanceScheme abundanceScheme) {
        this.abundanceScheme = abundanceScheme;
    }

    @Override
    public String getColumnName(int column) {
        return this.columns.get(column).getTitle();
    }

    @Override
    public int getRowCount() {
        if (this.rows == null) {
            return 0;
        }
        return this.rows.size();
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        if (this.rows == null) {
            return null;
        }
        TaxonOccurrencesTableRow r = this.rows.get(rowIndex);
        SimpleTableColumn<TaxonOccurrencesTableRow> column = this.columns.get(columnIndex);
        return column.getValueFromRow(r);
    }

    public Class getColumnClass(int columnIndex) {
        SimpleTableColumn<TaxonOccurrencesTableRow> column = this.columns.get(columnIndex);
        return column.getValueClass();
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        SimpleTableColumn<TaxonOccurrencesTableRow> column = this.columns.get(columnIndex);
        return column.isColumnEditable();
    }

    @Override
    public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
        if (this.rows == null) {
            return;
        }
        TaxonOccurrencesTableRow r = this.rows.get(rowIndex);
        SimpleTableColumn<TaxonOccurrencesTableRow> column = this.columns.get(columnIndex);
        if (column.isColumnEditable()) {
            if (column.equals(this.subjectiveColumn)) {
                if (aValue instanceof ComboboxItem) {
                    ComboboxItem item = (ComboboxItem)aValue;
                    if (item.getValue() == null) {
                        r.subjective = null;
                    } else if (((String)item.getValue()).equals("+")) {
                        r.subjective = (String)item.getValue();
                        r.coarse = null;
                        r.fine = null;
                        r.medium = null;
                    } else {
                        r.subjective = (String)item.getValue();
                        r.coarse = null;
                        r.fine = null;
                        r.medium = null;
                    }
                }
            } else if (column.equals(this.coarseColumn)) {
                if (aValue == null) {
                    r.coarse = null;
                } else {
                    r.subjective = null;
                    r.coarse = Integer.parseInt(aValue.toString());
                }
            } else if (column.equals(this.mediumColumn)) {
                if (aValue == null) {
                    r.medium = null;
                } else {
                    r.subjective = null;
                    r.medium = Integer.parseInt(aValue.toString());
                }
            } else if (column.equals(this.fineColumn)) {
                if (aValue == null) {
                    r.fine = null;
                } else {
                    r.subjective = null;
                    r.fine = Integer.parseInt(aValue.toString());
                }
            }
            this.fireTableDataChanged();
        }
    }

    TaxonOccurrencesTableRow getCorrespondingRow(TaxonOcc occ) {
        if (this.rows == null) {
            return null;
        }
        return this.rows.stream().filter(row -> row.situation == occ.getSituation() && row.questionable == occ.getQuestionable() && row.specType == occ.getSpecType()).findFirst().orElse(null);
    }

    private String buildTotalString(TaxonOccurrencesTableRow r) {
        String total = "";
        if (r.subjective != null && !r.subjective.isEmpty()) {
            total = this.abundanceScheme != null && !"+".equals(r.subjective) ? Integer.toString(this.abundanceScheme.getCountBySubjAbund(r.subjective)) : r.subjective;
        } else if (r.coarse == null && r.medium == null && r.fine == null) {
            total = "(deleted)";
        } else {
            int t = 0;
            if (r.coarse != null) {
                t += r.coarse.intValue();
            }
            if (r.medium != null) {
                t += r.medium.intValue();
            }
            if (r.fine != null) {
                t += r.fine.intValue();
            }
            total = t == 0 ? "+" : Integer.toString(t);
        }
        return total;
    }

    public int getSubjectiveColumnIndex() {
        return this.columns.indexOf(this.subjectiveColumn);
    }
}

