/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.slidestore;

import com.stratadata.model3.slidestore.Cabinet;
import com.stratadata.model3.slidestore.Drawer;
import com.stratadata.model3.slidestore.SlideBox;
import com.stratadata.model3.slidestore.SlideStoreService;
import com.stratadata.model3.taxon.Taxon;
import com.stratadata.model3.taxon.TaxonService;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.table.DefaultTableModel;
import jsbugs.TableModelSB;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.SBdb;

public class DialogCabinet
extends JDialog {
    private static final String SELECT = "<Select>";
    private final DefaultComboBoxModel cabinetModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel drawerModel = new DefaultComboBoxModel();
    private final DefaultComboBoxModel slideBoxModel = new DefaultComboBoxModel();
    private final TableModelSlideCell model = new TableModelSlideCell();
    private final SlideStoreService slideStoreService;
    private final TaxonService taxonService;
    private JPanel dialogPane;
    private JPanel contentPanel;
    private JPanel panel1;
    private JLabel label1;
    private JLabel label2;
    private JComboBox comboBoxCabinet;
    private JComboBox comboBoxDrawer;
    private JLabel label3;
    private JComboBox comboBoxSlideBox;
    private JLabel label4;
    private JTextField textFieldSearch;
    private JPanel hSpacer1;
    private JButton buttonSearch;
    private JScrollPane scrollPane2;
    private JTable tableSlideBox;
    private JPanel buttonBar;
    private JButton closeButton;

    public DialogCabinet(Window owner, SBdb sbdb) {
        this(owner, sbdb, 0);
    }

    public DialogCabinet(Window owner, SBdb sbdb, int specID) {
        super(owner);
        this.initComponents();
        this.slideStoreService = sbdb.getSlideStoreService();
        this.taxonService = sbdb.getTaxonService();
        this.init(sbdb, specID);
    }

    private void init(SBdb sbdb, int specID) {
        this.setTitle("Slide Store");
        this.tableSlideBox.setModel(this.model);
        if (specID == 0) {
            this.cabinetModel.addElement(SELECT);
            this.cabinetModel.addAll(this.slideStoreService.getCabinets());
            this.comboBoxCabinet.setModel(this.cabinetModel);
            this.comboBoxDrawer.setModel(this.drawerModel);
            this.comboBoxSlideBox.setModel(this.slideBoxModel);
        } else {
            this.comboBoxCabinet.setEnabled(false);
            this.comboBoxDrawer.setEnabled(false);
            this.comboBoxSlideBox.setEnabled(false);
            this.setTableDataForSpecies(specID);
        }
        this.model.setupTable(this.tableSlideBox, sbdb);
    }

    private void setTableDataForSpecies(int specID) {
        try {
            List slides = this.slideStoreService.findSpecimenSlides(specID);
            List<TableModelSlideCell.SpecimenRow> tableRows = slides.stream().map(slide -> new TableModelSlideCell.SpecimenRow((SlideStoreService.SpecimenSlide)slide, this.taxonService.findTaxon(specID).orElse(null))).toList();
            this.model.setTableData(tableRows);
        }
        catch (RuntimeException e) {
            SbugsExceptionHandler.showStackError("Error loading slide store", e, this);
        }
    }

    private void cancel(ActionEvent e) {
        this.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboBoxDrawerItemStateChanged(ItemEvent e) {
        try {
            Object selection = this.drawerModel.getElementAt(this.comboBoxDrawer.getSelectedIndex());
            if (selection instanceof Drawer) {
                Drawer drawer = (Drawer)selection;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.slideBoxModel.removeAllElements();
                this.slideBoxModel.addAll(this.slideStoreService.findSlideBoxes(drawer.getDrawerID()));
            } else {
                this.slideBoxModel.removeAllElements();
            }
            this.comboBoxSlideBox.repaint();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboBoxCabinetItemStateChanged(ItemEvent e) {
        try {
            Object selection = this.cabinetModel.getElementAt(this.comboBoxCabinet.getSelectedIndex());
            if (selection instanceof Cabinet) {
                Cabinet cabinet = (Cabinet)selection;
                this.setCursor(Cursor.getPredefinedCursor(3));
                this.drawerModel.removeAllElements();
                this.drawerModel.addAll(this.slideStoreService.findDrawers(cabinet.cabinetID()));
            } else {
                this.drawerModel.removeAllElements();
                this.slideBoxModel.removeAllElements();
                this.comboBoxSlideBox.repaint();
            }
            this.comboBoxDrawer.repaint();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void comboBoxSlideBoxItemStateChanged(ItemEvent e) {
        try {
            Object selection = this.slideBoxModel.getElementAt(this.comboBoxSlideBox.getSelectedIndex());
            if (selection instanceof SlideBox) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                List slides = this.slideStoreService.findSlideCellSpecimens((Cabinet)this.comboBoxCabinet.getSelectedItem(), (Drawer)this.comboBoxDrawer.getSelectedItem(), (SlideBox)this.comboBoxSlideBox.getSelectedItem());
                LinkedList<TableModelSlideCell.SpecimenRow> tableRows = new LinkedList<TableModelSlideCell.SpecimenRow>();
                for (SlideStoreService.SpecimenSlide slide : slides) {
                    Taxon taxon = null;
                    if (slide.specimen() != null) {
                        taxon = this.taxonService.findTaxon(slide.specimen().getSpecID()).orElse(null);
                    }
                    tableRows.add(new TableModelSlideCell.SpecimenRow(slide, taxon));
                }
                this.model.setTableData(tableRows);
            } else {
                this.model.setTableData(null);
            }
            this.model.fireTableDataChanged();
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void search(ActionEvent e) {
        String searchString = this.textFieldSearch.getText().trim();
        if (searchString.isEmpty() || searchString.length() < 1 || searchString.equals("%")) {
            JOptionPane.showMessageDialog(this, "Please enter a valid search term, using % as a wildcard and to separate terms.", "Slide Store", 0);
            return;
        }
        try {
            this.setCursor(Cursor.getPredefinedCursor(3));
            List slides = this.slideStoreService.findSlideCellSpecimens(searchString);
            LinkedList<TableModelSlideCell.SpecimenRow> tableRows = new LinkedList<TableModelSlideCell.SpecimenRow>();
            for (SlideStoreService.SpecimenSlide slide : slides) {
                Taxon taxon = null;
                if (slide.specimen() != null) {
                    taxon = this.taxonService.findTaxon(slide.specimen().getSpecID()).orElse(null);
                }
                tableRows.add(new TableModelSlideCell.SpecimenRow(slide, taxon));
            }
            this.model.setTableData(tableRows);
            this.model.fireTableDataChanged();
            if (tableRows.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No collections found.", "Slide Store", 0);
                return;
            }
        }
        catch (RuntimeException ex) {
            SbugsExceptionHandler.showStackError(ex, this);
        }
        finally {
            this.setCursor(Cursor.getPredefinedCursor(0));
        }
    }

    private void initComponents() {
        this.dialogPane = new JPanel();
        this.contentPanel = new JPanel();
        this.panel1 = new JPanel();
        this.label1 = new JLabel();
        this.label2 = new JLabel();
        this.comboBoxCabinet = new JComboBox();
        this.comboBoxDrawer = new JComboBox();
        this.label3 = new JLabel();
        this.comboBoxSlideBox = new JComboBox();
        this.label4 = new JLabel();
        this.textFieldSearch = new JTextField();
        this.hSpacer1 = new JPanel(null);
        this.buttonSearch = new JButton();
        this.scrollPane2 = new JScrollPane();
        this.tableSlideBox = new JTable();
        this.buttonBar = new JPanel();
        this.closeButton = new JButton();
        this.setPreferredSize(new Dimension(900, 900));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new GridBagLayout());
        ((GridBagLayout)contentPane.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)contentPane.getLayout()).rowHeights = new int[]{0, 0};
        ((GridBagLayout)contentPane.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)contentPane.getLayout()).rowWeights = new double[]{1.0, 1.0E-4};
        this.dialogPane.setBorder(new EmptyBorder(12, 12, 12, 12));
        this.dialogPane.setLayout(new GridBagLayout());
        ((GridBagLayout)this.dialogPane.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.dialogPane.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.dialogPane.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)this.dialogPane.getLayout()).rowWeights = new double[]{1.0, 0.0, 1.0E-4};
        this.contentPanel.setLayout(new GridBagLayout());
        ((GridBagLayout)this.contentPanel.getLayout()).columnWidths = new int[]{0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).rowHeights = new int[]{0, 0, 0};
        ((GridBagLayout)this.contentPanel.getLayout()).columnWeights = new double[]{1.0, 1.0E-4};
        ((GridBagLayout)this.contentPanel.getLayout()).rowWeights = new double[]{0.0, 1.0, 1.0E-4};
        this.panel1.setLayout(new GridBagLayout());
        ((GridBagLayout)this.panel1.getLayout()).columnWidths = new int[]{60, 0, 0, 0, 0};
        ((GridBagLayout)this.panel1.getLayout()).rowHeights = new int[]{0, 0, 0, 0, 0};
        ((GridBagLayout)this.panel1.getLayout()).columnWeights = new double[]{0.0, 1.0, 0.0, 0.0, 1.0E-4};
        ((GridBagLayout)this.panel1.getLayout()).rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 1.0E-4};
        this.label1.setText("Cabinet:");
        this.panel1.add((Component)this.label1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.label2.setText("Drawer:");
        this.panel1.add((Component)this.label2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.comboBoxCabinet.addItemListener(e -> this.comboBoxCabinetItemStateChanged(e));
        this.panel1.add((Component)this.comboBoxCabinet, new GridBagConstraints(1, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.comboBoxDrawer.addItemListener(e -> this.comboBoxDrawerItemStateChanged(e));
        this.panel1.add((Component)this.comboBoxDrawer, new GridBagConstraints(1, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.label3.setText("Slide box:");
        this.panel1.add((Component)this.label3, new GridBagConstraints(0, 2, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 5, 5), 0, 0));
        this.comboBoxSlideBox.addItemListener(e -> this.comboBoxSlideBoxItemStateChanged(e));
        this.panel1.add((Component)this.comboBoxSlideBox, new GridBagConstraints(1, 2, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 5, 5), 0, 0));
        this.label4.setText("Search collection:");
        this.panel1.add((Component)this.label4, new GridBagConstraints(0, 3, 1, 1, 0.0, 0.0, 13, 3, new Insets(0, 0, 0, 5), 0, 0));
        this.textFieldSearch.setText("%%");
        this.textFieldSearch.setToolTipText("Add search term between the pair of % (case insensitive)");
        this.panel1.add((Component)this.textFieldSearch, new GridBagConstraints(1, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.panel1.add((Component)this.hSpacer1, new GridBagConstraints(1, 3, 2, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 5), 0, 0));
        this.buttonSearch.setText("Search ...");
        this.buttonSearch.addActionListener(e -> this.search(e));
        this.panel1.add((Component)this.buttonSearch, new GridBagConstraints(3, 3, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.contentPanel.add((Component)this.panel1, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 10, 0), 0, 0));
        this.tableSlideBox.setModel(new DefaultTableModel(new Object[][]{{null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}, {null, null, null, null, null, null, null}}, new String[]{"Slide cell", "Cell number", "Specimen", "Comments", "Author", null, null}));
        this.scrollPane2.setViewportView(this.tableSlideBox);
        this.contentPanel.add((Component)this.scrollPane2, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.contentPanel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.buttonBar.setBorder(new EmptyBorder(12, 0, 0, 0));
        this.buttonBar.setLayout(new GridBagLayout());
        ((GridBagLayout)this.buttonBar.getLayout()).columnWidths = new int[]{0, 85, 80};
        ((GridBagLayout)this.buttonBar.getLayout()).columnWeights = new double[]{1.0, 0.0, 0.0};
        this.closeButton.setText("Close");
        this.closeButton.addActionListener(e -> this.cancel(e));
        this.buttonBar.add((Component)this.closeButton, new GridBagConstraints(2, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.dialogPane.add((Component)this.buttonBar, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        contentPane.add((Component)this.dialogPane, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.pack();
        this.setLocationRelativeTo(this.getOwner());
    }

    private static class TableModelSlideCell
    extends TableModelSB {
        private static final String[] COLUMN_TITLES = new String[]{"Cabinet", "Drawer", "Slide Box", "Cell number", "Specimen", "Comments", "Author", "Images"};
        private static final int[] COLUMN_WIDTHS = new int[]{50, 10, 40, 10, 160, 200, 100, 10};
        private final List<SpecimenRow> rows = new ArrayList<SpecimenRow>();
        static final int COL_CABINET = 0;
        static final int COL_DRAWER = 1;
        static final int COL_SLIDEBOX = 2;
        static final int COL_CELLNUMBER = 3;
        static final int COL_SPECIMEN = 4;
        static final int COL_COMMENTS = 5;
        static final int COL_AUTHOR = 6;
        static final int COL_IMAGES = 7;

        private TableModelSlideCell() {
        }

        public void setTableData(List<SpecimenRow> rows) {
            this.rows.clear();
            if (rows != null) {
                this.rows.addAll(rows);
            }
        }

        @Override
        public int getRowCount() {
            return this.rows.size();
        }

        @Override
        public int getColumnCount() {
            return COLUMN_TITLES.length;
        }

        @Override
        public Object getValueAt(int row, int col) {
            SpecimenRow specimenRow = this.rows.get(row);
            SlideStoreService.SpecimenSlide slide = specimenRow.slide();
            return switch (col) {
                case 0 -> slide.cabinet();
                case 1 -> slide.drawer();
                case 2 -> slide.slideBox();
                case 3 -> {
                    if (slide.slideCell() != null) {
                        yield slide.slideCell().getCellNumber();
                    }
                    yield "";
                }
                case 4 -> Objects.toString(specimenRow.taxon(), "");
                case 5 -> {
                    if (slide.specimen() != null) {
                        yield slide.specimen().getComments();
                    }
                    yield "";
                }
                case 6 -> {
                    if (slide.specimen() != null) {
                        yield slide.specimen().getAuthor();
                    }
                    yield "";
                }
                case 7 -> {
                    if (slide.specimen() != null) {
                        yield slide.nImages();
                    }
                    yield "";
                }
                default -> "";
            };
        }

        @Override
        public String[] getColumnTitles() {
            return COLUMN_TITLES;
        }

        @Override
        public String getPrefString() {
            return "TMSLIDECL";
        }

        @Override
        public String getPrefOrderString() {
            return "TOSLIDECL";
        }

        @Override
        public final String getAutoResizeString() {
            return "TARSLIDECL";
        }

        @Override
        public int[] getDefaultColumnWidths() {
            return COLUMN_WIDTHS;
        }

        @Override
        public void setupTable(JTable jTable, SBdb db) {
            this.init(jTable, db);
            this.restoreColumnOrder(jTable);
        }

        record SpecimenRow(SlideStoreService.SpecimenSlide slide, Taxon taxon) {
        }
    }
}

