/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import jsbugs.table.IObjectValidator;

public class CellWarningRenderer
implements TableCellRenderer {
    private final IObjectValidator validator;
    private int startingRow = 0;

    public CellWarningRenderer(IObjectValidator validator) {
        this.validator = validator;
    }

    public void setStartingRow(int rowNum) {
        this.startingRow = rowNum;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel label = new JLabel(value == null ? "" : value.toString(), 2);
        if (isSelected) {
            label.setBackground(table.getSelectionBackground());
            label.setForeground(table.getSelectionForeground());
        }
        label.setBorder(new EmptyBorder(1, 1, 1, 1));
        if (row >= this.startingRow && !this.validator.isValid(value == null ? "" : value)) {
            ImageIcon icon = isSelected ? new ImageIcon(this.getClass().getResource("/resources/icon/warning-selected.png"), "Warning") : new ImageIcon(this.getClass().getResource("/resources/icon/warning.png"), "Warning");
            label.setIcon(icon);
            label.setToolTipText(this.validator.getErrorMessage());
        }
        label.setOpaque(true);
        return label;
    }
}

