/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.sql.SQLException;
import javax.swing.JComboBox;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ComboEditor;
import jsbugs.table.FillableEditor;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.CompositeStandard;
import model3.SBdb;

public class CompositeStandardEditor
extends ComboEditor
implements FillableEditor,
AllowNullEditor {
    private boolean hasNull = false;

    public CompositeStandardEditor(SBdb sbdb) {
        super(new JComboBox());
        this.fill(sbdb);
    }

    @Override
    public final void fill(SBdb sbdb) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.removeAllItems();
        try {
            for (CompositeStandard std : sbdb.getCompositeStandards()) {
                combo.addItem(std);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        if (this.hasNull) {
            combo.insertItemAt(null, 0);
        }
    }

    public final void filter(CompositeStandard std) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.removeAllItems();
        if (this.hasNull) {
            combo.addItem(null);
        }
        combo.addItem(std);
    }

    @Override
    public void allowNullValue(boolean includeNull) {
        if (includeNull == this.hasNull) {
            return;
        }
        if (includeNull) {
            ((JComboBox)this.editorComponent).insertItemAt(null, 0);
        } else {
            ((JComboBox)this.editorComponent).removeItemAt(0);
        }
        this.hasNull = includeNull;
    }

    @Override
    public Object getCellEditorValue() {
        return ((JComboBox)this.getComponent()).getSelectedItem();
    }
}

