/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;

public class CountRenderer
extends DefaultTableCellRenderer {
    private static final Color EDITABLE_COLOUR = new Color(235, 255, 255);
    private static final Color NOT_EDITABLE_COLOUR = new Color(255, 255, 204);
    private final boolean editable;

    public CountRenderer(boolean editable) {
        this.editable = editable;
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.setBackground(this.editable ? EDITABLE_COLOUR : (isSelected ? table.getSelectionBackground() : NOT_EDITABLE_COLOUR));
        this.setForeground(!this.editable && isSelected ? table.getSelectionForeground() : table.getForeground());
        return this;
    }

    @Override
    public void setValue(Object value) {
        if (value == null || value.toString().equals("0")) {
            this.setText("");
        } else {
            this.setText(String.valueOf(value));
        }
    }
}

