/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import javax.swing.table.DefaultTableCellRenderer;

public class DateRenderer
extends DefaultTableCellRenderer {
    private static final String DATE_PATTERN = "dd-MMM-yyyy";
    private static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd-MMM-yyyy");

    public DateRenderer() {
        this.init();
    }

    private void init() {
        this.setHorizontalAlignment(2);
    }

    @Override
    public void setValue(Object value) {
        this.setText(this.getText(value));
    }

    private String getText(Object value) {
        if (value == null) {
            return "";
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            return DATE_FORMAT.format(date);
        }
        if (value instanceof LocalDate) {
            LocalDate localDate = (LocalDate)value;
            return localDate.format(DateTimeFormatter.ofPattern(DATE_PATTERN));
        }
        return "";
    }
}

