/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.awt.Component;
import javax.swing.BorderFactory;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.DepthRendererStringFormatter;

public class DepthCorrectionRenderer
extends DefaultTableCellRenderer {
    private static final Color colour = new Color(220, 220, 220);
    private Border selectedBorder = null;

    public DepthCorrectionRenderer() {
        this.init();
    }

    private void init() {
        this.setHorizontalAlignment(10);
        this.setBackground(colour);
        this.setOpaque(true);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object obj, boolean isSelected, boolean hasFocus, int row, int column) {
        if (isSelected) {
            if (this.selectedBorder == null) {
                this.selectedBorder = BorderFactory.createMatteBorder(2, 0, 2, 0, table.getSelectionBackground());
            }
            this.setBorder(this.selectedBorder);
        } else {
            this.setBorder(new LineBorder(new Color(220, 220, 220), 3));
        }
        this.setText(new DepthRendererStringFormatter().getFormattedString(obj, 2));
        return this;
    }
}

