/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.DepthRendererStringFormatter;
import org.apache.commons.lang3.StringUtils;
import util.DepthUnits;

public class DepthRenderer
extends DefaultTableCellRenderer {
    private int decimalPlaces = 2;
    private Character units = null;

    public DepthRenderer() {
        this(2);
    }

    public DepthRenderer(int decimalPlaces) {
        this.init();
        this.decimalPlaces = decimalPlaces;
    }

    private void init() {
        this.setHorizontalAlignment(10);
        this.setOpaque(true);
    }

    @Override
    public void setValue(Object value) {
        Object text = new DepthRendererStringFormatter().getFormattedString(value, this.decimalPlaces);
        if (this.units != null && StringUtils.isNotEmpty((CharSequence)text)) {
            text = (String)text + DepthUnits.getUnits((char)this.units.charValue()).getAbr();
        }
        this.setText((String)text);
    }

    public Character getUnits() {
        return this.units;
    }

    public void setUnits(Character units) {
        this.units = units;
    }
}

