/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.table.DefaultTableCellRenderer;

public class EditableComboCellRenderer
extends DefaultTableCellRenderer {
    private static final int HORIZONTAL_PADDING = 5;
    Color editableBackground = new Color(235, 255, 255);
    private final boolean isEditable;
    private final JLabel label;
    private final JPanel panel;
    private final JPanel arrowPanel;

    public EditableComboCellRenderer(boolean isEditable) {
        this.isEditable = isEditable;
        JComboBox box = new JComboBox();
        box.setEditable(true);
        JButton arrow = (JButton)box.getComponent(0);
        FlowLayout fl = new FlowLayout();
        fl.setHgap(0);
        fl.setVgap(0);
        this.arrowPanel = new JPanel(fl);
        this.arrowPanel.add(arrow);
        this.arrowPanel.setBorder(BorderFactory.createEmptyBorder(-1, 0, 0, 0));
        this.label = new JLabel();
        this.label.getVerticalTextPosition();
        this.panel = new JPanel();
        BorderLayout bl = new BorderLayout();
        bl.setHgap(0);
        bl.setVgap(0);
        this.panel.setLayout(bl);
        this.panel.add((Component)this.label, "Before");
        this.panel.add((Component)this.arrowPanel, "After");
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        if (value != null) {
            this.label.setText(value.toString());
            this.label.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
            this.setBackground(this.panel, isSelected, table);
            this.setBackground(this.arrowPanel, isSelected, table);
            this.setBorder(this.panel, isSelected, table);
            return this.panel;
        }
        return this;
    }

    private void setBackground(JPanel panel, boolean isSelected, JTable table) {
        if (this.isEditable && !isSelected) {
            panel.setBackground(this.editableBackground);
        } else if (this.isEditable && isSelected) {
            panel.setBackground(this.editableBackground);
            panel.setForeground(table.getForeground());
        }
    }

    private void setBorder(JPanel panel, boolean isSelected, JTable table) {
        Color unselectedBackground = this.isEditable ? this.editableBackground : table.getBackground();
        Color background = isSelected ? table.getSelectionBackground() : unselectedBackground;
        CompoundBorder selectedBorder = BorderFactory.createCompoundBorder();
        selectedBorder = BorderFactory.createCompoundBorder(selectedBorder, BorderFactory.createMatteBorder(2, 0, 2, 0, background));
        selectedBorder = BorderFactory.createCompoundBorder(selectedBorder, BorderFactory.createEmptyBorder(0, 5, 0, 1));
        panel.setBorder(selectedBorder);
    }
}

