/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Color;
import java.util.Objects;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.JTextField;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import jsbugs.table.TableCellUtils;
import jsbugs.table.VerifiedNumberEditor;

public class FloatEditor
extends VerifiedNumberEditor {
    public FloatEditor(final boolean allowNegitive) {
        this.setVerifier(new InputVerifier(this){
            final /* synthetic */ FloatEditor this$0;
            {
                FloatEditor floatEditor = this$0;
                Objects.requireNonNull(floatEditor);
                this.this$0 = floatEditor;
            }

            @Override
            public boolean verify(JComponent input) {
                boolean verified = true;
                String text = ((JTextField)input).getText();
                try {
                    Float f = Float.valueOf(text);
                    if (!allowNegitive && f.floatValue() < 0.0f) {
                        verified = false;
                    }
                }
                catch (NumberFormatException e) {
                    verified = false;
                }
                this.this$0.setFieldBorder(verified);
                return verified;
            }
        });
    }

    public FloatEditor(final float min, final float max) {
        this.setVerifier(new InputVerifier(this){
            final /* synthetic */ FloatEditor this$0;
            {
                FloatEditor floatEditor = this$0;
                Objects.requireNonNull(floatEditor);
                this.this$0 = floatEditor;
            }

            @Override
            public boolean verify(JComponent input) {
                boolean verified = true;
                String text = ((JTextField)input).getText();
                try {
                    Float f = Float.valueOf(text);
                    if (f.floatValue() < min || f.floatValue() > max) {
                        verified = false;
                    }
                }
                catch (NumberFormatException e) {
                    verified = false;
                }
                this.this$0.setFieldBorder(verified);
                return verified;
            }
        });
    }

    private void setFieldBorder(boolean verified) {
        JTextField field = (JTextField)this.editorComponent;
        field.setBorder(new CompoundBorder(new LineBorder(verified ? field.getBackground() : Color.RED), TableCellUtils.getEmptyBorder()));
    }
}

