/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import jsbugs.table.ComboEditor;
import jsbugs.table.FillableEditor;
import model3.IGDScheme;
import model3.SBdb;
import model3.exception.SuppressedSQLException;

public class IGDSchEditor
extends ComboEditor
implements FillableEditor {
    private final boolean allowNull;
    private final int igdType;

    public IGDSchEditor(SBdb sbdb, int igdType, boolean allowNull) {
        super(new JComboBox());
        this.allowNull = allowNull;
        this.igdType = igdType;
        this.fill(sbdb);
    }

    @Override
    public final void fill(SBdb sbdb) {
        this.fill(sbdb, null);
    }

    public final void fill(SBdb sbdb, IGDScheme toInclude) {
        JComboBox combo = (JComboBox)this.editorComponent;
        combo.removeAllItems();
        if (this.allowNull) {
            combo.insertItemAt(null, 0);
        }
        try {
            List<IGDScheme> schemes = sbdb.getIGDSchemes(this.igdType, toInclude);
            Collections.sort(schemes);
            for (IGDScheme scheme : schemes) {
                combo.addItem(scheme);
            }
        }
        catch (SQLException sql) {
            throw SuppressedSQLException.withoutRollback(sql);
        }
    }

    @Override
    public Object getCellEditorValue() {
        return ((JComboBox)this.getComponent()).getSelectedItem();
    }
}

