/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import jsbugs.table.ButtonEditor;

public class IntegerCollectionEditor
extends ButtonEditor {
    private final JFrame parent;
    HashSet<Integer> ints;

    public IntegerCollectionEditor(JFrame parent) {
        this.parent = parent;
    }

    @Override
    public Object getCellEditorValue() {
        return this.ints;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.ints = (HashSet)value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String input = JOptionPane.showInputDialog(this.parent, "Enter numbers separated by commas, or leave blank for none:", this.ints != null ? this.ints.toString().substring(1, this.ints.toString().length() - 1) : null);
        if (input == null) {
            this.fireEditingCanceled();
            return;
        }
        String[] numbers = input.split(",");
        this.ints = new HashSet();
        for (String s : numbers) {
            try {
                int i = Integer.parseInt(s.trim());
                if (i <= 0 || i >= 100) continue;
                this.ints.add(i);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.fireEditingStopped();
    }
}

