/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToggleButton;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbchart.block.BlockType;
import jsbugs.table.TableCellUtils;
import jsbugs.uiutil.icon.IconFactory;

public class LinkRenderer
extends DefaultTableCellRenderer {
    private static final Icon icon_linked = IconFactory.getPrefIcon("link");
    private static final Icon icon_linked_selected = IconFactory.getPrefIcon("link_w");
    private static final Icon icon_unlinked = IconFactory.getPrefIcon("unlink");
    private static final Icon icon_unlinked_selected = IconFactory.getPrefIcon("unlink_w");
    private final JPanel panel = new JPanel();
    private final JToggleButton button;
    private final JToggleButton blockTypeButton;
    private boolean displayButton = true;
    private boolean displayBlockType = false;

    public LinkRenderer() {
        JToggleButton[] buttons;
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.button = new JToggleButton();
        this.blockTypeButton = new JToggleButton();
        for (JToggleButton butt : buttons = new JToggleButton[]{this.button, this.blockTypeButton}) {
            butt.setContentAreaFilled(false);
            butt.setFocusPainted(false);
            butt.setBorderPainted(false);
        }
        TableCellUtils.setButtonDimensions(19, this.button);
        TableCellUtils.setButtonDimensions(14, this.blockTypeButton);
        this.blockTypeButton.setEnabled(false);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        JLabel oLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.panel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        oLabel.setBorder(new CompoundBorder(new LineBorder(oLabel.getBackground()), TableCellUtils.getEmptyBorder()));
        Dimension d = new Dimension(table.getColumnModel().getColumn(column).getWidth() - this.button.getPreferredSize().width - 1, 100);
        oLabel.setPreferredSize(d);
        this.panel.removeAll();
        this.panel.add(oLabel);
        if (this.displayBlockType || this.displayButton) {
            this.panel.add(Box.createHorizontalGlue());
            if (this.displayBlockType) {
                this.panel.add(this.blockTypeButton);
                this.blockTypeButton.setSelected(isSelected);
            }
            if (this.displayButton) {
                this.button.setIcon(isSelected ? icon_unlinked_selected : icon_unlinked);
                this.button.setSelectedIcon(isSelected ? icon_linked_selected : icon_linked);
                this.panel.add(this.button);
            }
        }
        return this.panel;
    }

    JToggleButton getButton() {
        return this.button;
    }

    public void setLinked(Boolean linked, BlockType blockType) {
        if (linked != null) {
            this.button.setSelected(linked);
        }
        boolean bl = this.displayButton = linked != null;
        if (blockType != null) {
            this.blockTypeButton.setIcon(blockType.getIcon());
            this.blockTypeButton.setSelectedIcon(blockType.getIconSelected());
            this.blockTypeButton.setDisabledIcon(blockType.getIcon());
            this.blockTypeButton.setDisabledSelectedIcon(blockType.getIconSelected());
        }
        this.displayBlockType = blockType != null;
    }
}

