/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.ListCellRenderer;
import jsbugs.DialogList;
import jsbugs.table.AllowNullEditor;
import jsbugs.table.ButtonEditor;

public class ListEditor
extends ButtonEditor
implements AllowNullEditor {
    private final Frame parent;
    private final String listDialogTitle;
    private List list;
    private Object selection;
    private final ListCellRenderer cellRenderer;

    public ListEditor(Frame parent, String listDialogTitle) {
        this(parent, listDialogTitle, null);
    }

    public ListEditor(Frame parent, String listDialogTitle, ListCellRenderer cellRenderer) {
        super("");
        this.parent = parent;
        this.listDialogTitle = listDialogTitle;
        this.cellRenderer = cellRenderer;
    }

    @Override
    public Object getCellEditorValue() {
        return this.selection;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            if (this.list.isEmpty()) {
                JOptionPane.showMessageDialog(this.parent, "There are no items to choose.", "Selection", 1);
                this.selection = null;
                this.fireEditingCanceled();
                return;
            }
            DialogList dialog = new DialogList(this.parent, true, this.listDialogTitle, null, this.list, true, false, this.cellRenderer);
            dialog.setLocationRelativeTo(this.renderer);
            dialog.setVisible(true);
            if (dialog.getSelection() != null) {
                this.selection = dialog.getSelection();
                this.fireEditingStopped();
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.selection = null;
            this.fireEditingStopped();
        }
    }

    public void setList(List list) {
        this.list = list;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.selection = value;
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void allowNullValue(boolean canClear) {
        this.renderer.canClear(canClear);
    }
}

