/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Dimension;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.border.CompoundBorder;
import javax.swing.border.LineBorder;
import javax.swing.table.DefaultTableCellRenderer;
import jsbugs.table.TableCellUtils;
import jsbugs.uiutil.icon.IconFactory;
import model3.SBRestrictable;

public class RestrictableRenderer
extends DefaultTableCellRenderer {
    private final JPanel panel = new JPanel();
    private final JButton button;

    public RestrictableRenderer() {
        this.panel.setLayout(new BoxLayout(this.panel, 0));
        this.button = new JButton();
        this.button.setContentAreaFilled(false);
        this.button.setFocusPainted(false);
        this.button.setBorderPainted(false);
        this.button.setMaximumSize(new Dimension(19, 100));
        this.button.setMinimumSize(new Dimension(19, 100));
        this.button.setPreferredSize(new Dimension(19, 10));
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        Icon icon;
        JLabel oLabel = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        this.panel.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
        oLabel.setBorder(new CompoundBorder(new LineBorder(oLabel.getBackground()), TableCellUtils.getEmptyBorder()));
        Dimension d = new Dimension(table.getColumnModel().getColumn(column).getWidth() - this.button.getPreferredSize().width - 1, 100);
        oLabel.setPreferredSize(d);
        this.panel.removeAll();
        this.panel.add(oLabel);
        if (value instanceof SBRestrictable && (icon = IconFactory.getIcon(((SBRestrictable)((Object)value)).getIconString())) != null) {
            this.panel.add(Box.createHorizontalGlue());
            this.button.setIcon(icon);
            this.panel.add(this.button);
        }
        return this.panel;
    }
}

