/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import javax.swing.table.DefaultTableCellRenderer;
import model3.Sample;
import org.apache.commons.lang3.StringUtils;

public class SampleRenderer
extends DefaultTableCellRenderer {
    private char units;
    private boolean showUnits;
    private boolean showLabels;

    public SampleRenderer(char units) {
        this.units = units;
        this.showLabels = false;
        this.showUnits = false;
        this.init();
    }

    private void init() {
        this.setHorizontalAlignment(10);
        this.setOpaque(true);
    }

    public void setUnits(char units) {
        this.units = units;
    }

    public boolean getShowUnits() {
        return this.showUnits;
    }

    public void setShowUnits(boolean showUnits) {
        this.showUnits = showUnits;
    }

    public boolean getShowLabels() {
        return this.showLabels;
    }

    public void setShowLabels(boolean showLabels) {
        this.showLabels = showLabels;
    }

    @Override
    public void setValue(Object value) {
        if (value == null) {
            this.setText("");
            return;
        }
        if (value instanceof Sample) {
            Sample sample = (Sample)value;
            this.setText(StringUtils.stripToEmpty((String)sample.toString(this.units, this.showUnits, this.showLabels, true)));
        } else {
            this.setText(StringUtils.stripToEmpty((String)value.toString()));
        }
    }
}

