/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.sql.SQLException;
import java.util.Collections;
import java.util.List;
import javax.swing.JComboBox;
import jsbugs.table.ComboEditor;
import jsbugs.userconnect.SbugsExceptionHandler;
import model3.DataType;
import model3.IGDScheme;
import model3.SBdb;

public class SchemeEditor
extends ComboEditor {
    private DataType lastDataType;
    private Boolean lastNull;

    public SchemeEditor() {
        super(new JComboBox());
    }

    public void fill(DataType dataType, boolean includeNull, SBdb sbdb) {
        JComboBox combo = (JComboBox)this.editorComponent;
        if (this.lastDataType != null && this.lastNull != null && this.lastDataType == dataType && this.lastNull == includeNull) {
            return;
        }
        combo.removeAllItems();
        if (includeNull) {
            combo.addItem("all");
        }
        try {
            List<IGDScheme> schemes = sbdb.getIGDSchemes(dataType);
            Collections.sort(schemes);
            for (IGDScheme scheme : schemes) {
                combo.addItem(scheme);
            }
        }
        catch (SQLException sql) {
            SbugsExceptionHandler.showStackError(sql);
        }
        this.lastDataType = dataType;
        this.lastNull = includeNull;
    }

    @Override
    public Object getCellEditorValue() {
        Object o = ((JComboBox)this.getComponent()).getSelectedItem();
        if (o instanceof String) {
            return null;
        }
        return o;
    }
}

