/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table;

import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.sql.SQLException;
import java.util.List;
import javax.swing.JTable;
import jsbchart.panel.spatial.SBShapeFileException;
import jsbchart.panel.spatial.SBShapeStore;
import jsbchart.panel.spatial.ShapeDataStoreException;
import jsbchart.panel.spatial.ShapeDataStoreProvider;
import jsbchart.panel.spatial.ShapeStoreService;
import jsbugs.DialogList;
import jsbugs.chart.spatial.DialogSBShapeStores;
import jsbugs.table.ButtonEditor;
import jsbugs.userconnect.SbugsExceptionHandler;

public class ShapeStoreEditor
extends ButtonEditor {
    private final Frame parentFrame;
    private final ShapeStoreService shapeStoreService;
    private SBShapeStore.SBShapeStoreWithFeatureTypeName shapeStore;

    public ShapeStoreEditor(Frame parentFrame, ShapeStoreService shapeStoreService) {
        this.parentFrame = parentFrame;
        this.shapeStoreService = shapeStoreService;
        this.renderer.canClear(true);
    }

    @Override
    public Object getCellEditorValue() {
        return this.shapeStore;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.shapeStore = new SBShapeStore.SBShapeStoreWithFeatureTypeName((SBShapeStore)value);
        return this.renderer.getTableCellRendererComponent(table, value, isSelected, isSelected, row, column);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.renderer.getButton()) {
            DialogSBShapeStores dialog;
            try {
                dialog = new DialogSBShapeStores(this.parentFrame, true, this.shapeStoreService);
            }
            catch (RuntimeException | SQLException sql) {
                SbugsExceptionHandler.showDialogStackError(sql, this.parentFrame);
                return;
            }
            dialog.setLocationRelativeTo(this.parentFrame);
            dialog.setVisible(true);
            if (dialog.isOK()) {
                SBShapeStore selected = dialog.getSelected();
                try {
                    this.shapeStoreService.initShapeStore(selected);
                }
                catch (SBShapeFileException ex) {
                    SbugsExceptionHandler.showStackError(ex, this.parentFrame);
                    this.fireEditingCanceled();
                    return;
                }
                this.shapeStore = new SBShapeStore.SBShapeStoreWithFeatureTypeName(selected);
                try {
                    List<String> featureTypes = ShapeDataStoreProvider.getFeatureTypeNames(this.shapeStore.store);
                    if (featureTypes.size() == 1) {
                        this.shapeStore.setFeatureTypeName(featureTypes.get(0));
                    } else {
                        DialogList<String> listDialog = new DialogList<String>(this.parentFrame, true, "Select Feature Type", null, featureTypes, true, false);
                        listDialog.setLocationRelativeTo(this.parentFrame);
                        listDialog.setVisible(true);
                        if (listDialog.getSelection() != null) {
                            this.shapeStore.setFeatureTypeName(listDialog.getSelection());
                        }
                    }
                    this.fireEditingStopped();
                }
                catch (IOException | RuntimeException | ShapeDataStoreException ex) {
                    SbugsExceptionHandler.showStackError(ex, this.parentFrame);
                    this.fireEditingCanceled();
                }
            } else {
                this.fireEditingCanceled();
            }
        } else if (e.getSource() == this.renderer.getClearButton()) {
            this.shapeStore = null;
            this.fireEditingStopped();
        }
    }
}

