/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table.cell.editor;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.LineBorder;
import javax.swing.table.TableCellEditor;

public class AllowNullIntegerEditor
extends AbstractCellEditor
implements TableCellEditor {
    JTextField textField = new JTextField();
    Object value;

    public AllowNullIntegerEditor() {
        this.textField.setHorizontalAlignment(4);
    }

    @Override
    public boolean isCellEditable(EventObject e) {
        if (e instanceof MouseEvent) {
            return ((MouseEvent)e).getClickCount() >= 2;
        }
        return true;
    }

    @Override
    public boolean stopCellEditing() {
        String s = this.textField.getText();
        if (s.trim().isEmpty()) {
            this.value = null;
        } else {
            try {
                this.value = new Integer(s);
            }
            catch (Exception e) {
                this.textField.setBorder(new LineBorder(Color.red));
                return false;
            }
        }
        return super.stopCellEditing();
    }

    @Override
    public Object getCellEditorValue() {
        return this.value;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.value = null;
        this.textField.setFont(table.getFont());
        if (value != null) {
            this.textField.setText(value.toString());
        } else {
            this.textField.setText("");
        }
        this.textField.setBorder(new LineBorder(Color.black));
        return this.textField;
    }
}

