/*
 * Decompiled with CFR 0.152.
 */
package jsbugs.table.cell.renderer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PercentagePanel
extends JPanel {
    private Object value = null;
    private Color fillColour = new Color(173, 216, 230);
    private JLabel jLabelPercentage;
    NumberFormat formatter = new DecimalFormat("0.# %");

    public PercentagePanel() {
        this.initComponents();
    }

    public void setColour(Color c) {
        this.fillColour = c;
    }

    public void setTextColour(Color c) {
        this.jLabelPercentage.setForeground(c);
    }

    public void setValue(Object value) {
        this.value = value;
        if (value == null) {
            this.setText("");
            return;
        }
        if (value instanceof Number) {
            Number n = (Number)value;
            if (n.floatValue() <= 0.0f) {
                this.setText("");
            } else if (n.floatValue() < 0.001f) {
                this.setText("< 0.1 %");
            } else {
                this.setText(this.formatter.format(value));
            }
        } else {
            this.setText(value.toString());
        }
        this.invalidate();
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.value instanceof Number) {
            float f = ((Number)this.value).floatValue();
            if (f > 1.0f) {
                f = 1.0f;
            } else if (f < 0.0f) {
                f = 0.0f;
            }
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setColor(this.fillColour);
            g2.fillRect(0, 0, (int)((float)this.getWidth() * f), this.getHeight());
        }
    }

    private void setText(String text) {
        this.jLabelPercentage.setText(text);
    }

    private void initComponents() {
        this.jLabelPercentage = new JLabel();
        this.setLayout(new BorderLayout());
        this.jLabelPercentage.setHorizontalAlignment(0);
        this.jLabelPercentage.setText("jLabel1");
        this.add((Component)this.jLabelPercentage, "Center");
    }
}

